/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedView
extends Table
implements SQLQueryOwner {
    public static final String TYPE = "MATERIALIZED VIEW";
    private boolean m_updatable;
    private boolean m_rewrite;
    private RewriteCapability m_rewriteType;
    private RefreshMode m_refreshMode;
    private RefreshMethod m_refreshMethod;
    private FastRefreshable m_fastRefresh;
    private RefreshMethod m_lastRefreshType;
    private Date m_lastRefreshDate;
    private Date m_nextRefreshDate;
    private Staleness m_staleness;
    private BuildType m_buildType;
    private PrebuiltType m_prebuilt;
    private boolean m_useNoIndex;
    private String m_interval;
    private RefreshWith m_keyType;
    private UsingConstraints m_usingConstraints;
    private RollbackSegmentType m_rsType;
    private String m_rsName;
    private boolean m_cache;
    private List<String> m_masters;
    private SQLQuery m_query;
    private int m_parallel;
    private boolean m_compression;

    @Override
    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
    }

    @Override
    public void setProperties(Map properties) {
        super.setProperties(properties);
    }

    private void $init$() {
        this.m_rewriteType = RewriteCapability.NONE;
        this.m_refreshMode = RefreshMode.DEMAND;
        this.m_refreshMethod = RefreshMethod.COMPLETE;
        this.m_fastRefresh = FastRefreshable.NO;
        this.m_lastRefreshType = RefreshMethod.COMPLETE;
        this.m_staleness = Staleness.FRESH;
        this.m_buildType = BuildType.IMMEDIATE;
        this.m_prebuilt = PrebuiltType.NONE;
        this.m_keyType = RefreshWith.UNSPECIFIED;
        this.m_usingConstraints = UsingConstraints.ENFORCED;
        this.m_rsType = RollbackSegmentType.NONE;
        this.m_masters = new ArrayList<String>();
        this.m_parallel = 1;
        this.m_compression = false;
    }

    public MaterializedView() {
        this.$init$();
    }

    public MaterializedView(String name, Schema schema) {
        super(name, schema);
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        MaterializedView copy = target != null ? (MaterializedView)target : new MaterializedView();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MaterializedView && this.equalsImpl((MaterializedView)o);
    }

    protected void copyToImpl(MaterializedView copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_updatable = this.m_updatable;
        copy.m_rewrite = this.m_rewrite;
        copy.m_rewriteType = this.m_rewriteType;
        copy.m_refreshMode = this.m_refreshMode;
        copy.m_refreshMethod = this.m_refreshMethod;
        copy.m_fastRefresh = this.m_fastRefresh;
        copy.m_lastRefreshType = this.m_lastRefreshType;
        copy.m_lastRefreshDate = this.m_lastRefreshDate == null ? null : (Date)this.m_lastRefreshDate.clone();
        copy.m_staleness = this.m_staleness;
        copy.m_buildType = this.m_buildType;
        copy.m_prebuilt = this.m_prebuilt;
        copy.m_useNoIndex = this.m_useNoIndex;
        copy.m_rsType = this.m_rsType;
        copy.m_rsName = this.m_rsName;
        copy.m_nextRefreshDate = this.m_nextRefreshDate;
        copy.m_interval = this.m_interval;
        copy.m_cache = this.m_cache;
        copy.m_parallel = this.m_parallel;
        copy.m_compression = this.m_compression;
        copy.m_keyType = this.m_keyType;
        copy.m_usingConstraints = this.m_usingConstraints;
        copy.m_masters.clear();
        copy.m_masters.addAll(this.m_masters);
        copy.setSQLQuery(this.copyObject(this.m_query, copy, idPolicy));
    }

    protected boolean equalsImpl(MaterializedView copy) {
        return super.equalsImpl(copy) && copy.m_updatable == this.m_updatable && copy.m_rewrite == this.m_rewrite && copy.m_rewriteType == this.m_rewriteType && copy.m_refreshMode == this.m_refreshMode && copy.m_refreshMethod == this.m_refreshMethod && copy.m_fastRefresh == this.m_fastRefresh && copy.m_lastRefreshType == this.m_lastRefreshType && copy.m_staleness == this.m_staleness && copy.m_buildType == this.m_buildType && copy.m_prebuilt == this.m_prebuilt && copy.m_useNoIndex == this.m_useNoIndex && copy.m_rsType == this.m_rsType && copy.m_rsName == this.m_rsName && copy.m_nextRefreshDate == this.m_nextRefreshDate && copy.m_interval == this.m_interval && copy.m_keyType == this.m_keyType && copy.m_usingConstraints == this.m_usingConstraints && copy.m_cache == this.m_cache && copy.m_parallel == this.m_parallel && copy.m_compression == this.m_compression && ModelUtil.areEqual((Object)copy.m_lastRefreshDate, (Object)this.m_lastRefreshDate) && ModelUtil.areEqual(copy.m_masters, this.m_masters) && ModelUtil.areEqual((Object)copy.m_query, (Object)this.m_query);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public SQLQuery getSQLQuery() {
        this.checkInit("SQLQuery");
        return this.m_query;
    }

    @Override
    public void setSQLQuery(SQLQuery query) {
        this.checkInit("SQLQuery");
        this.changeParent(this.m_query, query);
        this.m_query = query;
    }

    @Transient
    public String getViewText() {
        this.checkInit(TYPE);
        return this.m_query == null ? null : this.m_query.getSQLText().trim();
    }

    public void setUpdatable(boolean updatable) {
        this.checkInit(TYPE);
        this.m_updatable = updatable;
    }

    public boolean isUpdatable() {
        this.checkInit(TYPE);
        return this.m_updatable;
    }

    public void setRewrite(boolean rewrite) {
        this.checkInit(TYPE);
        this.m_rewrite = rewrite;
    }

    public boolean isRewrite() {
        this.checkInit(TYPE);
        return this.m_rewrite;
    }

    public void setRewriteType(RewriteCapability rewriteType) {
        this.checkInit(TYPE);
        this.m_rewriteType = rewriteType;
    }

    public RewriteCapability getRewriteType() {
        this.checkInit(TYPE);
        return this.m_rewriteType;
    }

    public void setRefreshMode(RefreshMode refreshMode) {
        this.checkInit(TYPE);
        this.m_refreshMode = refreshMode;
    }

    public RefreshMode getRefreshMode() {
        this.checkInit(TYPE);
        return this.m_refreshMode;
    }

    public void setRefreshMethod(RefreshMethod refreshMethod) {
        this.checkInit(TYPE);
        this.m_refreshMethod = refreshMethod;
    }

    public RefreshMethod getRefreshMethod() {
        this.checkInit(TYPE);
        return this.m_refreshMethod;
    }

    public void setFastRefresh(FastRefreshable fastRefresh) {
        this.checkInit(TYPE);
        this.m_fastRefresh = fastRefresh;
    }

    public FastRefreshable getFastRefresh() {
        this.checkInit(TYPE);
        return this.m_fastRefresh;
    }

    public void setLastRefreshType(RefreshMethod lastRefreshType) {
        this.checkInit(TYPE);
        this.m_lastRefreshType = lastRefreshType;
    }

    public RefreshMethod getLastRefreshType() {
        this.checkInit(TYPE);
        return this.m_lastRefreshType;
    }

    public void setLastRefreshDate(Date lastRefreshDate) {
        this.checkInit(TYPE);
        this.m_lastRefreshDate = lastRefreshDate;
    }

    public Date getLastRefreshDate() {
        this.checkInit(TYPE);
        return this.m_lastRefreshDate;
    }

    public void setNextRefreshDate(Date nextRefreshDate) {
        this.checkInit(TYPE);
        this.m_nextRefreshDate = nextRefreshDate;
    }

    public Date getNextRefreshDate() {
        this.checkInit(TYPE);
        return this.m_nextRefreshDate;
    }

    @Transient
    @Deprecated
    public String getNextRefresh() {
        Date d = this.getNextRefreshDate();
        return d == null ? null : d.toString();
    }

    @Transient
    @Deprecated
    public void setNextRefresh(String nextStr) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            this.setNextRefreshDate(fmt.parse(nextStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getInterval() {
        this.checkInit(TYPE);
        return this.m_interval;
    }

    public void setInterval(String interval) {
        this.checkInit(TYPE);
        this.m_interval = interval;
    }

    public void setStaleness(Staleness staleness) {
        this.checkInit(TYPE);
        this.m_staleness = staleness;
    }

    public Staleness getStaleness() {
        this.checkInit(TYPE);
        return this.m_staleness;
    }

    public void setBuildType(BuildType buildType) {
        this.checkInit(TYPE);
        this.m_buildType = buildType;
    }

    public BuildType getBuildType() {
        this.checkInit(TYPE);
        return this.m_buildType;
    }

    public void setOnPrebuilt(PrebuiltType prebuilt) {
        this.checkInit(TYPE);
        this.m_prebuilt = prebuilt;
    }

    public PrebuiltType getOnPrebuilt() {
        this.checkInit(TYPE);
        return this.m_prebuilt;
    }

    public void setUseNoIndex(boolean useNoIndex) {
        this.checkInit(TYPE);
        this.m_useNoIndex = useNoIndex;
    }

    public boolean isUseNoIndex() {
        this.checkInit(TYPE);
        return this.m_useNoIndex;
    }

    @Transient
    @Deprecated
    public void setIndexPercentFree(int indexPctFree) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setPercentFree(indexPctFree);
    }

    @Deprecated
    public int getIndexPercentFree() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentFree();
    }

    @Transient
    @Deprecated
    public void setIndexPercentUsed(int indexPctUsed) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setPercentUsed(indexPctUsed);
    }

    @Transient
    @Deprecated
    public int getIndexPercentUsed() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentUsed();
    }

    @Deprecated
    @Transient
    public void setIndexInitTrans(int indexInitTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setInitrans(indexInitTrans);
    }

    @Deprecated
    public int getIndexInitTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Deprecated
    @Transient
    public void setMaxTrans(int maxTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setMaxtrans(maxTrans);
    }

    @Deprecated
    public int getMaxTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getMaxtrans();
    }

    @Deprecated
    @Transient
    public void setMinTrans(int minTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setInitrans(minTrans);
    }

    @Deprecated
    public int getMinTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Deprecated
    @Transient
    public void setInitExtent(int initExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setInitialExtent(initExtent);
    }

    @Deprecated
    public int getInitExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitialExtent();
    }

    @Transient
    @Deprecated
    public void setNextExtent(int nextExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setNextExtent(nextExtent);
    }

    @Deprecated
    public int getNextExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getNextExtent();
    }

    @Deprecated
    @Transient
    public void setIndexMinExtent(int indexMinExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setMinExtent(indexMinExtent);
    }

    @Deprecated
    public int getIndexMinExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMinExtent();
    }

    @Deprecated
    @Transient
    public void setIndexMaxExtent(int indexMaxExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setMaxExtent(indexMaxExtent);
    }

    @Deprecated
    public int getIndexMaxExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMaxExtent();
    }

    @Deprecated
    public String getTablespace() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? null : osp.getTablespace();
    }

    @Deprecated
    @Transient
    public void setTablespace(String tablespace) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setTablespace(tablespace);
    }

    public void setCache(boolean cache) {
        this.checkInit(TYPE);
        this.m_cache = cache;
    }

    public boolean isCache() {
        this.checkInit(TYPE);
        return this.m_cache;
    }

    public void setMasters(String[] masters) {
        this.checkInit(TYPE);
        this.m_masters.clear();
        if (masters != null) {
            String[] stringArray = masters;
            int n = 0;
            while (n < stringArray.length) {
                String m = stringArray[n];
                this.m_masters.add(m);
                ++n;
            }
        }
    }

    public String[] getMasters() {
        this.checkInit(TYPE);
        return this.m_masters.toArray(new String[this.m_masters.size()]);
    }

    public RefreshWith getKeyType() {
        this.checkInit(TYPE);
        return this.m_keyType;
    }

    public void setKeyType(RefreshWith keyType) {
        this.checkInit(TYPE);
        this.m_keyType = keyType;
    }

    public UsingConstraints getUsingConstraints() {
        this.checkInit(TYPE);
        return this.m_usingConstraints;
    }

    public void setUsingConstraints(UsingConstraints c) {
        this.checkInit(TYPE);
        this.m_usingConstraints = c;
    }

    public RollbackSegmentType getRollbackSegmentType() {
        this.checkInit(TYPE);
        return this.m_rsType;
    }

    public void setRollbackSegmentType(RollbackSegmentType rsType) {
        this.checkInit(TYPE);
        this.m_rsType = rsType;
    }

    public String getRollbackSegmentName() {
        this.checkInit(TYPE);
        return this.m_rsName;
    }

    public void setRollbackSegmentName(String rsName) {
        this.checkInit(TYPE);
        this.m_rsName = rsName;
    }

    @Override
    public boolean isDeclarative() {
        this.checkInit("SQLQuery");
        return this.m_query != null && this.m_query instanceof DeclarativeSQLQuery;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_query, types);
    }

    public void setParallel(int parallel) {
        this.checkInit(TYPE);
        this.m_parallel = parallel;
    }

    public int getParallel() {
        this.checkInit(TYPE);
        return this.m_parallel;
    }

    public void setCompression(boolean compression) {
        this.checkInit(TYPE);
        this.m_compression = compression;
    }

    public boolean isCompression() {
        this.checkInit(TYPE);
        return this.m_compression;
    }

    private OracleStorageProperties getOracleStorageProperties(boolean onIndex, boolean createIfNotFound) {
        String key = onIndex ? "MatViewIndexStorageProperties" : "OracleStorageProperties";
        OracleStorageProperties osp = (OracleStorageProperties)this.getProperty(key);
        if (osp == null && createIfNotFound) {
            osp = new OracleStorageProperties();
            this.setProperty(key, osp);
        }
        return osp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RewriteCapability
    extends Enum<RewriteCapability> {
        private static final /* synthetic */ RewriteCapability[] $v;
        public static final /* enum */ RewriteCapability NONE;
        public static final /* enum */ RewriteCapability TEXTMATCH;
        public static final /* enum */ RewriteCapability GENERAL;

        public static RewriteCapability valueOf(String string) {
            return Enum.valueOf(RewriteCapability.class, string);
        }

        public static final RewriteCapability[] values() {
            return (RewriteCapability[])$v.clone();
        }

        static {
            RewriteCapability[] rewriteCapabilityArray = new RewriteCapability[3];
            rewriteCapabilityArray[2] = GENERAL = new RewriteCapability("GENERAL", 2);
            rewriteCapabilityArray[1] = TEXTMATCH = new RewriteCapability("TEXTMATCH", 1);
            rewriteCapabilityArray[0] = NONE = new RewriteCapability("NONE", 0);
            $v = rewriteCapabilityArray;
        }

        private RewriteCapability(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RefreshMode
    extends Enum<RefreshMode> {
        private static final /* synthetic */ RefreshMode[] $v;
        public static final /* enum */ RefreshMode DEMAND;
        public static final /* enum */ RefreshMode COMMIT;
        public static final /* enum */ RefreshMode NEVER;
        public static final /* enum */ RefreshMode SPECIFY;

        public static RefreshMode valueOf(String string) {
            return Enum.valueOf(RefreshMode.class, string);
        }

        public static final RefreshMode[] values() {
            return (RefreshMode[])$v.clone();
        }

        static {
            RefreshMode[] refreshModeArray = new RefreshMode[4];
            refreshModeArray[3] = SPECIFY = new RefreshMode("SPECIFY", 3);
            refreshModeArray[2] = NEVER = new RefreshMode("NEVER", 2);
            refreshModeArray[1] = COMMIT = new RefreshMode("COMMIT", 1);
            refreshModeArray[0] = DEMAND = new RefreshMode("DEMAND", 0);
            $v = refreshModeArray;
        }

        private RefreshMode(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RefreshMethod
    extends Enum<RefreshMethod> {
        private static final /* synthetic */ RefreshMethod[] $v;
        public static final /* enum */ RefreshMethod NEVER;
        public static final /* enum */ RefreshMethod FAST;
        public static final /* enum */ RefreshMethod COMPLETE;
        public static final /* enum */ RefreshMethod FORCE;
        public static final /* enum */ RefreshMethod NA;

        public static RefreshMethod valueOf(String string) {
            return Enum.valueOf(RefreshMethod.class, string);
        }

        public static final RefreshMethod[] values() {
            return (RefreshMethod[])$v.clone();
        }

        static {
            RefreshMethod[] refreshMethodArray = new RefreshMethod[5];
            refreshMethodArray[4] = NA = new RefreshMethod("NA", 4);
            refreshMethodArray[3] = FORCE = new RefreshMethod("FORCE", 3);
            refreshMethodArray[2] = COMPLETE = new RefreshMethod("COMPLETE", 2);
            refreshMethodArray[1] = FAST = new RefreshMethod("FAST", 1);
            refreshMethodArray[0] = NEVER = new RefreshMethod("NEVER", 0);
            $v = refreshMethodArray;
        }

        private RefreshMethod(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FastRefreshable
    extends Enum<FastRefreshable> {
        private static final /* synthetic */ FastRefreshable[] $v;
        public static final /* enum */ FastRefreshable NO;
        public static final /* enum */ FastRefreshable DIRLOAD;
        public static final /* enum */ FastRefreshable DML;
        public static final /* enum */ FastRefreshable DIRLOAD_DML;
        public static final /* enum */ FastRefreshable DIRLOAD_LIMITEDDML;

        public static FastRefreshable valueOf(String string) {
            return Enum.valueOf(FastRefreshable.class, string);
        }

        public static final FastRefreshable[] values() {
            return (FastRefreshable[])$v.clone();
        }

        static {
            FastRefreshable[] fastRefreshableArray = new FastRefreshable[5];
            fastRefreshableArray[4] = DIRLOAD_LIMITEDDML = new FastRefreshable("DIRLOAD_LIMITEDDML", 4);
            fastRefreshableArray[3] = DIRLOAD_DML = new FastRefreshable("DIRLOAD_DML", 3);
            fastRefreshableArray[2] = DML = new FastRefreshable("DML", 2);
            fastRefreshableArray[1] = DIRLOAD = new FastRefreshable("DIRLOAD", 1);
            fastRefreshableArray[0] = NO = new FastRefreshable("NO", 0);
            $v = fastRefreshableArray;
        }

        private FastRefreshable(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Staleness
    extends Enum<Staleness> {
        private static final /* synthetic */ Staleness[] $v;
        public static final /* enum */ Staleness FRESH;
        public static final /* enum */ Staleness STALE;
        public static final /* enum */ Staleness UNUSABLE;
        public static final /* enum */ Staleness UNKNOWN;
        public static final /* enum */ Staleness UNDEFINED;
        public static final /* enum */ Staleness NEEDS_COMPILE;

        public static Staleness valueOf(String string) {
            return Enum.valueOf(Staleness.class, string);
        }

        public static final Staleness[] values() {
            return (Staleness[])$v.clone();
        }

        static {
            Staleness[] stalenessArray = new Staleness[6];
            stalenessArray[5] = NEEDS_COMPILE = new Staleness("NEEDS_COMPILE", 5);
            stalenessArray[4] = UNDEFINED = new Staleness("UNDEFINED", 4);
            stalenessArray[3] = UNKNOWN = new Staleness("UNKNOWN", 3);
            stalenessArray[2] = UNUSABLE = new Staleness("UNUSABLE", 2);
            stalenessArray[1] = STALE = new Staleness("STALE", 1);
            stalenessArray[0] = FRESH = new Staleness("FRESH", 0);
            $v = stalenessArray;
        }

        private Staleness(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PrebuiltType
    extends Enum<PrebuiltType> {
        private static final /* synthetic */ PrebuiltType[] $v;
        public static final /* enum */ PrebuiltType NONE;
        public static final /* enum */ PrebuiltType UNSPECIFIED_PRECISION;
        public static final /* enum */ PrebuiltType WITH_REDUCED_PRECISION;
        public static final /* enum */ PrebuiltType WITHOUT_REDUCED_PRECISION;

        public static PrebuiltType valueOf(String string) {
            return Enum.valueOf(PrebuiltType.class, string);
        }

        public static final PrebuiltType[] values() {
            return (PrebuiltType[])$v.clone();
        }

        static {
            PrebuiltType[] prebuiltTypeArray = new PrebuiltType[4];
            prebuiltTypeArray[3] = WITHOUT_REDUCED_PRECISION = new PrebuiltType("WITHOUT_REDUCED_PRECISION", 3);
            prebuiltTypeArray[2] = WITH_REDUCED_PRECISION = new PrebuiltType("WITH_REDUCED_PRECISION", 2);
            prebuiltTypeArray[1] = UNSPECIFIED_PRECISION = new PrebuiltType("UNSPECIFIED_PRECISION", 1);
            prebuiltTypeArray[0] = NONE = new PrebuiltType("NONE", 0);
            $v = prebuiltTypeArray;
        }

        private PrebuiltType(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BuildType
    extends Enum<BuildType> {
        private static final /* synthetic */ BuildType[] $v;
        public static final /* enum */ BuildType IMMEDIATE;
        public static final /* enum */ BuildType DEFERRED;
        public static final /* enum */ BuildType PREBUILT;

        public static BuildType valueOf(String string) {
            return Enum.valueOf(BuildType.class, string);
        }

        public static final BuildType[] values() {
            return (BuildType[])$v.clone();
        }

        static {
            BuildType[] buildTypeArray = new BuildType[3];
            buildTypeArray[2] = PREBUILT = new BuildType("PREBUILT", 2);
            buildTypeArray[1] = DEFERRED = new BuildType("DEFERRED", 1);
            buildTypeArray[0] = IMMEDIATE = new BuildType("IMMEDIATE", 0);
            $v = buildTypeArray;
        }

        private BuildType(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RefreshWith
    extends Enum<RefreshWith> {
        private static final /* synthetic */ RefreshWith[] $v;
        public static final /* enum */ RefreshWith UNSPECIFIED;
        public static final /* enum */ RefreshWith PRIMARY_KEY;
        public static final /* enum */ RefreshWith ROWID;

        public static RefreshWith valueOf(String string) {
            return Enum.valueOf(RefreshWith.class, string);
        }

        public static final RefreshWith[] values() {
            return (RefreshWith[])$v.clone();
        }

        static {
            RefreshWith[] refreshWithArray = new RefreshWith[3];
            refreshWithArray[2] = ROWID = new RefreshWith("ROWID", 2);
            refreshWithArray[1] = PRIMARY_KEY = new RefreshWith("PRIMARY_KEY", 1);
            refreshWithArray[0] = UNSPECIFIED = new RefreshWith("UNSPECIFIED", 0);
            $v = refreshWithArray;
        }

        private RefreshWith(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RollbackSegmentType
    extends Enum<RollbackSegmentType> {
        private static final /* synthetic */ RollbackSegmentType[] $v;
        public static final /* enum */ RollbackSegmentType NONE;
        public static final /* enum */ RollbackSegmentType LOCAL;
        public static final /* enum */ RollbackSegmentType MASTER;

        public static RollbackSegmentType valueOf(String string) {
            return Enum.valueOf(RollbackSegmentType.class, string);
        }

        public static final RollbackSegmentType[] values() {
            return (RollbackSegmentType[])$v.clone();
        }

        static {
            RollbackSegmentType[] rollbackSegmentTypeArray = new RollbackSegmentType[3];
            rollbackSegmentTypeArray[2] = MASTER = new RollbackSegmentType("MASTER", 2);
            rollbackSegmentTypeArray[1] = LOCAL = new RollbackSegmentType("LOCAL", 1);
            rollbackSegmentTypeArray[0] = NONE = new RollbackSegmentType("NONE", 0);
            $v = rollbackSegmentTypeArray;
        }

        private RollbackSegmentType(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UsingConstraints
    extends Enum<UsingConstraints> {
        private static final /* synthetic */ UsingConstraints[] $v;
        public static final /* enum */ UsingConstraints TRUSTED;
        public static final /* enum */ UsingConstraints ENFORCED;

        public static UsingConstraints valueOf(String string) {
            return Enum.valueOf(UsingConstraints.class, string);
        }

        public static final UsingConstraints[] values() {
            return (UsingConstraints[])$v.clone();
        }

        static {
            UsingConstraints[] usingConstraintsArray = new UsingConstraints[2];
            usingConstraintsArray[1] = ENFORCED = new UsingConstraints("ENFORCED", 1);
            usingConstraintsArray[0] = TRUSTED = new UsingConstraints("TRUSTED", 0);
            $v = usingConstraintsArray;
        }

        private UsingConstraints(String string2, int n2) {
        }
    }
}

