/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewLog
extends AbstractSchemaObject {
    public static final String TYPE = "MATERIALIZED VIEW LOG";
    private DBObjectID _masterTableID;
    private String m_logTable;
    private Boolean m_rowid;
    private Boolean m_pk;
    private Boolean m_objectid;
    private Boolean m_sequence;
    private Boolean m_newValues;
    private int m_parallel;
    private Boolean m_cache;
    private ArrayList<DBObjectID> m_columnIDs;
    private boolean m_filter;

    private void $init$() {
        this.m_parallel = 1;
        this.m_columnIDs = new ArrayList();
        this.m_filter = false;
    }

    public MaterializedViewLog() {
        this.$init$();
    }

    public MaterializedViewLog(String name, Schema schema) {
        super(name, schema);
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        MaterializedViewLog copy = target instanceof MaterializedViewLog ? (MaterializedViewLog)target : new MaterializedViewLog();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(MaterializedViewLog copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy._masterTableID = this._masterTableID;
        copy.m_logTable = this.m_logTable;
        copy.m_rowid = this.m_rowid;
        copy.m_pk = this.m_pk;
        copy.m_objectid = this.m_objectid;
        copy.m_sequence = this.m_sequence;
        copy.m_filter = this.m_filter;
        copy.m_newValues = this.m_newValues;
        copy.m_parallel = this.m_parallel;
        copy.m_cache = this.m_cache;
        copy.m_columnIDs.clear();
        copy.m_columnIDs.addAll(this.m_columnIDs);
    }

    public boolean equals(Object o) {
        return o instanceof MaterializedViewLog && this.equalsImpl((MaterializedViewLog)o);
    }

    protected boolean equalsImpl(MaterializedViewLog copy) {
        return super.equalsImpl(copy) && ModelUtil.areEqual((Object)this._masterTableID, (Object)copy._masterTableID) && ModelUtil.areEqual((Object)this.m_logTable, (Object)copy.m_logTable) && ModelUtil.areEqual(this.m_columnIDs, copy.m_columnIDs) && this.m_rowid == copy.m_rowid && this.m_pk == copy.m_pk && this.m_sequence == copy.m_sequence && this.m_objectid == copy.m_objectid && this.m_filter == copy.m_filter && this.m_newValues == copy.m_newValues && this.m_parallel == copy.m_parallel && this.m_cache == copy.m_cache;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public DBObjectID getMasterTableID() {
        this.checkInit(TYPE);
        return this._masterTableID;
    }

    public void setMasterTableID(DBObjectID masterTableID) {
        this.checkInit(TYPE);
        this._masterTableID = masterTableID;
    }

    public String getLogTable() {
        this.checkInit(TYPE);
        return this.m_logTable;
    }

    public void setLogTable(String logTable) {
        this.checkInit(TYPE);
        this.m_logTable = logTable;
    }

    @Deprecated
    public String getTablespace() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false);
        return osp == null ? null : osp.getTablespace();
    }

    @Deprecated
    @Transient
    public void setTablespace(String tablespace) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true);
        osp.setTablespace(tablespace);
    }

    public Boolean getRowidLogged() {
        this.checkInit(TYPE);
        return this.m_rowid;
    }

    public void setRowidLogged(Boolean rowid) {
        this.checkInit(TYPE);
        this.m_rowid = rowid;
    }

    public Boolean getPrimaryKeyLogged() {
        this.checkInit(TYPE);
        return this.m_pk;
    }

    public void setPrimaryKeyLogged(Boolean pk) {
        this.checkInit(TYPE);
        this.m_pk = pk;
    }

    public Boolean getObjectIdLogged() {
        this.checkInit(TYPE);
        return this.m_objectid;
    }

    public void setObjectIdLogged(Boolean objectid) {
        this.checkInit(TYPE);
        this.m_objectid = objectid;
    }

    public Boolean getSequenceLogged() {
        this.checkInit(TYPE);
        return this.m_sequence;
    }

    public void setSequenceLogged(Boolean sequence) {
        this.checkInit(TYPE);
        this.m_sequence = sequence;
    }

    @Transient
    public boolean isColumsFiltered() {
        this.checkInit(TYPE);
        return this.m_filter;
    }

    @Deprecated
    @Transient
    public void setColumnsFiltered(boolean filter) {
        this.checkInit(TYPE);
        this.m_filter = filter;
    }

    @Deprecated
    public Boolean getLogging() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false);
        return osp == null ? null : osp.getLogging();
    }

    @Transient
    @Deprecated
    public void setLogging(Boolean logging) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true);
        osp.setLogging(logging);
    }

    public Boolean getNewValues() {
        this.checkInit(TYPE);
        return this.m_newValues;
    }

    public void setNewValues(Boolean newValues) {
        this.checkInit(TYPE);
        this.m_newValues = newValues;
    }

    public void setParallel(int parallel) {
        this.checkInit(TYPE);
        this.m_parallel = parallel;
    }

    public int getParallel() {
        this.checkInit(TYPE);
        return this.m_parallel;
    }

    public Boolean getCache() {
        this.checkInit(TYPE);
        return this.m_cache;
    }

    public void setCache(Boolean cache) {
        this.checkInit(TYPE);
        this.m_cache = cache;
    }

    public DBObjectID[] getColumnIDs() {
        this.checkInit("COLUMN");
        return this.m_columnIDs.toArray(new DBObjectID[this.m_columnIDs.size()]);
    }

    public void setColumnIDs(DBObjectID[] colIDs) {
        this.checkInit("COLUMN");
        this.m_columnIDs.clear();
        if (colIDs != null) {
            int i = 0;
            while (i < colIDs.length) {
                if (colIDs[i] != null) {
                    this.m_columnIDs.add(colIDs[i]);
                }
                ++i;
            }
        }
        this.m_filter = this.m_columnIDs.size() > 0;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this._masterTableID != null) {
            refs.add(this._masterTableID);
        }
        refs.addAll(this.m_columnIDs);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this._masterTableID != null && idMap.containsKey(this._masterTableID)) {
            this._masterTableID = idMap.get(this._masterTableID);
            replaced = true;
        }
        int i = 0;
        while (i < this.m_columnIDs.size()) {
            DBObjectID id = this.m_columnIDs.get(i);
            if (idMap.containsKey(id)) {
                this.m_columnIDs.set(i, idMap.get(id));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    private OracleStorageProperties getOracleStorageProperties(boolean createIfNotFound) {
        OracleStorageProperties osp = (OracleStorageProperties)this.getProperty("OracleStorageProperties");
        if (osp == null && createIfNotFound) {
            osp = new OracleStorageProperties();
            this.setProperty("OracleStorageProperties", osp);
        }
        return osp;
    }
}

