/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePartition
extends AbstractChildDBObject {
    public static final String TYPE = "PARTITION";
    public static final String COMPRESS = "COMPRESS";
    public static final String NOCOMPRESS = "NOCOMPRESS";
    private static final char COMMA = ',';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private transient String m_display;
    private OracleTablePartitions.PartitionType m_partitionType;
    private OracleTablePartitions.ObjectType m_objectType;
    private OracleStorageProperties m_segmentAttributes;
    private String m_compression;
    private ArrayList m_values;
    private OracleTablePartitions m_partitionLevelSubpartitions;

    private void $init$() {
        this.m_compression = NOCOMPRESS;
        this.m_values = new ArrayList();
    }

    public TablePartition() {
        this.$init$();
    }

    public TablePartition(String name) {
        super(name);
        this.$init$();
    }

    public TablePartition(OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this.$init$();
        this.m_partitionType = partitionType;
        this.m_objectType = objectType;
    }

    public TablePartition(String name, OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this(name);
        this.m_partitionType = partitionType;
        this.m_objectType = objectType;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        TablePartition copy = target != null ? (TablePartition)target : new TablePartition();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof TablePartition && this.equalsImpl((TablePartition)target);
    }

    public void setPartitionType(OracleTablePartitions.PartitionType partitionType) {
        this.m_display = null;
        this.m_partitionType = partitionType;
    }

    public OracleTablePartitions.PartitionType getPartitionType() {
        return this.m_partitionType;
    }

    public void setObjectType(OracleTablePartitions.ObjectType objectType) {
        this.m_objectType = objectType;
    }

    public OracleTablePartitions.ObjectType getObjectType() {
        return this.m_objectType;
    }

    @Override
    public void setName(String name) {
        this.m_display = null;
        super.setName(name);
    }

    public void setSegmentAttributes(OracleStorageProperties segmentAttributes) {
        this.m_segmentAttributes = segmentAttributes;
    }

    public OracleStorageProperties getSegmentAttributes() {
        return this.m_segmentAttributes;
    }

    public void setCompression(String compression) {
        this.m_compression = compression;
    }

    public String getCompression() {
        return this.m_compression;
    }

    public void setLOBDescriptors(LOBDescriptor[] lobDescriptors) {
        this.removeAllLOBDescriptors();
        if (lobDescriptors != null) {
            int i = 0;
            while (i < lobDescriptors.length) {
                this.addLOBDescriptor(lobDescriptors[i]);
                ++i;
            }
        }
    }

    public void addLOBDescriptor(LOBDescriptor lobDescriptor) {
        this.getChildSupport().addChild(lobDescriptor);
    }

    public void removeLOBDescriptor(LOBDescriptor lobDescriptor) {
        this.getChildSupport().removeChild(lobDescriptor);
    }

    public void removeAllLOBDescriptors() {
        this.getChildSupport().clearChildren(LOBDescriptor.class);
    }

    public LOBDescriptor[] getLOBDescriptors() {
        return (LOBDescriptor[])this.getChildSupport().getChildArray(LOBDescriptor.class);
    }

    public void setValues(Object[] values) {
        this.m_values.removeAll(this.m_values);
        if (values != null) {
            Object[] objectArray = values;
            int n = 0;
            while (n < objectArray.length) {
                Object value = objectArray[n];
                this.addValue(value);
                ++n;
            }
        }
    }

    private Object normaliseValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (this.m_partitionType == OracleTablePartitions.PartitionType.LIST && ("NULL".equalsIgnoreCase(s) || "DEFAULT".equalsIgnoreCase(s))) {
                return ListValue.valueOf(s.toUpperCase());
            }
            if (this.m_partitionType == OracleTablePartitions.PartitionType.RANGE && "MAXVALUE".equalsIgnoreCase(s)) {
                return RangeValue.valueOf(s.toUpperCase());
            }
        }
        return value;
    }

    public void setValues(String values) {
        if (ModelUtil.hasLength((String)values)) {
            List<String> list = TablePartition.splitValues(values);
            this.setValues(list.toArray(new String[list.size()]));
        }
    }

    public Object[] getValues() {
        return this.m_values.toArray(new Object[this.m_values.size()]);
    }

    public void addValue(Object value) {
        this.m_display = null;
        if (value != null) {
            this.m_values.add(this.normaliseValue(value));
        }
    }

    public void addValue(Object value, int atIndex) {
        this.m_display = null;
        if (value != null) {
            this.m_values.add(atIndex, this.normaliseValue(value));
        }
    }

    public void removeValue(Object value) {
        this.m_display = null;
        this.m_values.remove(value);
    }

    public void removeValueAt(int index) {
        this.m_display = null;
        this.m_values.remove(index);
    }

    public void setPartitionLevelSubpartitions(OracleTablePartitions partitionLevelSubpartitions) {
        this.changeParent(this.m_partitionLevelSubpartitions, partitionLevelSubpartitions);
        this.m_partitionLevelSubpartitions = partitionLevelSubpartitions;
    }

    public OracleTablePartitions getPartitionLevelSubpartitions() {
        return this.m_partitionLevelSubpartitions;
    }

    protected void copyToImpl(TablePartition target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_partitionType = this.m_partitionType;
        target.m_objectType = this.m_objectType;
        ModelUtil.deepCopy((List)this.m_values, (List)target.m_values, (boolean)false);
        target.m_compression = this.m_compression;
        target.m_segmentAttributes = this.copyObject(this.m_segmentAttributes, target, idPolicy);
        target.m_partitionLevelSubpartitions = this.copyObject(this.m_partitionLevelSubpartitions, target, idPolicy);
    }

    protected boolean equalsImpl(TablePartition target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)((Object)this.m_partitionType), (Object)((Object)target.m_partitionType)) && ModelUtil.areEqual((Object)((Object)this.m_objectType), (Object)((Object)target.m_objectType)) && ModelUtil.areEqual((Object)this.m_values, (Object)target.m_values) && ModelUtil.areEqual((Object)this.m_compression, (Object)target.m_compression) && ModelUtil.areEqual((Object)this.m_segmentAttributes, (Object)target.m_segmentAttributes) && ModelUtil.areEqual((Object)this.m_partitionLevelSubpartitions, (Object)target.m_partitionLevelSubpartitions);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_partitionLevelSubpartitions, types);
    }

    @Override
    public String toString() {
        if (this.m_display == null) {
            String name = this.getName();
            StringBuffer buff = new StringBuffer();
            if (ModelUtil.hasLength((String)name)) {
                buff.append(name).append(" ");
            }
            if (this.m_partitionType == OracleTablePartitions.PartitionType.LIST) {
                buff.append("VALUES (");
            } else if (this.m_partitionType == OracleTablePartitions.PartitionType.RANGE) {
                buff.append("VALUES LESS THAN (");
            }
            Iterator iter = this.m_values.iterator();
            while (iter.hasNext()) {
                buff.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                buff.append(", ");
            }
            if (this.m_partitionType == OracleTablePartitions.PartitionType.LIST || this.m_partitionType == OracleTablePartitions.PartitionType.RANGE) {
                buff.append(")");
            }
            this.m_display = buff.length() > 0 ? buff.toString() : "<partition>";
        }
        return this.m_display;
    }

    @Override
    public int hashCode() {
        String name = this.getName();
        return name != null ? name.hashCode() : (this.m_partitionType != null ? this.m_partitionType.hashCode() : 0);
    }

    public static List<String> splitValues(String string) {
        ArrayList<String> valueList = new ArrayList<String>();
        if (ModelUtil.hasLength((String)string)) {
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            int bracketCount = 0;
            int startIndex = 0;
            int idx = 0;
            while (idx < string.length()) {
                char ch = string.charAt(idx);
                if (inSingleQuote) {
                    inSingleQuote = ch == '\'' ^ true;
                } else if (inDoubleQuote) {
                    inDoubleQuote = ch == '\"' ^ true;
                } else if (bracketCount > 0) {
                    bracketCount += ch == '(' ? 1 : (ch == ')' ? -1 : 0);
                } else if (ch == ',') {
                    String value = string.substring(startIndex, idx).trim();
                    if (ModelUtil.hasLength((String)value)) {
                        valueList.add(value);
                    }
                    startIndex = idx + 1;
                } else {
                    inSingleQuote = ch == '\'';
                    inDoubleQuote = ch == '\"';
                    bracketCount = ch == '(' ? 1 : 0;
                }
                ++idx;
            }
            if (startIndex < string.length()) {
                valueList.add(string.substring(startIndex).trim());
            }
        }
        return valueList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeValue {
        MAXVALUE;


        private RangeValue(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ListValue
    extends Enum<ListValue> {
        private static final /* synthetic */ ListValue[] $v;
        public static final /* enum */ ListValue NULL;
        public static final /* enum */ ListValue DEFAULT;

        public static ListValue valueOf(String string) {
            return Enum.valueOf(ListValue.class, string);
        }

        public static final ListValue[] values() {
            return (ListValue[])$v.clone();
        }

        static {
            ListValue[] listValueArray = new ListValue[2];
            listValueArray[1] = DEFAULT = new ListValue("DEFAULT", 1);
            listValueArray[0] = NULL = new ListValue("NULL", 0);
            $v = listValueArray;
        }

        private ListValue(String string2, int n2) {
        }
    }
}

