/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLType
extends DDLType<OracleDDLType> {
    private static Map<OracleStatementType, OracleDDLType> s_types = new HashMap<OracleStatementType, OracleDDLType>();
    private static String[] s_promptActions = new String[]{"CREATE OR REPLACE", "CREATE", "DROP", "ALTER", "UNDELETE"};
    private static final String PROMPT = "PROMPT";
    private static final String PROMPT_SIMPLE = "PROMPT {0} {1} ''{2}''";
    private static final String PROMPT_WITH_PAR = "PROMPT ON ''{3}'' ''{4}''";
    private final OracleStatementType m_type;

    private OracleDDLType(OracleStatementType type) {
        this.m_type = type;
    }

    @Override
    public String getTerminator() {
        return this.m_type.getTerminator();
    }

    @Override
    public boolean ensureUnique() {
        switch (1.$sm$oracle$javatools$db$ora$ddl$OracleStatementType[this.m_type.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private String getPromptAction(String s) {
        String[] stringArray = s_promptActions;
        int n = 0;
        while (n < stringArray.length) {
            String action = stringArray[n];
            if (s.trim().toLowerCase().startsWith(action.toLowerCase())) {
                return action;
            }
            ++n;
        }
        return null;
    }

    @Override
    public String createPrompt(DBObject obj, String stmt) {
        String promptAction;
        if (!stmt.trim().startsWith(PROMPT) && (promptAction = this.getPromptAction(stmt)) != null) {
            if (obj instanceof SchemaObject) {
                return this.getPrompt(promptAction, obj, null);
            }
            if (obj != null) {
                return this.getPrompt(promptAction, obj, DBUtil.getSchemaObject(obj));
            }
        }
        return null;
    }

    private String getPrompt(String promptAction, DBObject obj, SchemaObject par) {
        if (par == null) {
            return MessageFormat.format(PROMPT_SIMPLE, promptAction.toLowerCase(), obj.getType().toLowerCase(), obj.getName());
        }
        return MessageFormat.format(PROMPT_WITH_PAR, promptAction.toLowerCase(), obj.getType().toLowerCase(), obj.getName(), par.getType().toLowerCase(), par.getName());
    }

    @Override
    public int compareTo(OracleDDLType o) {
        return this.m_type.compareTo(o.m_type);
    }

    public static OracleDDLType getDDLType(String type) {
        return OracleDDLType.getDDLType(OracleStatementType.valueOf(type));
    }

    public static OracleDDLType getDDLType(OracleStatementType type) {
        if (type == null) {
            throw new NullPointerException("must have a valid type");
        }
        OracleDDLType retval = s_types.get((Object)type);
        if (retval == null) {
            retval = new OracleDDLType(type);
            s_types.put(type, retval);
        }
        return retval;
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$ora$ddl$OracleStatementType;

        static {
            int[] nArray = new int[OracleStatementType.values().length];
            $sm$oracle$javatools$db$ora$ddl$OracleStatementType = nArray;
            try {
                nArray[OracleStatementType.SPOOLON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$ora$ddl$OracleStatementType[OracleStatementType.SPOOLOFF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

