/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.plsql.ObjectTypeDeclarator;
import oracle.javatools.db.plsql.PackageDeclarator;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlSubprogramDeclarator;
import oracle.javatools.db.plsql.TriggerDeclarator;

public class PlSqlDeclaratorFactory {
    private PlSqlDeclaratorFactory() {
    }

    public static void loadDeclarativeInfo(PlSql plsql, DBObjectProvider prov) {
        PlSqlDeclarator d = PlSqlDeclaratorFactory.getDeclarator(plsql, prov);
        if (d != null) {
            d.loadDeclarativeInfo(plsql);
        }
    }

    public static PlSqlDeclarator getDeclarator(PlSql plsql, DBObjectProvider prov) {
        return PlSqlDeclaratorFactory.getDeclarator(plsql.getType(), prov);
    }

    public static PlSqlDeclarator getDeclarator(String type, DBObjectProvider prov) {
        if ("PACKAGE".equals(type)) {
            return new PackageDeclarator(prov);
        }
        if ("TYPE".equals(type)) {
            return new ObjectTypeDeclarator(prov);
        }
        if ("TRIGGER".equals(type)) {
            return new TriggerDeclarator(prov);
        }
        if ("FUNCTION".equals(type) || "PROCEDURE".equals(type)) {
            return new PlSqlSubprogramDeclarator(prov);
        }
        return null;
    }
}

