/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlRoot;

public class PlSqlInterrogator {
    private PlSqlFragment m_rootFrag;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_startMarker;
    private PlSqlToken m_endMarker;
    private PlSqlToken m_nameToken;
    private PlSqlFragment m_triggerBaseItemFragment;
    private String m_source;
    private String m_objType;
    private String m_schemaName;
    private String m_userDefTypeTypeCode;
    private String m_userDefTypeCollectionType;
    private boolean m_newStatementBlockReqd;
    private boolean m_fullInterrogation;
    private boolean m_isUserDefType;
    private boolean m_isUserDefTypeSepc;
    private boolean m_isSourceWrapped;
    private boolean m_containsToDo;
    private boolean m_evolvedType;
    private String[] m_sourceByLines;
    private PlsqlError[] m_errors;
    private ArrayList<PlSqlToken> m_optionalNews;
    private static WeakHashMap<String, WeakReference<PlSqlInterrogator>> m_cache = new WeakHashMap();
    private static int m_invocations = 0;
    private static final String EMPTY_STRING = "";
    private static final String KW_AFTER = "AFTER";
    private static final String KW_ALTER = "ALTER";
    private static final String KW_AS = "AS";
    private static final String KW_BEFORE = "BEFORE";
    private static final String KW_BEGIN = "BEGIN";
    private static final String KW_BODY = "BODY";
    private static final String KW_CALL = "CALL";
    private static final String KW_CASE = "CASE";
    private static final String KW_CONSTRUCTOR = "CONSTRUCTOR";
    private static final String KW_CREATE = "CREATE";
    private static final String KW_DECLARE = "DECLARE";
    private static final String KW_EACH = "EACH";
    private static final String KW_ELSE = "ELSE";
    private static final String KW_ELSIF = "ELSIF";
    private static final String KW_END = "END";
    private static final String KW_EXCEPTION = "EXCEPTION";
    private static final String KW_FINAL = "FINAL";
    private static final String KW_FOR = "FOR";
    private static final String KW_FUNCTION = "FUNCTION";
    private static final String KW_IF = "IF";
    private static final String KW_INSTANTIABLE = "INSTANTIABLE";
    private static final String KW_INSTEAD = "INSTEAD";
    private static final String KW_IS = "IS";
    private static final String KW_LOOP = "LOOP";
    private static final String KW_MEMBER = "MEMBER";
    private static final String KW_NESTED = "NESTED";
    private static final String KW_NOT = "NOT";
    private static final String KW_OBJECT = "OBJECT";
    private static final String KW_OVERRIDING = "OVERRIDING";
    private static final String KW_OF = "OF";
    private static final String KW_ON = "ON";
    private static final String KW_OR = "OR";
    private static final String KW_PACKAGE = "PACKAGE";
    private static final String KW_PRAGMA = "PRAGMA";
    private static final String KW_PROCEDURE = "PROCEDURE";
    private static final String KW_REFERENCING = "REFERENCING";
    private static final String KW_REPLACE = "REPLACE";
    private static final String KW_ROW = "ROW";
    private static final String KW_STATIC = "STATIC";
    private static final String KW_TABLE = "TABLE";
    private static final String KW_THEN = "THEN";
    private static final String KW_TRIGGER = "TRIGGER";
    private static final String KW_TYPE = "TYPE";
    private static final String KW_UNDER = "UNDER";
    private static final String KW_UPDATE = "UPDATE";
    private static final String KW_VARRAY = "VARRAY";
    private static final String KW_VARYING = "VARYING";
    private static final String KW_WHEN = "WHEN";
    private static final String KW_WHILE = "WHILE";
    private static final String KW_WRAPPED = "WRAPPED";
    private static final String PUNC_COMMA = ",";
    private static final String PUNC_DBL_LCHEV = "<<";
    private static final String PUNC_DBL_RCHEV = ">>";
    private static final String PUNC_DOT = ".";
    private static final String PUNC_LPAREN = "(";
    private static final String PUNC_RPAREN = ")";
    private static final String PUNC_SEMICOLON = ";";

    private void $init$() {
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_isSourceWrapped = false;
        this.m_containsToDo = false;
        this.m_evolvedType = false;
        this.m_sourceByLines = null;
        this.m_errors = null;
    }

    public PlSqlInterrogator(String source) {
        this.$init$();
        this.initialise();
        this.updateSource(source);
    }

    public PlSqlInterrogator() {
        this.$init$();
        this.initialise();
    }

    private void initialise() {
        this.m_source = EMPTY_STRING;
        this.m_objType = EMPTY_STRING;
        this.m_schemaName = null;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_startMarker = new PlSqlToken(this, PlSqlToken.Type.END_MARKER, -1, null);
        this.m_endMarker = new PlSqlToken(this, PlSqlToken.Type.END_MARKER, -1, this.m_startMarker);
        this.m_rootFrag = null;
        this.m_firstToken = null;
        this.m_nameToken = null;
        this.m_triggerBaseItemFragment = null;
        this.m_errors = null;
        this.m_newStatementBlockReqd = false;
        this.m_fullInterrogation = true;
        this.m_isUserDefType = false;
        this.m_isUserDefTypeSepc = false;
        this.m_isSourceWrapped = false;
        this.m_sourceByLines = null;
        this.m_containsToDo = false;
        this.m_evolvedType = false;
        this.m_optionalNews = new ArrayList();
    }

    @Deprecated
    public void updateSource(String source, boolean detailed) {
        this.updateSource(source);
    }

    public void updateSource(String source) {
        if (source != null && !this.m_source.equals(source)) {
            this.initialise();
            this.m_source = source;
            this.m_firstToken = this.tokenizeString(this.m_source);
            this.interrogateBasics();
            this.m_rootFrag = new PlSqlFragment(this);
            this.m_rootFrag.setFragmentType(PlSqlFragment.Type.ROOT);
            this.m_rootFrag.setFirstToken(this.m_firstToken);
            if (this.m_fullInterrogation) {
                this.m_rootFrag = new PlSqlFragment(this);
                this.m_rootFrag.setFragmentType(PlSqlFragment.Type.ROOT);
                this.m_rootFrag.setFirstToken(this.m_firstToken);
                if (this.m_firstToken.matches(KW_BEGIN) || this.m_firstToken.matches(KW_DECLARE)) {
                    this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.PLSQL_BLOCK);
                } else {
                    this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.DECLARATIVE_SECTION);
                }
            } else {
                PlSqlFragment typeFrag = new PlSqlFragment(this, this.m_rootFrag);
                if (this.m_objType.equals(KW_PROCEDURE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                } else if (this.m_objType.equals(KW_FUNCTION)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                } else if (this.m_objType.equals(KW_PACKAGE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                } else if (this.m_objType.equals("PACKAGE BODY")) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                } else if (this.m_objType.equals(KW_TYPE)) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                } else if (this.m_objType.equals("TYPE BODY")) {
                    typeFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                } else {
                    typeFrag.setFragmentType(PlSqlFragment.Type.UNKNOWN);
                }
                typeFrag.setFirstToken(this.m_firstToken);
                typeFrag.setLastToken(this.m_endMarker.getPrevCodeToken());
                PlSqlFragment statementFrag = new PlSqlFragment(this, typeFrag);
                statementFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                statementFrag.setFirstToken(this.m_firstToken);
                statementFrag.setLastToken(this.m_endMarker.getPrevCodeToken());
                this.m_rootFrag.setLastToken(this.m_endMarker.getPrevCodeToken());
            }
        }
    }

    public PlSqlFragment getRoot() {
        return this.m_rootFrag;
    }

    public String getType() {
        return this.m_objType;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getName() {
        return this.m_nameToken == null ? EMPTY_STRING : this.m_nameToken.getSource();
    }

    public String getTypeCode() {
        return this.m_userDefTypeTypeCode;
    }

    public String getCollectionType() {
        return this.m_userDefTypeCollectionType;
    }

    public boolean isWrapped() {
        return this.m_isSourceWrapped;
    }

    private PlSqlToken tokenizeString(String source) {
        PlSqlToken.Type currentType = PlSqlToken.Type.UNKNOWN;
        int currentPos = 0;
        int sourceLength = source.length();
        PlSqlToken currentToken = this.m_startMarker;
        block9: while (currentPos < sourceLength) {
            switch (1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[currentType.ordinal()]) {
                case 1: {
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentType = PlSqlToken.Type.WHITESPACE;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        currentToken.setEnd(++currentPos - 1);
                    } else if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("/*")) {
                        currentType = PlSqlToken.Type.MULTI_LINE_COMMENT;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("--")) {
                        currentType = PlSqlToken.Type.SINGLE_LINE_COMMENT;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (source.substring(currentPos, currentPos + 1).equals("\"")) {
                        currentType = PlSqlToken.Type.DOUBLE_QUOTED_STRING;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else if (source.substring(currentPos, currentPos + 1).equals("'")) {
                        currentType = PlSqlToken.Type.SINGLE_QUOTED_STRING;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else if (currentPos < sourceLength - 1 && (source.substring(currentPos, currentPos + 2).equals(":=") || source.substring(currentPos, currentPos + 2).equals("=>") || source.substring(currentPos, currentPos + 2).equals("||") || source.substring(currentPos, currentPos + 2).equals("**") || source.substring(currentPos, currentPos + 2).equals(PUNC_DBL_LCHEV) || source.substring(currentPos, currentPos + 2).equals(PUNC_DBL_RCHEV) || source.substring(currentPos, currentPos + 2).equals("..") || source.substring(currentPos, currentPos + 2).equals("<>") || source.substring(currentPos, currentPos + 2).equals("!=") || source.substring(currentPos, currentPos + 2).equals("~=") || source.substring(currentPos, currentPos + 2).equals("^=") || source.substring(currentPos, currentPos + 2).equals("<=") || source.substring(currentPos, currentPos + 2).equals(">="))) {
                        currentType = PlSqlToken.Type.PUNCTUATION;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (Pattern.matches("\\p{Punct}", source.substring(currentPos, currentPos + 1))) {
                        currentType = PlSqlToken.Type.PUNCTUATION;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else {
                        currentType = PlSqlToken.Type.ALPHANUMERIC;
                        currentToken = new PlSqlToken(this, currentType, currentPos, currentToken);
                        ++currentPos;
                    }
                    if (currentType != PlSqlToken.Type.PUNCTUATION) continue block9;
                    currentToken.setEnd(currentPos - 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    break;
                }
                case 2: {
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(++currentPos - 1);
                        break;
                    }
                    currentToken.setEnd(currentPos - 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    break;
                }
                case 3: {
                    if (!source.substring(currentPos, currentPos + 2).equals("*/")) {
                        if (++currentPos >= sourceLength - 4 || !source.substring(currentPos, currentPos + 4).equalsIgnoreCase("TODO")) continue block9;
                        this.m_containsToDo = true;
                        break;
                    }
                    currentToken.setEnd(currentPos + 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    ++currentPos;
                    break;
                }
                case 4: {
                    if (!source.substring(currentPos, currentPos + 1).equals("\n")) {
                        if (++currentPos >= sourceLength - 4 || !source.substring(currentPos, currentPos + 4).equalsIgnoreCase("TODO")) continue block9;
                        this.m_containsToDo = true;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case 5: {
                    if (!source.substring(currentPos, currentPos + 1).equals("\"")) {
                        ++currentPos;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 2).equals("\"\"")) {
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case 6: {
                    if (!source.substring(currentPos, currentPos + 1).equals("'")) {
                        ++currentPos;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 2).equals("''")) {
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case 7: {
                    if (Pattern.matches("[_$#]", source.substring(currentPos, currentPos + 1))) {
                        ++currentPos;
                        break;
                    }
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("/*")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("--")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 1).equals("\"")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 1).equals("'")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && (source.substring(currentPos, currentPos + 2).equals(":=") || source.substring(currentPos, currentPos + 2).equals("=>") || source.substring(currentPos, currentPos + 2).equals("||") || source.substring(currentPos, currentPos + 2).equals("**") || source.substring(currentPos, currentPos + 2).equals(PUNC_DBL_LCHEV) || source.substring(currentPos, currentPos + 2).equals(PUNC_DBL_RCHEV) || source.substring(currentPos, currentPos + 2).equals("..") || source.substring(currentPos, currentPos + 2).equals("<>") || source.substring(currentPos, currentPos + 2).equals("!=") || source.substring(currentPos, currentPos + 2).equals("~=") || source.substring(currentPos, currentPos + 2).equals("^=") || source.substring(currentPos, currentPos + 2).equals("<=") || source.substring(currentPos, currentPos + 2).equals(">="))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (Pattern.matches("\\p{Punct}", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    ++currentPos;
                    break;
                }
            }
        }
        currentToken.setEnd(source.length() - 1);
        if (this.m_startMarker.getNextToken().getType() != PlSqlToken.Type.END_MARKER) {
            return this.m_startMarker.getNextToken();
        }
        return null;
    }

    private void interrogateBasics() {
        this.m_fullInterrogation = true;
        this.m_isUserDefTypeSepc = false;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_isSourceWrapped = false;
        PlSqlToken tk = this.m_firstToken;
        if (!tk.isCode()) {
            tk = tk.getNextCodeToken();
        }
        while (tk.matches(KW_CREATE) || tk.matches(KW_OR) || tk.matches(KW_REPLACE)) {
            tk = tk.getNextCodeToken();
        }
        if (tk.matches(KW_PACKAGE)) {
            this.m_firstToken = tk;
            if (tk.getNextCodeToken().matches(KW_BODY)) {
                this.m_objType = "PACKAGE BODY";
                tk = tk.getNextCodeToken();
            } else {
                this.m_objType = KW_PACKAGE;
            }
        } else if (tk.matches(KW_PROCEDURE)) {
            this.m_firstToken = tk;
            this.m_objType = KW_PROCEDURE;
        } else if (tk.matches(KW_FUNCTION)) {
            this.m_firstToken = tk;
            this.m_objType = KW_FUNCTION;
        } else if (tk.matches(KW_TYPE)) {
            this.m_isUserDefType = true;
            this.m_firstToken = tk;
            if (tk.getNextCodeToken().matches(KW_BODY)) {
                this.m_objType = "TYPE BODY";
                tk = tk.getNextCodeToken();
            } else {
                this.m_objType = KW_TYPE;
                this.m_fullInterrogation = false;
                this.m_isUserDefTypeSepc = true;
                while (!(tk.matches(KW_IS) || tk.matches(KW_AS) || tk.matches(PUNC_SEMICOLON) || tk.matches(KW_UNDER) || tk.matches(KW_WRAPPED) || tk == this.m_endMarker)) {
                    tk = tk.getNextCodeToken();
                }
                if (tk.matches(KW_WRAPPED)) {
                    this.m_isSourceWrapped = true;
                } else if (tk != this.m_endMarker) {
                    if (tk.matches(KW_IS) || tk.matches(KW_AS)) {
                        if ((tk = tk.getNextCodeToken()).matches(KW_OBJECT)) {
                            this.m_fullInterrogation = true;
                            this.m_userDefTypeTypeCode = KW_OBJECT;
                            this.m_userDefTypeCollectionType = EMPTY_STRING;
                        } else if (tk.matches(KW_TABLE)) {
                            this.m_userDefTypeTypeCode = "COLLECTION";
                            this.m_userDefTypeCollectionType = KW_TABLE;
                        } else if (tk.matches(KW_VARRAY) || tk.matches(KW_VARYING)) {
                            this.m_userDefTypeTypeCode = "COLLECTION";
                            this.m_userDefTypeCollectionType = "VARYING ARRAY";
                        }
                    } else if (tk.matches(KW_UNDER)) {
                        this.m_fullInterrogation = true;
                        this.m_userDefTypeTypeCode = KW_OBJECT;
                    }
                }
                tk = this.m_firstToken;
            }
        } else if (tk.matches(KW_TRIGGER)) {
            this.m_firstToken = tk;
            this.m_objType = KW_TRIGGER;
        } else {
            this.m_firstToken = tk;
            this.m_objType = EMPTY_STRING;
        }
        if (!this.m_objType.equals(EMPTY_STRING)) {
            this.m_nameToken = tk = tk.getNextCodeToken();
            if (tk.getNextCodeToken().matches(PUNC_DOT)) {
                tk = tk.getNextCodeToken().getNextCodeToken();
                this.m_schemaName = this.m_nameToken.getSource();
                this.m_nameToken = tk;
            }
            if ((tk = tk.getNextCodeToken()).matches(KW_WRAPPED)) {
                this.m_fullInterrogation = false;
                this.m_isUserDefType = false;
                this.m_isUserDefTypeSepc = false;
                this.m_isSourceWrapped = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private PlSqlToken buildFragmentTree(PlSqlToken startToken, PlSqlFragment currentFrag, InterrogateState parseState) {
        tk = startToken;
        this.m_newStatementBlockReqd = false;
        lastTk = null;
        try {
            if (currentFrag.getFirstToken() == null) {
                currentFrag.setFirstToken(startToken);
            }
            block19: while (tk != null && tk.getType() != PlSqlToken.Type.END_MARKER) {
                if (lastTk == tk) {
                    var13_7 = tk;
                    return var13_7;
                }
                lastTk = tk;
                switch (1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[parseState.ordinal()]) {
                    case 1: 
                    case 2: {
                        if (!this.m_isUserDefTypeSepc) ** GOTO lbl37
                        while (!(tk.matches(",") || tk.matches("(") || tk.matches(")"))) {
                            tk = tk.getNextCodeToken();
                        }
                        if (tk.matches("(")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                        }
                        while (!tk.matches(",") && !tk.matches(")")) {
                            tk = tk.getNextCodeToken();
                        }
                        if (currentFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE) {
                            currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                        } else {
                            currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk.matches(",")) {
                            tk = tk.getNextCodeToken();
                        }
                        var14_8 = tk;
                        return var14_8;
lbl-1000:
                        // 1 sources

                        {
                            tk = tk.getNextCodeToken();
lbl37:
                            // 2 sources

                            ** while (!tk.matches((String)"IS") && !tk.matches((String)"AS") && !tk.matches((String)";") && !tk.matches((String)"("))
                        }
lbl38:
                        // 1 sources

                        if (tk.matches("(")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER_LIST);
                            while (!(tk.matches("IS") || tk.matches("AS") || tk.matches(";"))) {
                                tk = tk.getNextCodeToken();
                            }
                        }
                        if (tk.matches(";")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE) {
                                currentFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                currentFrag.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            currentFrag.setLastToken(tk);
                            var15_9 = tk = tk.getNextCodeToken();
                            return var15_9;
                        }
                        tk = tk.getNextCodeToken();
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFirstToken(tk);
                        childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                        i = currentFrag.getSubFragments().size();
                        currentFrag.getSubFragments().remove(i - 1);
                        i = 0;
                        while (i < childFrag.getSubFragments().size()) {
                            currentFrag.getSubFragments().add(childFrag.getSubFragments().get(i));
                            ++i;
                        }
                        var16_11 = tk;
                        return var16_11;
                    }
                    case 3: {
                        if (tk.matches("BEFORE") || tk.matches("AFTER") || tk.matches("INSTEAD") && tk.getNextCodeToken().matches("OF")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TIMING);
                            childFrag.setFirstToken(tk);
                            if (tk.matches("INSTEAD")) {
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            if (tk.matches("ON") || tk.matches("FOR") || tk.matches("REFERENCING") || tk.matches("WHEN") || tk.matches("DECLARE") || tk.matches("BEGIN") || tk.matches("CALL")) continue block19;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_EVENTS);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_EVENTS);
                            break;
                        }
                        if (tk.matches("ON")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_TABLE);
                                this.m_triggerBaseItemFragment = childFrag;
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var17_12 = tk;
                            return var17_12;
                        }
                        if (tk.matches("WHEN")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_WHEN);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var18_13 = tk;
                            return var18_13;
                        }
                        if (tk.matches("REFERENCING")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_REFERENCING);
                                tk = tk.getNextCodeToken();
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var19_14 = tk;
                            return var19_14;
                        }
                        if (tk.matches("FOR") && tk.getNextCodeToken().matches("EACH") && tk.getNextCodeToken(2).matches("ROW")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_ROW_LEVEL);
                                childFrag.setFirstToken(tk);
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var20_15 = tk;
                            return var20_15;
                        }
                        if (tk.matches("DECLARE") || tk.matches("BEGIN")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER) {
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                                break;
                            }
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var21_16 = tk;
                            return var21_16;
                        }
                        if (currentFrag.getFramentType() == PlSqlFragment.Type.TRIGGER_TABLE && tk.matches("NESTED")) {
                            while (!tk.matches("OF")) {
                                tk = tk.getNextCodeToken();
                            }
                            if ((tk = tk.getNextCodeToken()).getNextCodeToken().matches(".")) {
                                tk = tk.getNextCodeToken(2);
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        tk = tk.getNextCodeToken();
                        break;
                    }
                    case 4: {
                        while (!(tk.matches("ON") || tk.matches("FOR") || tk.matches("REFERENCING") || tk.matches("WHEN") || tk.matches("DECLARE") || tk.matches("BEGIN") || tk.matches("CALL"))) {
                            if (tk.matches("UPDATE") && tk.getNextCodeToken().matches("OF")) {
                                tk = tk.getNextCodeToken();
                                tk = tk.getNextCodeToken();
                                childFrag = new PlSqlFragment(this, currentFrag);
                                childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER_COLUMNS);
                                childFrag.setFirstToken(tk);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER_COLUMNS);
                                continue;
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        var22_17 = tk;
                        return var22_17;
                    }
                    case 5: {
                        while (tk.matches(",") || tk.getNextCodeToken().matches(",")) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        var23_18 = tk = tk.getNextCodeToken();
                        return var23_18;
                    }
                    case 6: {
                        if (tk.matches("BEGIN")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.BEGIN);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            if (tk.matches("EXCEPTION")) break;
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var24_19 = tk;
                            return var24_19;
                        }
                        if (tk.matches("EXCEPTION")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.EXCEPTION);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.EXCEPTION_BLOCK);
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var25_20 = tk;
                            return var25_20;
                        }
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARE);
                        childFrag.setFirstToken(tk);
                        if (tk.matches("DECLARE")) {
                            tk = tk.getNextCodeToken();
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                        break;
                    }
                    case 7: {
                        if (tk.matches("END") && (currentFrag.getFramentType() == PlSqlFragment.Type.PACKAGE_BODY || currentFrag.getFramentType() == PlSqlFragment.Type.PACKAGE_SPEC || currentFrag.getFramentType() == PlSqlFragment.Type.TYPE_BODY)) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                tk = tk.getNextCodeToken();
                            }
                            var26_21 = tk;
                            return var26_21;
                        }
                        if (tk.matches("PACKAGE")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches("BODY")) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                                tk = tk.getNextCodeToken();
                            } else {
                                childFrag.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                            }
                            while (!tk.matches("IS") && !tk.matches("AS")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                            break;
                        }
                        if (tk.matches("TYPE") && currentFrag.getFramentType() == PlSqlFragment.Type.ROOT) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            if (tk.getNextCodeToken().matches("BODY")) {
                                childFrag.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                                while (!tk.matches("IS") && !tk.matches("AS")) {
                                    tk = tk.getNextCodeToken();
                                }
                                tk = tk.getNextCodeToken();
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.DECLARATIVE_SECTION);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                            while (!tk.matches("(")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            if (!(tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TYPE_SPEC)).matches("ALTER")) break;
                            this.m_evolvedType = true;
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches("ALTER") && tk.firstCodeTokenOnLine()) {
                                    childFrag.setLastToken(tk.getPrevCodeToken());
                                    childFrag = new PlSqlFragment(this, currentFrag);
                                    childFrag.setFirstToken(tk);
                                    childFrag.setFragmentType(PlSqlFragment.Type.TYPE_ALTER_STATEMENT);
                                }
                                tk = tk.getNextCodeToken();
                            }
                            childFrag.setLastToken(tk.getPrevCodeToken());
                            var27_22 = tk;
                            return var27_22;
                        }
                        if (tk.matches("BEGIN")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.PLSQL_BLOCK) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                var28_23 = tk;
                                return var28_23;
                            }
                            if (currentFrag.getFramentType() != PlSqlFragment.Type.PACKAGE_BODY) break;
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches("FUNCTION")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches("PROCEDURE")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                            break;
                        }
                        if (tk.matches("TRIGGER")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.TRIGGER);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.TRIGGER);
                            break;
                        }
                        if (tk.matches("PRAGMA")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PRAGMA);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (tk.matches("<<")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (this.m_isUserDefType && (tk.matches("NOT") || tk.matches("OVERRIDING") || tk.matches("FINAL") || tk.matches("INSTANTIABLE") || tk.matches("MEMBER") || tk.matches("STATIC") || tk.matches("CONSTRUCTOR") || tk.matches("PROCEDURE") || tk.matches("FUNCTION"))) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("PROCEDURE") && !tk.matches("FUNCTION")) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches("PROCEDURE")) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(";")) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        if (currentFrag.getFramentType() == PlSqlFragment.Type.TYPE_SPEC && this.m_isUserDefTypeSepc) {
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                            break;
                        }
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                        break;
                    }
                    case 8: {
                        if (tk.matches("END")) {
                            while (!tk.matches(";")) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            var29_24 = tk = tk.getNextCodeToken();
                            return var29_24;
                        }
                        if (tk.matches("WHEN") && (currentFrag.getFramentType() == PlSqlFragment.Type.EX_WHEN || currentFrag.getFramentType() == PlSqlFragment.Type.CASE_WHEN)) {
                            currentFrag.setLastToken(tk.getPrevCodeToken());
                            var30_25 = tk;
                            return var30_25;
                        }
                        if (tk.matches("DECLARE") || tk.matches("BEGIN")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (tk.matches("EXCEPTION")) {
                            if (currentFrag.getFramentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                                currentFrag.setLastToken(tk);
                                var31_26 = tk;
                                return var31_26;
                            }
                            tk = tk.getNextCodeToken();
                            break;
                        }
                        if (tk.matches("IF")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.IF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("THEN")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("ELSIF")) {
                            if (!(currentFrag.getFramentType() != PlSqlFragment.Type.IF && currentFrag.getFramentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                var32_27 = tk;
                                return var32_27;
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSIF);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("THEN")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("ELSE")) {
                            if (currentFrag.getFramentType() == PlSqlFragment.Type.CASE_WHEN && !this.m_newStatementBlockReqd) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                var33_28 = tk;
                                return var33_28;
                            }
                            if (!(currentFrag.getFramentType() != PlSqlFragment.Type.IF && currentFrag.getFramentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                currentFrag.setLastToken(tk.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                var34_29 = tk;
                                return var34_29;
                            }
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.ELSE);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("LOOP")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LOOP);
                            childFrag.setFirstToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("FOR")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.FOR_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("LOOP")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("WHILE")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.WHILE_LOOP);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("LOOP")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (tk.matches("CASE")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("WHEN")) {
                                tk = tk.getNextCodeToken();
                            }
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.CASE_STATEMENT);
                            break;
                        }
                        if (tk.matches("<<")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.LABEL);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.LABEL);
                            break;
                        }
                        if (!tk.matches(";")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            childFrag.setFirstToken(tk);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (!tk.matches(";")) break;
                        currentFrag.setLastToken(tk);
                        var35_30 = tk;
                        return var35_30;
                    }
                    case 9: {
                        if (tk.matches("END")) {
                            tempTk = tk;
                            while (!tk.matches(";")) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            var36_32 = tempTk;
                            return var36_32;
                        }
                        if (tk.matches("WHEN")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFragmentType(PlSqlFragment.Type.CASE_WHEN);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("THEN")) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (!tk.matches("ELSE")) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.CASE_ELSE);
                        childFrag.setFirstToken(tk);
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case 10: {
                        if (tk.matches("END")) {
                            tempTk = tk;
                            while (!tk.matches(";")) {
                                tk = tk.getNextCodeToken();
                            }
                            currentFrag.setLastToken(tk);
                            tk = tk.getNextCodeToken();
                            var37_34 = tempTk;
                            return var37_34;
                        }
                        if (!tk.matches("WHEN")) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.EX_WHEN);
                        childFrag.setFirstToken(tk);
                        while (!tk.matches("THEN")) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        tk = tk.getNextCodeToken();
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case 11: {
                        if (tk.matches(")")) {
                            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                                if (tk.matches("ALTER") && tk.firstCodeTokenOnLine()) {
                                    var38_35 = tk;
                                    return var38_35;
                                }
                                tk = tk.getNextCodeToken();
                            }
                            var39_36 = tk;
                            return var39_36;
                        }
                        if (tk.matches("NOT") || tk.matches("OVERRIDING") || tk.matches("FINAL") || tk.matches("INSTANTIABLE") || tk.matches("MEMBER") || tk.matches("STATIC") || tk.matches("CONSTRUCTOR") || tk.matches("PROCEDURE") || tk.matches("FUNCTION")) {
                            childFrag = new PlSqlFragment(this, currentFrag);
                            childFrag.setFirstToken(tk);
                            while (!tk.matches("PROCEDURE") && !tk.matches("FUNCTION")) {
                                tk = tk.getNextCodeToken();
                            }
                            if (tk.matches("PROCEDURE")) {
                                childFrag.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PROCEDURE);
                                break;
                            }
                            childFrag.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            tk = this.buildFragmentTree(tk, childFrag, InterrogateState.FUNCTION);
                            break;
                        }
                        if (tk.matches(";")) break;
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.ORACLE_TYPE_DECLN);
                        break;
                    }
                    case 12: {
                        parens = 0;
                        terminator = ",";
                        while (!(tk == null || tk == this.m_endMarker || tk.matches(terminator) || tk.matches(")") && parens == 0)) {
                            if (tk.matches("(")) {
                                ++parens;
                            } else if (tk.matches(")")) {
                                --parens;
                            }
                            terminator = parens > 0 ? ",," : ",";
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (!tk.matches(")")) {
                            tk = tk.getNextCodeToken();
                        }
                        var40_39 = tk;
                        return var40_39;
                    }
                    case 13: {
                        while (tk != null && tk != this.m_endMarker && !tk.matches(";")) {
                            if (tk.matches("new") && tk.getPrevCodeToken() != null && tk.getPrevCodeToken().matches(":=") && tk.getNextCodeToken() != null && !tk.getNextCodeToken().matches(";")) {
                                this.m_optionalNews.add(tk);
                            }
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        var41_40 = tk = tk.getNextCodeToken();
                        return var41_40;
                    }
                    case 14: {
                        while (tk != null && tk != this.m_endMarker && !tk.matches(">>")) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk);
                        var42_41 = tk = tk.getNextCodeToken();
                        return var42_41;
                    }
                    case 15: {
                        if (tk.matches(")")) {
                            currentFrag.setLastToken(tk);
                            var43_42 = tk = tk.getNextCodeToken();
                            return var43_42;
                        }
                        childFrag = new PlSqlFragment(this, currentFrag);
                        childFrag.setFragmentType(PlSqlFragment.Type.PARAMETER);
                        childFrag.setFirstToken(tk);
                        tk = this.buildFragmentTree(tk, childFrag, InterrogateState.PARAMETER);
                        break;
                    }
                    case 16: {
                        while (tk != null && !tk.matches(",") && !tk.matches(")")) {
                            tk = tk.getNextCodeToken();
                        }
                        currentFrag.setLastToken(tk.getPrevCodeToken());
                        if (tk.matches(",")) {
                            tk = tk.getNextCodeToken();
                        }
                        var44_43 = tk;
                        return var44_43;
                    }
                }
            }
        }
        catch (NullPointerException e) {
            var45_45 = null;
            return var45_45;
        }
        return tk;
    }

    public int getLineNumber(int offset) {
        if (this.m_sourceByLines == null) {
            this.m_sourceByLines = this.m_source.split("\n");
        }
        int lineNum = 0;
        int currEnd = this.m_sourceByLines[lineNum].length() + 1;
        while (lineNum < this.m_sourceByLines.length && currEnd < offset) {
            currEnd = currEnd + this.m_sourceByLines[++lineNum].length() + 1;
        }
        return lineNum + 1;
    }

    public PlSqlFragment getFragmentAtOffset(int offset) {
        return this.getFragmentAtOffset(offset, this.m_rootFrag);
    }

    private PlSqlFragment getFragmentAtOffset(int offset, PlSqlFragment parent) {
        if (parent.getFirstToken().getStart() <= offset && (parent.getLastToken() == null || parent.getLastToken().getEnd() >= offset)) {
            if (parent.getSubFragments() == null || parent.getSubFragments().size() == 0) {
                return parent;
            }
            PlSqlFragment frag = null;
            int i = 0;
            while (i < parent.getSubFragments().size()) {
                frag = (PlSqlFragment)parent.getSubFragments().get(i);
                if (frag.getLastToken() == null || frag.getLastToken().getEnd() >= offset) {
                    return this.getFragmentAtOffset(offset, frag);
                }
                ++i;
            }
        }
        return null;
    }

    public PlSqlToken getTokenAtOffset(int offset) {
        PlSqlFragment fragAtOffset = this.getFragmentAtOffset(offset, this.m_rootFrag);
        if (fragAtOffset != null) {
            PlSqlToken tok = fragAtOffset.getFirstToken();
            while (tok.getEnd() < offset) {
                tok = tok.getNextToken();
            }
            return tok;
        }
        return null;
    }

    public PlsqlError[] getPlSqlErrors() {
        if (this.m_errors == null) {
            PlSqlFragment rootFrag = null;
            ReadTextBuffer realBuffer = null;
            PlsqlRoot root = null;
            StringBuffer sb = new StringBuffer();
            if (this.m_evolvedType) {
                ArrayList frags = this.getRoot().getSubFragments();
                rootFrag = (PlSqlFragment)frags.get(0);
            } else if (this.m_objType.equals(KW_TRIGGER)) {
                ArrayList frags = this.getRoot().getSubFragments();
                frags = ((PlSqlFragment)frags.get(0)).getSubFragments();
                int i = 0;
                while (i < frags.size()) {
                    if (((PlSqlFragment)frags.get(i)).getFramentType() == PlSqlFragment.Type.PLSQL_BLOCK) {
                        rootFrag = (PlSqlFragment)frags.get(i);
                        break;
                    }
                    ++i;
                }
            } else {
                rootFrag = this.getRoot();
            }
            if (rootFrag != null) {
                int start = rootFrag.getFirstToken().getStart();
                int i = 0;
                while (i < start) {
                    sb.append(" ");
                    ++i;
                }
            }
            if (this.m_optionalNews.isEmpty()) {
                sb.append(rootFrag.getSource());
            } else {
                String threeSpaces = "   ";
                int start = rootFrag.getFirstToken().getStart();
                int end = this.m_optionalNews.get(0).getStart();
                sb.append(this.m_source.substring(start, end));
                sb.append("   ");
                int i = 0;
                while (i < this.m_optionalNews.size() - 1) {
                    start = this.m_optionalNews.get(i).getEnd() + 1;
                    end = this.m_optionalNews.get(i + 1).getStart();
                    sb.append(this.m_source.substring(start, end));
                    sb.append("   ");
                    ++i;
                }
                start = this.m_optionalNews.get(this.m_optionalNews.size() - 1).getEnd() + 1;
                sb.append(this.m_source.substring(start));
            }
            realBuffer = TextBufferFactory.createReadTextBuffer((String)sb.toString());
            realBuffer.readLock();
            try {
                root = PlsqlParser.parsePlsql((ReadTextBuffer)realBuffer);
            }
            finally {
                realBuffer.readUnlock();
            }
            this.m_errors = root.getErrors();
        }
        return this.m_errors;
    }

    public boolean hasParseErrors() {
        PlsqlError[] errors = this.getPlSqlErrors();
        return errors.length > 0;
    }

    public boolean containsToDo() {
        return this.m_containsToDo;
    }

    public String getRenamedSource(String newName) {
        StringBuilder newSource = new StringBuilder();
        if (this.m_nameToken != null) {
            newSource.append(this.m_source.substring(0, this.m_nameToken.getStart()));
            newSource.append(newName);
            PlSqlToken nToken = this.m_endMarker.getPrevCodeToken();
            PlSqlToken n1Token = nToken.getPrevCodeToken();
            PlSqlToken n2Token = n1Token.getPrevCodeToken();
            if (nToken.matches(PUNC_SEMICOLON) && n1Token.matches(this.m_nameToken.getSource()) && n2Token.matches(KW_END)) {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1, n1Token.getStart()));
                newSource.append(newName);
                newSource.append(this.m_source.substring(n1Token.getEnd() + 1));
            } else {
                newSource.append(this.m_source.substring(this.m_nameToken.getEnd() + 1));
            }
        }
        return newSource.toString();
    }

    public boolean isEvolvedType() {
        return this.m_evolvedType;
    }

    public String getUpdatedSourceForRelationRename(String newRelationName) {
        if (this.m_triggerBaseItemFragment == null) {
            return this.m_source;
        }
        StringBuilder newSource = new StringBuilder();
        newSource.append(this.m_source.substring(0, this.m_triggerBaseItemFragment.getStartOffset()));
        newSource.append(newRelationName);
        newSource.append(this.m_source.substring(this.m_triggerBaseItemFragment.getEndOffset() + 1));
        return newSource.toString();
    }

    String getSource(PlSqlToken start, PlSqlToken end) {
        return this.m_source.substring(start.getStart(), end.getEnd() + 1);
    }

    public static PlSqlInterrogator findOrCreate(String source) {
        WeakReference<PlSqlInterrogator> piRef;
        PlSqlInterrogator retval = null;
        if (m_invocations++ > 1000) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (String s : m_cache.keySet()) {
                WeakReference<PlSqlInterrogator> piRef2 = m_cache.get(s);
                if (piRef2 == null) {
                    keysToRemove.add(s);
                    continue;
                }
                if ((PlSqlInterrogator)piRef2.get() != null) continue;
                keysToRemove.add(s);
            }
            if (keysToRemove.size() > 0) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "PlSqlInterrogator - FLUSH: " + keysToRemove.size());
                int i = 0;
                while (i < keysToRemove.size()) {
                    m_cache.remove((String)keysToRemove.get(i));
                    ++i;
                }
            }
            m_invocations = 0;
        }
        if ((piRef = m_cache.get(source)) != null) {
            retval = (PlSqlInterrogator)piRef.get();
        }
        if (retval != null) {
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "PlSqlInterrogator - REUSE - cache size: " + m_cache.size());
        } else {
            retval = new PlSqlInterrogator(source);
            piRef = new WeakReference<PlSqlInterrogator>(retval);
            m_cache.put(source, piRef);
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "PlSqlInterrogator - NEW ENTRY - cache size: " + m_cache.size());
        }
        if (retval == null) {
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "BUG6189001 PlSqlInterrogator.findOrCreate returning null");
        }
        return retval;
    }

    int getSourceLength() {
        return this.m_source == null ? 0 : this.m_source.length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InterrogateState
    extends Enum<InterrogateState> {
        private static final /* synthetic */ InterrogateState[] $v;
        public static final /* enum */ InterrogateState PROCEDURE;
        public static final /* enum */ InterrogateState FUNCTION;
        public static final /* enum */ InterrogateState TRIGGER;
        public static final /* enum */ InterrogateState PLSQL_BLOCK;
        public static final /* enum */ InterrogateState DECLARATIVE_SECTION;
        public static final /* enum */ InterrogateState STATEMENT_BLOCK;
        public static final /* enum */ InterrogateState EXCEPTION_BLOCK;
        public static final /* enum */ InterrogateState SIMPLE_STATEMENT;
        public static final /* enum */ InterrogateState LABEL;
        public static final /* enum */ InterrogateState PARAMETER;
        public static final /* enum */ InterrogateState PARAMETER_LIST;
        public static final /* enum */ InterrogateState TRIGGER_EVENTS;
        public static final /* enum */ InterrogateState TRIGGER_COLUMNS;
        public static final /* enum */ InterrogateState CASE_STATEMENT;
        public static final /* enum */ InterrogateState ORACLE_TYPE_DECLN;
        public static final /* enum */ InterrogateState TYPE_SPEC;

        public static InterrogateState valueOf(String string) {
            return Enum.valueOf(InterrogateState.class, string);
        }

        public static final InterrogateState[] values() {
            return (InterrogateState[])$v.clone();
        }

        static {
            InterrogateState[] interrogateStateArray = new InterrogateState[16];
            interrogateStateArray[15] = TYPE_SPEC = new InterrogateState("TYPE_SPEC", 15);
            interrogateStateArray[14] = ORACLE_TYPE_DECLN = new InterrogateState("ORACLE_TYPE_DECLN", 14);
            interrogateStateArray[13] = CASE_STATEMENT = new InterrogateState("CASE_STATEMENT", 13);
            interrogateStateArray[12] = TRIGGER_COLUMNS = new InterrogateState("TRIGGER_COLUMNS", 12);
            interrogateStateArray[11] = TRIGGER_EVENTS = new InterrogateState("TRIGGER_EVENTS", 11);
            interrogateStateArray[10] = PARAMETER_LIST = new InterrogateState("PARAMETER_LIST", 10);
            interrogateStateArray[9] = PARAMETER = new InterrogateState("PARAMETER", 9);
            interrogateStateArray[8] = LABEL = new InterrogateState("LABEL", 8);
            interrogateStateArray[7] = SIMPLE_STATEMENT = new InterrogateState("SIMPLE_STATEMENT", 7);
            interrogateStateArray[6] = EXCEPTION_BLOCK = new InterrogateState("EXCEPTION_BLOCK", 6);
            interrogateStateArray[5] = STATEMENT_BLOCK = new InterrogateState("STATEMENT_BLOCK", 5);
            interrogateStateArray[4] = DECLARATIVE_SECTION = new InterrogateState("DECLARATIVE_SECTION", 4);
            interrogateStateArray[3] = PLSQL_BLOCK = new InterrogateState("PLSQL_BLOCK", 3);
            interrogateStateArray[2] = TRIGGER = new InterrogateState(PlSqlInterrogator.KW_TRIGGER, 2);
            interrogateStateArray[1] = FUNCTION = new InterrogateState(PlSqlInterrogator.KW_FUNCTION, 1);
            interrogateStateArray[0] = PROCEDURE = new InterrogateState(PlSqlInterrogator.KW_PROCEDURE, 0);
            $v = interrogateStateArray;
        }

        public String toString() {
            return super.toString().replaceAll("_", " ");
        }

        private InterrogateState(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState;
        static final /* synthetic */ int[] $sm$oracle$javatools$db$plsql$PlSqlToken$Type;

        static {
            int[] nArray = new int[PlSqlToken.Type.values().length];
            $sm$oracle$javatools$db$plsql$PlSqlToken$Type = nArray;
            try {
                nArray[PlSqlToken.Type.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.WHITESPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.MULTI_LINE_COMMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.SINGLE_LINE_COMMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.DOUBLE_QUOTED_STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.SINGLE_QUOTED_STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlToken$Type[PlSqlToken.Type.ALPHANUMERIC.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            int[] nArray2 = new int[InterrogateState.values().length];
            $sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState = nArray2;
            try {
                nArray2[InterrogateState.PROCEDURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.TRIGGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.TRIGGER_EVENTS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.TRIGGER_COLUMNS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.PLSQL_BLOCK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.DECLARATIVE_SECTION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.STATEMENT_BLOCK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.CASE_STATEMENT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.EXCEPTION_BLOCK.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.TYPE_SPEC.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.ORACLE_TYPE_DECLN.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.SIMPLE_STATEMENT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.LABEL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.PARAMETER_LIST.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlInterrogator$InterrogateState[InterrogateState.PARAMETER.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

