/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import oracle.javatools.db.plsql.PlSqlInterrogator;

public class PlSqlToken {
    private Type m_type;
    private int m_start;
    private int m_end;
    private PlSqlToken m_nextToken;
    private PlSqlToken m_prevToken;
    private WeakReference<PlSqlInterrogator> m_plsInt;

    PlSqlToken(PlSqlInterrogator plsInt, Type type, int start, PlSqlToken prev) {
        this.initialise(plsInt, type, start, prev);
    }

    PlSqlToken(PlSqlInterrogator plsInt, Type type, int start) {
        this.initialise(plsInt, type, start, null);
    }

    private void initialise(PlSqlInterrogator plsInt, Type type, int start, PlSqlToken prev) {
        this.m_plsInt = new WeakReference<PlSqlInterrogator>(plsInt);
        this.m_type = type;
        this.m_start = start;
        this.m_end = -1;
        if (prev == null) {
            this.m_prevToken = null;
            this.m_nextToken = null;
        } else {
            this.m_nextToken = prev.getNextToken();
            this.m_prevToken = prev;
            if (this.m_nextToken != null) {
                this.m_nextToken.setPrevToken(this);
            }
            this.m_prevToken.setNextToken(this);
        }
    }

    public Type getType() {
        return this.m_type;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getEnd() {
        return this.m_end;
    }

    public void setEnd(int end) {
        this.m_end = end;
    }

    public PlSqlToken getNextToken() {
        return this.m_nextToken;
    }

    public void setNextToken(PlSqlToken nextToken) {
        this.m_nextToken = nextToken;
    }

    public PlSqlToken getPrevToken() {
        return this.m_prevToken;
    }

    public void setPrevToken(PlSqlToken prevToken) {
        this.m_prevToken = prevToken;
    }

    public boolean isCode() {
        return this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.DOUBLE_QUOTED_STRING || this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.ALPHANUMERIC || this.m_type == Type.PUNCTUATION;
    }

    public PlSqlToken getPrevCodeToken() {
        PlSqlToken tk = this.getPrevToken();
        while (tk != null && tk.getType() != Type.END_MARKER && !tk.isCode()) {
            tk = tk.getPrevToken();
        }
        return tk;
    }

    public PlSqlToken getNextCodeToken() {
        return this.getNextCodeToken(1);
    }

    public PlSqlToken getNextCodeToken(int numAhead) {
        PlSqlToken tk = this.getNextToken();
        int counter = 0;
        while (tk != null && tk.getType() != Type.END_MARKER) {
            if (tk.isCode()) {
                ++counter;
            }
            if (counter >= numAhead) break;
            tk = tk.getNextToken();
        }
        return tk;
    }

    public String getSource() {
        if (this.m_type == Type.END_MARKER) {
            return "";
        }
        return ((PlSqlInterrogator)this.m_plsInt.get()).getSource(this, this);
    }

    public boolean matches(String str) {
        return str.equalsIgnoreCase(this.getSource());
    }

    public boolean firstCodeTokenOnLine() {
        boolean retval = false;
        PlSqlToken tk = this.getPrevToken();
        while (tk.getType() != Type.END_MARKER) {
            if (tk.getType() == Type.WHITESPACE && tk.getSource().contains("\n")) {
                return true;
            }
            if (tk.isCode()) {
                return false;
            }
            tk = tk.getPrevToken();
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Type
    extends Enum<Type> {
        private static final /* synthetic */ Type[] $v;
        public static final /* enum */ Type UNKNOWN;
        public static final /* enum */ Type WHITESPACE;
        public static final /* enum */ Type SINGLE_LINE_COMMENT;
        public static final /* enum */ Type MULTI_LINE_COMMENT;
        public static final /* enum */ Type SINGLE_QUOTED_STRING;
        public static final /* enum */ Type DOUBLE_QUOTED_STRING;
        public static final /* enum */ Type ALPHANUMERIC;
        public static final /* enum */ Type PUNCTUATION;
        public static final /* enum */ Type END_MARKER;

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        public static final Type[] values() {
            return (Type[])$v.clone();
        }

        static {
            Type[] typeArray = new Type[9];
            typeArray[8] = END_MARKER = new Type("END_MARKER", 8);
            typeArray[7] = PUNCTUATION = new Type("PUNCTUATION", 7);
            typeArray[6] = ALPHANUMERIC = new Type("ALPHANUMERIC", 6);
            typeArray[5] = DOUBLE_QUOTED_STRING = new Type("DOUBLE_QUOTED_STRING", 5);
            typeArray[4] = SINGLE_QUOTED_STRING = new Type("SINGLE_QUOTED_STRING", 4);
            typeArray[3] = MULTI_LINE_COMMENT = new Type("MULTI_LINE_COMMENT", 3);
            typeArray[2] = SINGLE_LINE_COMMENT = new Type("SINGLE_LINE_COMMENT", 2);
            typeArray[1] = WHITESPACE = new Type("WHITESPACE", 1);
            typeArray[0] = UNKNOWN = new Type("UNKNOWN", 0);
            $v = typeArray;
        }

        private Type(String string2, int n2) {
        }
    }
}

