/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.property.PropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyManager
implements PropertyManager {
    private DBObjectProvider m_pro;
    private Metadata m_meta;

    private void $init$() {
        this.m_meta = Metadata.getInstance();
    }

    protected AbstractPropertyManager(DBObjectProvider pro) {
        this.$init$();
        this.m_pro = pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger();
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? null : pro.getClass();
    }

    @Override
    public boolean supportsProperty(String type, Object propObj) {
        String prop = this.toString(propObj);
        return this.supportsProperty(type, prop, this.getProviderClass()) && this.canCreate(type, prop);
    }

    protected boolean supportsProperty(String type, String prop, Class<? extends DBObjectProvider> proClz) {
        Class<? extends DBObject> clz = this.m_meta.getObjectClass(type);
        return this.supportsProperty(clz, prop, proClz);
    }

    private boolean supportsProperty(Class clz, String prop, Class<? extends DBObjectProvider> proClz) {
        if (clz != null) {
            if (clz.isArray()) {
                clz = clz.getComponentType();
            }
            if (prop.contains("/")) {
                PropertyIterator iter;
                PropertyInfo info;
                int cut = prop.indexOf("/");
                String first = prop.substring(0, cut);
                String rest = prop.substring(cut + 1);
                if (this.m_meta.getSupportedProperties(clz, proClz).contains(first) && (info = (iter = new PropertyIterator(clz, proClz)).getPropertyInfos().get(first)) != null) {
                    Class propClz = info.getPropertyClass();
                    return this.supportsProperty(Map.class.isAssignableFrom(propClz) ? clz : propClz, rest, proClz);
                }
            } else {
                return this.m_meta.getSupportedProperties(clz, proClz).contains(prop);
            }
        }
        return false;
    }

    private String toString(Object propObj) {
        if (propObj instanceof Object[]) {
            Object[] arr;
            StringBuilder buff = new StringBuilder();
            Object[] objectArray = arr = (Object[])propObj;
            int n = 0;
            while (n < objectArray.length) {
                Object obj = objectArray[n];
                if (buff.length() > 0) {
                    buff.append("/");
                }
                buff.append(obj.toString());
                ++n;
            }
            return buff.toString();
        }
        return propObj.toString();
    }

    @Override
    public final PropertyAction canChangeProperty(DBObject original, DBObject update, Object propObj) {
        String prop = this.toString(propObj);
        if (this.supportsProperty(update.getType(), prop)) {
            if (original == null) {
                if (this.canCreate(update, prop)) {
                    return PropertyAction.CREATE;
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for CREATE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            } else {
                if (this.canChangeWithAlter(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: can ALTER on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return PropertyAction.ALTER;
                }
                if (this.canChangeWithReplace(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: cannot ALTER but can REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return PropertyAction.REPLACE;
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for ALTER or REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            }
        }
        return null;
    }

    protected boolean canCreate(DBObject newObj, String prop) {
        return this.canCreate(newObj.getType(), prop);
    }

    protected boolean canCreate(String type, String prop) {
        return true;
    }

    protected boolean canChangeWithAlter(DBObject orig, DBObject update, String prop) {
        return false;
    }

    protected boolean canChangeWithReplace(DBObject orig, DBObject update, String prop) {
        String type = update.getType();
        return (this.supportsAction(type, PropertyAction.REPLACE) || this.supportsAction(type, PropertyAction.DELETE)) && this.canCreate(update, prop);
    }

    @Override
    public final PropertyAction canUpdateObject(DBObject orig, DBObject update) {
        PropertyAction retval = orig == null ? PropertyAction.CREATE : PropertyAction.ALTER;
        DiffEngine de = this.getProvider().getDiffEngine();
        ResultSet rs = de.diff(orig, update).getResult();
        if (rs.isModified()) {
            Map<String, ResultSet> diffs = rs.getModifiedObjectMap();
            for (ResultSet propRS : diffs.values()) {
                String propName = propRS.getPropertyName();
                PropertyAction action = this.canChangeProperty(orig, update, propName);
                if (action == null) {
                    retval = null;
                    break;
                }
                if (retval != action && retval == PropertyAction.ALTER) {
                    retval = action;
                }
                retval.addProperty(propName);
            }
        }
        return retval;
    }
}

