/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    private MetadataImpl m_impl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata getInstance() {
        DBCore core = DBCore.getInstance();
        boolean doit = false;
        Class<Metadata> clazz = Metadata.class;
        synchronized (Metadata.class) {
            Metadata m = core.get(Metadata.class);
            if (m == null) {
                m = new Metadata();
                core.put(m);
            }
            Metadata metadata = m;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return metadata;
        }
    }

    private Metadata() {
    }

    synchronized MetadataImpl getMetadata() {
        if (this.m_impl == null) {
            this.m_impl = new MetadataImpl();
        }
        return this.m_impl;
    }

    public Map<String, Class<? extends DBObject>> getDBObjectClasses() {
        return this.getMetadata().getTypeMap();
    }

    public boolean isSchemaObject(String type) {
        Class<? extends DBObject> clz = this.getMetadata().getTypeMap().get(type);
        if (clz != null) {
            return SchemaObject.class.isAssignableFrom(clz);
        }
        return false;
    }

    public Class<? extends DBObject> getObjectClass(String type) {
        return this.getMetadata().getTypeMap().get(type);
    }

    public Collection<String> getAllTypes(Class<? extends DBObject> clz) {
        HashSet<String> types = new HashSet<String>();
        types.add(Metadata.getType(clz));
        Collection<Class<? extends DBObject>> impls = this.getMetadata().getImpementations(clz);
        if (impls != null) {
            for (Class<? extends DBObject> implclz : impls) {
                types.add(Metadata.getType(implclz));
            }
        }
        return types;
    }

    public DBObject newInstance(String type) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            try {
                DBObject dBObject = clz.newInstance();
                return dBObject;
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.FINE, "Error instantiating new DBObject", e);
            }
        }
        return null;
    }

    public Collection<String> getSupportedProperties(Class<? extends DBObject> objClz, Class<? extends DBObjectProvider> proClz) {
        HashSet<String> retval = new HashSet<String>();
        Collection<String> globalProps = this.m_impl.getProperties(objClz);
        if (globalProps != null) {
            retval.addAll(globalProps);
        }
        for (Map.Entry<String, PropertyKey> entry : this.m_impl.getExtraProps().entrySet()) {
            PropertyKey pk = entry.getValue();
            if ((proClz != null || !pk.provider().equals(DBObjectProvider.class)) && (proClz == null || !pk.provider().isAssignableFrom(proClz)) || objClz == null) continue;
            Class<? extends DBObject>[] classArray = pk.childOf();
            int n = 0;
            while (n < classArray.length) {
                Class<? extends DBObject> c = classArray[n];
                if (c.isAssignableFrom(objClz)) {
                    retval.add(entry.getKey());
                }
                ++n;
            }
        }
        return retval;
    }

    public static boolean isRealBean(Class<? extends Copyable> clz) {
        int m;
        return clz != null && Modifier.isPublic(m = clz.getModifiers()) && !Modifier.isAbstract(m) && !clz.isInterface();
    }

    public static String getType(Class<? extends DBObject> objClass) {
        if (objClass != null) {
            try {
                Field f = objClass.getField("TYPE");
                if (f != null) {
                    String string = (String)f.get(null);
                    return string;
                }
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.FINE, "Error getting object TYPE for class " + objClass.getName(), e);
            }
        }
        return null;
    }
}

