/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIterator {
    private Class m_objClass;
    private Class<? extends DBObjectProvider> m_proClass;

    public PropertyIterator(Class objClass, Class<? extends DBObjectProvider> proClass) {
        if (objClass == null) {
            throw new IllegalArgumentException("object class cannot be null");
        }
        this.m_objClass = objClass;
        this.m_proClass = proClass;
    }

    public Iterator<PropertyInfo> getPropertyIterator() {
        return this.getPropertyIterator(true, true, true);
    }

    public Iterator<PropertyInfo> getPropertyIterator(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        Map<String, PropertyInfo> infos = this.getPropertyInfos(excludeTransientGet, excludeTransientSet, beanOnly);
        TreeSet<PropertyInfo> propertyDescs = new TreeSet<PropertyInfo>();
        if (infos != null) {
            propertyDescs.addAll(infos.values());
        }
        return propertyDescs.iterator();
    }

    public Map<String, PropertyInfo> getPropertyInfos() {
        return this.getPropertyInfos(true, true, true);
    }

    public Map<String, PropertyInfo> getPropertyInfos(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        BeanInfo bi = this.getBeanInfo(this.m_objClass);
        if (bi != null) {
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                PropertyDescriptor desc = propertyDescriptorArray[n];
                if (this.isBeanalicious(desc, excludeTransientGet, excludeTransientSet)) {
                    props.put(desc.getName(), new PropertyInfo.DescriptorInfo(desc));
                }
                ++n;
            }
        }
        if (!beanOnly) {
            Metadata m = Metadata.getInstance();
            Map<String, PropertyKey> extraProps = m.getMetadata().getExtraProps();
            for (Map.Entry<String, PropertyKey> entry : extraProps.entrySet()) {
                Class<? extends DBObjectProvider> pro;
                PropertyKey pk = entry.getValue();
                boolean add = true;
                if (this.m_proClass != null && !(pro = pk.provider()).isAssignableFrom(this.m_proClass)) {
                    add = false;
                }
                if (add) {
                    add = false;
                    Class<? extends DBObject>[] classArray = pk.childOf();
                    int n = 0;
                    while (n < classArray.length) {
                        Class<? extends DBObject> childOf = classArray[n];
                        if (childOf.isAssignableFrom(this.m_objClass)) {
                            add = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!add) continue;
                String name = entry.getKey();
                if (!props.containsKey(name)) {
                    props.put(name, new PropertyInfo.KeyInfo(name, pk));
                    continue;
                }
                boolean i = false;
            }
        }
        return props;
    }

    private boolean isBeanalicious(PropertyDescriptor prop, boolean excludeTransientGet, boolean excludeTransientSet) {
        return this.isBeanalicious(prop.getReadMethod(), excludeTransientGet) && this.isBeanalicious(prop.getWriteMethod(), excludeTransientSet);
    }

    private boolean isBeanalicious(Method method, boolean excludeTransient) {
        if (method != null) {
            try {
                if (method.isAnnotationPresent(Transient.class)) {
                    boolean bl = false;
                }
                boolean bl = (method.isAnnotationPresent(Transient.class) && excludeTransient) ^ true;
                return bl;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private BeanInfo getBeanInfo(Class beanClass) {
        if (beanClass != null) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass, 3);
                return beanInfo;
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        return PropertyIterator.getPropertyInfos(bean.getClass());
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Class beanClass) {
        PropertyIterator iter = new PropertyIterator(beanClass, null);
        return iter.getPropertyInfos();
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Object bean) {
        return PropertyIterator.getPropertyIterator(bean.getClass());
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Class beanClz) {
        PropertyIterator iter = new PropertyIterator(beanClz, null);
        return iter.getPropertyIterator();
    }
}

