/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFromObjectUsage
extends AbstractSQLFragment
implements FromObjectUsage {
    private boolean m_qualified;
    private DBObjectID m_fromId;

    private void $init$() {
        this.m_qualified = true;
    }

    protected AbstractFromObjectUsage() {
        this.$init$();
    }

    @Deprecated
    protected AbstractFromObjectUsage(FromObject from) {
        this.$init$();
        this.m_fromId = from != null ? from.getID() : null;
    }

    protected AbstractFromObjectUsage(DBObjectID fromId) {
        this.$init$();
        this.m_fromId = fromId;
    }

    @Override
    @Deprecated
    @Transient
    public void setFromObject(FromObject from) {
        this.m_fromId = from != null ? from.getID() : null;
    }

    @Override
    @Deprecated
    @Transient
    public FromObject getFromObject() {
        return this.resolveFromObject();
    }

    @Override
    public FromObject resolveFromObject() {
        return this.resolveFromObject(this.m_fromId);
    }

    protected FromObject resolveFromObject(DBObjectID fromId) {
        FromObject from = null;
        try {
            if (fromId != null) {
                from = (FromObject)fromId.resolveID();
            }
        }
        catch (DBException e) {
            DBLog.logStackTrace(e);
        }
        return from;
    }

    @Override
    public void setFromObjectID(DBObjectID id) {
        this.m_fromId = id;
    }

    @Override
    public DBObjectID getFromObjectID() {
        return this.m_fromId;
    }

    @Override
    public void setQualified(boolean q) {
        this.m_qualified = q;
    }

    @Override
    public boolean isQualified() {
        return this.m_qualified;
    }

    protected void copyToImpl(AbstractFromObjectUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_fromId = this.m_fromId;
        target.m_qualified = this.m_qualified;
    }

    protected boolean equalsImpl(AbstractFromObjectUsage other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_fromId, (Object)other.m_fromId) && this.m_qualified == other.m_qualified;
    }

    protected StringBuilder getSQLTextImpl() {
        String rel;
        StringBuilder buff = new StringBuilder();
        FromObject from = this.resolveFromObject();
        if (from != null && this.isQualified() && ModelUtil.hasLength((String)(rel = from.getName())) && rel.indexOf(" ") < 0) {
            buff.append(rel);
            buff.append(".");
        }
        buff.append(this.getColumnName());
        return buff;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_fromId != null) {
            refs.add(this.m_fromId);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_fromId != null && idMap.containsKey(this.m_fromId)) {
            this.m_fromId = idMap.get(this.m_fromId);
            replaced = true;
        }
        return replaced;
    }
}

