/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.After;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentID;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSQLQuery
extends AbstractSQLFragment
implements SQLQuery {
    static final String INDENT = "    ";
    private boolean m_isDistinct;
    private WhereObject m_where;
    private GroupByObject m_groupby;
    private String m_distinctSource;
    private String m_wholeQuery;

    protected AbstractSQLQuery() {
    }

    @Override
    public String getType() {
        return "SQLQuery";
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (!ModelUtil.hasLength((String)name)) {
            name = "SQLQuery";
        }
        return name;
    }

    @Override
    @Transient
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public String getSQLText() {
        List<OrderByObject> obos;
        if (ModelUtil.hasLength((String)this.m_wholeQuery)) {
            return this.m_wholeQuery;
        }
        StringBuilder sql = new StringBuilder();
        this.appendSelectSQL(sql);
        this.appendFromSQL(sql);
        if (this.m_where != null) {
            sql.append("WHERE").append(" ").append("\n");
            sql.append(INDENT).append(this.m_where.getSQLText());
            sql.append(" ").append("\n");
        }
        if (this.m_groupby != null) {
            sql.append(this.m_groupby.getSQLText());
            sql.append(" ").append("\n");
        }
        if ((obos = this.getChildSupport().getChildList(OrderByObject.class, false)) != null && obos.size() > 0) {
            sql.append("ORDER BY").append(" ").append("\n");
            this.appendToBuffer(sql, obos, INDENT);
            sql.append(" ").append("\n");
        }
        return sql.toString();
    }

    protected void appendSelectSQL(StringBuilder sql) {
        sql.append("SELECT").append(" ");
        String distinct = this.getDistinctSource();
        if (ModelUtil.hasLength((String)distinct)) {
            sql.append(distinct).append(" ");
        }
        sql.append("\n");
        List<SelectObject> selects = this.getChildSupport().getChildList(SelectObject.class, false);
        this.appendToBuffer(sql, selects, INDENT);
        sql.append(" ").append("\n");
    }

    protected void appendFromSQL(StringBuilder sql) {
        sql.append("FROM").append(" ").append("\n");
        List<FromObject> froms = this.getChildSupport().getChildList(FromObject.class, false);
        this.appendToBuffer(sql, froms, INDENT);
        sql.append(" ").append("\n");
    }

    @After
    public String getQueryString() {
        return this.m_wholeQuery;
    }

    public void setQueryString(String query) {
        this.m_wholeQuery = query;
    }

    protected void clearQueryString() {
        this.m_wholeQuery = null;
    }

    @Override
    public SelectObject[] getSelectObjects() {
        return (SelectObject[])this.getChildSupport().getChildArray(SelectObject.class);
    }

    public void setSelectObjects(SelectObject[] selects) {
        this.clearQueryString();
        this.getChildSupport().setChildArray(SelectObject.class, selects);
    }

    public void addSelectObject(SelectObject s) {
        this.clearQueryString();
        this.getChildSupport().addChild(s);
    }

    public void addSelectObject(int index, SelectObject s) {
        this.clearQueryString();
        this.getChildSupport().addChild(index, s);
    }

    public boolean removeSelectObject(SelectObject s) {
        if (this.getChildSupport().removeChild(s)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveSelectObject(SelectObject s, int newIndex) {
        if (this.getChildSupport().moveChild(s, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(SelectObject s) {
        return this.getChildSupport().indexOfChild(s);
    }

    @Override
    public FromObject[] getFromObjects() {
        return (FromObject[])this.getChildSupport().getChildArray(FromObject.class);
    }

    public void setFromObjects(FromObject[] froms) {
        this.clearQueryString();
        this.getChildSupport().setChildArray(FromObject.class, froms);
    }

    public void addFromObject(FromObject f) {
        this.clearQueryString();
        this.getChildSupport().addChild(f);
    }

    public void addFromObject(int index, FromObject f) {
        this.clearQueryString();
        this.getChildSupport().addChild(index, f);
    }

    public boolean removeFromObject(FromObject f) {
        if (this.getChildSupport().removeChild(f)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveFromObject(FromObject f, int newIndex) {
        if (this.getChildSupport().moveChild(f, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(FromObject f) {
        return this.getChildSupport().indexOfChild(f);
    }

    @Override
    public OrderByObject[] getOrderByObjects() {
        return (OrderByObject[])this.getChildSupport().getChildArray(OrderByObject.class);
    }

    public void setOrderByObjects(OrderByObject[] orderBys) {
        this.clearQueryString();
        this.getChildSupport().setChildArray(OrderByObject.class, orderBys);
    }

    public void addOrderByObject(OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport().addChild(o);
    }

    public void addOrderByObject(int index, OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport().addChild(index, o);
    }

    public boolean removeOrderByObject(OrderByObject o) {
        if (this.getChildSupport().removeChild(o)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveOrderByObject(OrderByObject o, int newIndex) {
        if (this.getChildSupport().moveChild(o, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(OrderByObject o) {
        return this.getChildSupport().indexOfChild(o);
    }

    public void setWhereObject(WhereObject where) {
        this.clearQueryString();
        if (this.m_where != null) {
            this.removeThisAsParent(this.m_where);
        }
        this.m_where = where;
        if (this.m_where != null) {
            this.setChildFragment(this.m_where);
        }
    }

    @Override
    public WhereObject getWhereObject() {
        return this.m_where;
    }

    public void setGroupByObject(GroupByObject groupby) {
        this.clearQueryString();
        if (this.m_groupby != null) {
            this.removeThisAsParent(this.m_groupby);
        }
        this.m_groupby = groupby;
        if (this.m_groupby != null) {
            this.setChildFragment(this.m_groupby);
        }
    }

    @Override
    public GroupByObject getGroupByObject() {
        return this.m_groupby;
    }

    public void setDistinct(boolean isDistinct) {
        this.m_isDistinct = isDistinct;
    }

    public boolean isDistinct() {
        return this.m_isDistinct;
    }

    public void setDistinctSource(String distinctSource) {
        this.m_distinctSource = distinctSource;
    }

    public String getDistinctSource() {
        return this.m_distinctSource;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_where, types);
        this.includeOwnedObject(objs, this.m_groupby, types);
    }

    protected void copyToImpl(AbstractSQLQuery target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        HashMap idMap = new HashMap();
        target.m_isDistinct = this.m_isDistinct;
        target.m_distinctSource = this.m_distinctSource;
        target.setWhereObject(this.copyObject(this.m_where, target, idPolicy));
        target.setGroupByObject(this.copyObject(this.m_groupby, target, idPolicy));
        this.checkUsageChildren(this, target, target, idPolicy.getIDMap());
        target.m_wholeQuery = this.m_wholeQuery;
    }

    private void checkUsageChildren(SQLFragment obj, SQLFragment targ, AbstractSQLQuery query, Map<DBObjectID, DBObjectID> idMap) {
        targ.replaceReferenceIDs(idMap);
        if (obj != null) {
            DBObject[] kids = obj.getOwnedObjects();
            DBObject[] targKids = targ.getOwnedObjects();
            int i = 0;
            while (kids != null && i < kids.length) {
                this.checkUsageChildren((SQLFragment)kids[i], (SQLFragment)targKids[i], query, idMap);
                ++i;
            }
        }
    }

    protected boolean equalsImpl(AbstractSQLQuery other) {
        return super.equalsImpl(other) && other.m_isDistinct == this.m_isDistinct && ModelUtil.areEqual((Object)other.m_distinctSource, (Object)this.m_distinctSource) && ModelUtil.areEqual((Object)other.m_where, (Object)this.m_where) && ModelUtil.areEqual((Object)other.m_groupby, (Object)this.m_groupby) && ModelUtil.areEqual((Object)other.m_wholeQuery, (Object)this.m_wholeQuery);
    }

    private void setChildFragment(SQLFragment fragment) {
        if (fragment != null) {
            fragment.setParent(this);
            if (fragment.getID() instanceof SQLFragmentID) {
                ((SQLFragmentID)fragment.getID()).setParent(this.getID());
            }
        }
    }

    @Override
    public void setID(DBObjectID id) {
        DBObject[] kids;
        super.setID(id);
        DBObject[] dBObjectArray = kids = this.getOwnedObjects("SQLFragment");
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject kid = dBObjectArray[n];
            SQLFragment frag = (SQLFragment)kid;
            if (frag.getID() instanceof SQLFragmentID) {
                ((SQLFragmentID)frag.getID()).setParent(id);
            }
            ++n;
        }
    }
}

