/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObjectUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private DBObjectID m_id;
    private transient DBObjectProvider m_pro;

    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID id) {
        this.setObjectID(id);
    }

    @Override
    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    @Override
    public void setObjectID(DBObjectID id) {
        this.m_id = id;
    }

    @Override
    public DBObjectID getObjectID() {
        return this.m_id;
    }

    @Override
    public String getSQLText() {
        if (this.m_id != null) {
            String schema = null;
            String name = null;
            if (this.m_id instanceof NameBasedID) {
                schema = ((NameBasedID)this.m_id).getSchemaName();
                name = ((NameBasedID)this.m_id).getName();
            }
            if (!ModelUtil.hasLength(schema) || !ModelUtil.hasLength(name)) {
                try {
                    SchemaObject obj = (SchemaObject)this.m_id.resolveID();
                    if (obj != null) {
                        Schema s = obj.getSchema();
                        if (s != null) {
                            schema = s.getName();
                        }
                        name = obj.getName();
                    }
                }
                catch (DBException dbe) {
                    DBLog.logStackTrace(dbe);
                }
            }
            StringBuilder buff = new StringBuilder();
            if (this.isInDifferentSchema(schema)) {
                buff.append(this.getExternalName(schema)).append(".");
            }
            buff.append(this.getExternalName(name));
            return buff.toString();
        }
        return null;
    }

    protected boolean equalsImpl(AbstractSchemaObjectUsage other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_id, (Object)this.m_id);
    }

    protected void copyToImpl(AbstractSchemaObjectUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_id = this.m_id;
        target.m_pro = this.m_pro;
    }

    private boolean isInDifferentSchema(String schemaName) {
        Schema ourSchema = DBUtil.getSchema(this);
        if (ourSchema != null) {
            return ourSchema.getName().equals(schemaName) ^ true;
        }
        return false;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_id != null) {
            refs.add(this.m_id);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_id != null && idMap.containsKey(this.m_id)) {
            this.m_id = idMap.get(this.m_id);
            replaced = true;
        }
        return replaced;
    }

    protected String getExternalName(String name) {
        if (this.m_pro != null) {
            return this.m_pro.getExternalName(name);
        }
        return name;
    }
}

