/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class ArithmeticOperation
extends Operation {
    private int m_op;
    public static final int ADD = 10;
    public static final int SUBTRACT = 11;
    public static final int MULTIPLY = 12;
    public static final int DIVIDE = 13;
    public static final int NEGATE = 14;
    private static Map s_arithmetic = new HashMap();
    private static HashMap<Integer, Integer> s_operatorPrecedence;

    public ArithmeticOperation() {
        this.setFunctionFormat(false);
    }

    public ArithmeticOperation(int operator, SQLFragment[] args) {
        this();
        this.setArguments(args);
        this.setOperator(operator);
    }

    public int getOperator() {
        return this.m_op;
    }

    public void setOperator(int operator) {
        if (!ArithmeticOperation.isArithmeticOperation(operator)) {
            throw new IllegalArgumentException(DBArb.format(144, String.valueOf(operator)));
        }
        this.m_op = operator;
        this.setCommutative(operator == 10 || operator == 12);
    }

    public String getSQLText() {
        if (14 == this.getOperator()) {
            return this.getOperatorText() + this.getArguments()[0].getSQLText();
        }
        StringBuilder retval = new StringBuilder();
        SQLFragment[] args = this.getArguments();
        Integer precedence = s_operatorPrecedence.get(this.m_op);
        if (precedence == null) {
            precedence = 0;
        }
        int i = 0;
        while (i < args.length) {
            boolean addBrackets = false;
            if (args[i] instanceof ArithmeticOperation) {
                int subOp = ((ArithmeticOperation)args[i]).getOperator();
                Integer subExprPrec = s_operatorPrecedence.get(subOp);
                if (subExprPrec == null) {
                    subExprPrec = 1000;
                }
                if (subExprPrec < precedence || i > 0 && subExprPrec == precedence && this.m_op != subOp && (this.m_op == 11 || this.m_op == 13)) {
                    addBrackets = true;
                }
            }
            if (addBrackets) {
                retval.append("(");
            }
            retval.append(this.getTextOrNull(args[i]));
            if (addBrackets) {
                retval.append(")");
            }
            if (i < args.length - 1) {
                retval.append(" ");
                retval.append(this.getOperatorText());
                retval.append(" ");
            }
            ++i;
        }
        return retval.toString();
    }

    public String getOperatorText() {
        return ArithmeticOperation.getArithmeticOperation(this.m_op);
    }

    public boolean equals(Object obj) {
        return obj instanceof ArithmeticOperation && this.equalsImpl((ArithmeticOperation)obj);
    }

    protected boolean equalsImpl(ArithmeticOperation other) {
        boolean reallyEqual;
        boolean bl = reallyEqual = super.equalsImpl(other) && other.m_op == this.m_op;
        if (reallyEqual) {
            return true;
        }
        if (other.m_op == this.m_op && this.getArgumentCount() == 2 && other.getArgumentCount() == 2 && (this.m_op == 10 || this.m_op == 12)) {
            return this.getArguments()[0].equals(other.getArguments()[1]) && this.getArguments()[1].equals(other.getArguments()[0]);
        }
        return false;
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        ArithmeticOperation copy = target == null ? new ArithmeticOperation() : (ArithmeticOperation)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(ArithmeticOperation target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_op = this.m_op;
    }

    static {
        s_arithmetic.put(new Integer(10), "+");
        s_arithmetic.put(new Integer(11), "-");
        s_arithmetic.put(new Integer(12), "*");
        s_arithmetic.put(new Integer(13), "/");
        s_arithmetic.put(new Integer(14), "-");
        s_operatorPrecedence = new HashMap();
        s_operatorPrecedence.put(11, 1);
        s_operatorPrecedence.put(10, 1);
        s_operatorPrecedence.put(12, 2);
        s_operatorPrecedence.put(13, 2);
        s_operatorPrecedence.put(14, 3);
    }

    public static boolean isArithmeticOperation(int operandType) {
        return s_arithmetic.containsKey(new Integer(operandType));
    }

    public static String getArithmeticOperation(int operandType) {
        return (String)s_arithmetic.get(new Integer(operandType));
    }
}

