/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractDBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.util.ModelUtil;

public class ColumnUsage
extends AbstractDBObjectUsage {
    private List<String> m_attrs;
    private boolean m_outerJoin;
    private boolean m_alwaysQuote;

    private void $init$() {
        this.m_attrs = new ArrayList<String>();
        this.m_alwaysQuote = false;
    }

    public ColumnUsage() {
        this.$init$();
    }

    public ColumnUsage(DBObjectID colID) {
        super(colID, null);
        this.$init$();
    }

    public ColumnUsage(DBObjectID colID, FromObject from) {
        super(colID, from != null ? from.getID() : null);
        this.$init$();
    }

    public void setColumnID(DBObjectID colID) {
        if (colID != null) {
            this.setObjectID(colID);
        }
    }

    public String[] getAttributes() {
        return this.m_attrs.toArray(new String[this.m_attrs.size()]);
    }

    public void setAttributes(String[] attrs) {
        this.m_attrs.clear();
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = 0;
            while (n < stringArray.length) {
                String attr = stringArray[n];
                this.m_attrs.add(attr);
                ++n;
            }
        }
    }

    public void setOuterJoin(boolean oj) {
        this.m_outerJoin = oj;
    }

    public boolean isOuterJoin() {
        return this.m_outerJoin;
    }

    public String getSQLText() {
        StringBuilder buff = this.getSQLTextImpl();
        if (this.m_alwaysQuote && !buff.toString().startsWith("\"")) {
            buff = buff.insert(0, "\"");
            buff = buff.append("\"");
        }
        for (String attr : this.m_attrs) {
            buff.append(".").append(attr);
        }
        if (this.m_outerJoin) {
            buff.append("(+)");
        }
        return buff.toString();
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        ColumnUsage copy = target != null ? (ColumnUsage)target : new ColumnUsage();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof ColumnUsage && this.equalsImpl((ColumnUsage)obj);
    }

    protected boolean equalsImpl(ColumnUsage other) {
        return super.equalsImpl(other) && ModelUtil.areEqual(this.m_attrs, other.m_attrs) && this.m_outerJoin == other.m_outerJoin;
    }

    protected void copyToImpl(ColumnUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_outerJoin = this.m_outerJoin;
        target.m_attrs.clear();
        target.m_attrs.addAll(this.m_attrs);
    }

    @Transient
    public void setAlwaysQuote(boolean boo) {
        this.m_alwaysQuote = boo;
    }
}

