/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMiningFunction
extends Operation {
    private String m_func;
    private SQLFragment m_model;
    private boolean m_costModel;
    private DataMiningArguments m_args;

    public DataMiningFunction() {
        this.setFunctionFormat(true);
    }

    public DataMiningFunction(String function, SQLFragment model, boolean cost, SQLFragment[] dmSpecificArgs, SQLFragment[] usingArgs) {
        super(usingArgs);
        this.setFunctionFormat(true);
        this.setFunction(function);
        this.setModel(model);
        this.setCostModel(cost);
        this.setDataMiningArguments(new DataMiningArguments(dmSpecificArgs));
    }

    public String getFunction() {
        return this.m_func;
    }

    public void setFunction(String function) {
        this.m_func = function;
    }

    public boolean getCostModel() {
        return this.m_costModel;
    }

    public void setCostModel(boolean cm) {
        this.m_costModel = cm;
    }

    public void setModel(SQLFragment model) {
        this.changeParent(this.m_model, model);
        this.m_model = model;
    }

    public DataMiningArguments getDataMiningArguments() {
        return this.m_args;
    }

    public void setDataMiningArguments(DataMiningArguments args) {
        this.changeParent(this.m_args, args);
        this.m_args = args;
    }

    @Override
    protected String getOperatorText() {
        return this.getFunction();
    }

    public boolean equals(Object obj) {
        return obj instanceof DataMiningFunction && this.equalsImpl((DataMiningFunction)obj);
    }

    protected boolean equalsImpl(DataMiningFunction other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_func, (Object)this.m_func) && this.m_costModel == other.m_costModel && ModelUtil.areEqual((Object)other.m_model, (Object)this.m_model) && ModelUtil.areEqual((Object)other.m_args, (Object)this.m_args);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        DataMiningFunction copy = target == null ? new DataMiningFunction() : (DataMiningFunction)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(DataMiningFunction target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_func = this.m_func;
        target.m_costModel = this.m_costModel;
        target.m_model = this.copyObject(this.m_model, target, idPolicy);
        target.m_args = this.copyObject(this.m_args, target, idPolicy);
    }

    private boolean isSymbolFunction(String function) {
        int i = 0;
        while (i < function.length()) {
            if (Character.isLetterOrDigit(function.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Transient
    @Deprecated
    public SQLFragment[] getDmSpecificArgs() {
        return this.m_args == null ? new SQLFragment[]{} : this.m_args.getArguments();
    }

    @Deprecated
    public void setDmSpecificArgs(SQLFragment[] arguments) {
        this.setDataMiningArguments(new DataMiningArguments(arguments));
    }

    @Override
    public String getSQLText() {
        String argsText;
        String sep = this.getSeparator();
        StringBuilder sqltext = new StringBuilder(this.getOperatorText() + "( ");
        sqltext.append(this.getTextOrNull(this.m_model));
        if (this.m_args != null && ModelUtil.hasLength((String)(argsText = this.m_args.getSQLText()))) {
            sqltext.append(sep + " ").append(argsText);
        }
        if (this.m_costModel) {
            sqltext.append(" COST MODEL ");
        }
        sqltext.append(" USING ");
        sqltext.append(this.argsToString(Arrays.asList(this.getArguments()), false, sep, 0));
        sqltext.append(" )");
        return sqltext.toString();
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_args, types);
        this.includeOwnedObject(objs, this.m_model, types);
    }

    public static class DataMiningArguments
    extends AbstractSQLFragment {
        public DataMiningArguments() {
        }

        public DataMiningArguments(SQLFragment[] args) {
            this.setArguments(args);
        }

        public SQLFragment[] getArguments() {
            return (SQLFragment[])this.getChildSupport().getChildArray(SQLFragment.class);
        }

        public void setArguments(SQLFragment[] args) {
            this.getChildSupport().setChildArray(SQLFragment.class, args);
        }

        public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
            DataMiningArguments copy = target == null ? new DataMiningArguments() : (DataMiningArguments)target;
            this.copyToImpl(copy, copyParent, idPolicy);
            return copy;
        }

        public boolean equals(Object obj) {
            return obj instanceof DataMiningArguments && this.equalsImpl((DataMiningArguments)obj);
        }

        private DataMiningFunction getDMFunction() {
            return (DataMiningFunction)this.getParent();
        }

        public String getSQLText() {
            DataMiningFunction par = this.getDMFunction();
            if (par != null) {
                return par.argsToString(this.getChildSupport().getChildList(SQLFragment.class, false), false, par.getSeparator(), 0);
            }
            return null;
        }
    }
}

