/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class Function
extends Operation {
    private String m_func;
    private String m_distinctSource;
    private boolean m_grouping;
    private boolean m_isDistinct;

    public Function() {
        this.setFunctionFormat(true);
    }

    public Function(String function, SQLFragment[] arguments) {
        super(arguments);
        this.setFunction(function);
    }

    public Function(String function, SQLFragment[] arguments, String separator) {
        super(arguments);
        this.setFunction(function);
        this.setSeparator(separator);
    }

    public Function(String function, SQLFragment[] arguments, boolean grouping) {
        super(arguments);
        this.setFunction(function);
        this.setGrouping(grouping);
    }

    public Function(String function, SQLFragment[] arguments, String separator, boolean grouping) {
        super(arguments);
        this.setFunction(function);
        this.setSeparator(separator);
        this.setGrouping(grouping);
    }

    public String getFunction() {
        return this.m_func;
    }

    public void setFunction(String function) {
        if (this.isSymbolFunction(function)) {
            this.setFunctionFormat(false);
            this.setSeparator(null);
            this.setCommutative(true);
        } else {
            this.setFunctionFormat(true);
        }
        this.m_func = function;
    }

    public boolean isGrouping() {
        return this.m_grouping;
    }

    public void setGrouping(boolean grouping) {
        this.m_grouping = grouping;
    }

    public boolean isDistinct() {
        return this.m_isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.m_isDistinct = isDistinct;
    }

    public String getDistinctSource() {
        return this.m_distinctSource;
    }

    public void setDistinctSource(String distinctSource) {
        this.m_distinctSource = distinctSource;
    }

    protected String getDistinctText() {
        String result = "";
        if (this.m_grouping && ModelUtil.hasLength((String)this.getDistinctSource())) {
            result = this.getDistinctSource() + " ";
        }
        return result;
    }

    protected String getOperatorText() {
        return this.getFunction();
    }

    public boolean equals(Object obj) {
        return obj instanceof Function && this.equalsImpl((Function)obj);
    }

    protected boolean equalsImpl(Function other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_func, (Object)this.m_func) && ModelUtil.areEqual((Object)other.m_distinctSource, (Object)this.m_distinctSource) && this.m_grouping == other.m_grouping && this.m_isDistinct == other.m_isDistinct;
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Function copy = target == null ? new Function() : (Function)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Function target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_func = this.m_func;
        target.m_grouping = this.m_grouping;
        target.m_isDistinct = this.m_isDistinct;
        target.m_distinctSource = this.m_distinctSource;
    }

    private boolean isSymbolFunction(String function) {
        if (ModelUtil.hasLength((String)function)) {
            int i = 0;
            while (i < function.length()) {
                if (Character.isLetterOrDigit(function.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String getSeparator() {
        return super.getSeparator();
    }

    public void setSeparator(String string) {
        super.setSeparator(string);
    }
}

