/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionDefinition
implements Comparable {
    private String m_name;
    private int m_minargs;
    private int m_maxargs;
    private String m_desc;
    private String m_sql;
    private boolean m_group;
    private String m_returnType;

    public FunctionDefinition(String name, int args, String desc) {
        this(name, args, args, desc, false, null);
    }

    public FunctionDefinition(String name, int args, String desc, boolean isGrouping) {
        this(name, args, args, desc, isGrouping, null);
    }

    public FunctionDefinition(String name, int minargs, int maxargs, String desc) {
        this(name, minargs, maxargs, desc, false, null);
    }

    public FunctionDefinition(String name, int minargs, int maxargs, String desc, boolean isGrouping) {
        this(name, minargs, maxargs, desc, isGrouping, null);
    }

    public FunctionDefinition(String name, int args, String desc, String returnType) {
        this(name, args, args, desc, false, returnType);
    }

    public FunctionDefinition(String name, int args, String desc, boolean isGrouping, String returnType) {
        this(name, args, args, desc, isGrouping, returnType);
    }

    public FunctionDefinition(String name, int minargs, int maxargs, String desc, String returnType) {
        this(name, minargs, maxargs, desc, false, returnType);
    }

    public FunctionDefinition(String name, int minargs, int maxargs, String desc, boolean isGrouping, String returnType) {
        this.m_name = name;
        this.m_minargs = minargs;
        this.m_maxargs = maxargs;
        this.m_desc = desc;
        this.m_group = isGrouping;
        this.m_returnType = returnType;
    }

    public String getName() {
        return this.m_name;
    }

    public int getMaxArgs() {
        return this.m_maxargs;
    }

    public int getMinArgs() {
        return this.m_minargs;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public boolean isGrouping() {
        return this.m_group;
    }

    public String getSQLText() {
        if (this.m_sql == null) {
            StringBuilder sql = new StringBuilder();
            sql.append(this.m_name);
            if (this.m_minargs > 0) {
                sql.append("(");
                int i = 1;
                while (i < this.m_minargs) {
                    sql.append(",");
                    ++i;
                }
                sql.append(")");
            }
            this.m_sql = sql.toString();
        }
        return this.m_sql;
    }

    public String toString() {
        return this.getSQLText();
    }

    public int compareTo(Object o) {
        return this.m_name.compareTo(((FunctionDefinition)o).getName());
    }

    public String getReturnType() {
        return this.m_returnType;
    }
}

