/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.Operation;

public class GroupByExpression
extends Operation {
    public static final String TYPE = "GROUP BY EXPRESSION";
    private GroupingType m_gbType;

    private void $init$() {
        this.m_gbType = GroupingType.GROUPING_SETS;
    }

    public GroupByExpression() {
        this.$init$();
        this.setFunctionFormat(true);
    }

    public String getType() {
        return TYPE;
    }

    protected String getOperatorText() {
        return this.m_gbType.toString().replaceAll("_", " ");
    }

    public void setGroupByType(GroupingType type) {
        this.m_gbType = type;
    }

    public GroupingType getGroupByType() {
        return this.m_gbType;
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        GroupByExpression copy = target == null ? new GroupByExpression() : (GroupByExpression)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(GroupByExpression target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_gbType = this.m_gbType;
    }

    protected boolean equalsImpl(GroupByExpression other) {
        return super.equalsImpl(other) && this.m_gbType == other.m_gbType;
    }

    public boolean equals(Object obj) {
        return obj instanceof GroupByExpression && this.equalsImpl((GroupByExpression)obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GroupingType
    extends Enum<GroupingType> {
        private static final /* synthetic */ GroupingType[] $v;
        public static final /* enum */ GroupingType ROLLUP;
        public static final /* enum */ GroupingType CUBE;
        public static final /* enum */ GroupingType GROUPING_SETS;

        public static GroupingType valueOf(String string) {
            return Enum.valueOf(GroupingType.class, string);
        }

        public static final GroupingType[] values() {
            return (GroupingType[])$v.clone();
        }

        static {
            GroupingType[] groupingTypeArray = new GroupingType[3];
            groupingTypeArray[2] = GROUPING_SETS = new GroupingType("GROUPING_SETS", 2);
            groupingTypeArray[1] = CUBE = new GroupingType("CUBE", 1);
            groupingTypeArray[0] = ROLLUP = new GroupingType("ROLLUP", 0);
            $v = groupingTypeArray;
        }

        private GroupingType(String string2, int n2) {
        }
    }
}

