/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexObject
extends AbstractSQLFragment {
    public static final String TYPE = "IndexObject";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    private String m_order;
    private SQLFragment m_exp;

    public IndexObject() {
    }

    public IndexObject(SQLFragment exp) {
        this.setExpression(exp);
    }

    public IndexObject(SQLFragment exp, String ordering) {
        this.setExpression(exp);
        this.setOrder(ordering);
    }

    public String getOrder() {
        return this.m_order;
    }

    public void setOrder(String order) {
        if (order != null && !order.equals(ASC) && !order.equals(DESC)) {
            throw new IllegalArgumentException(DBArb.format(244, order));
        }
        this.m_order = order;
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment exp) {
        this.changeParent(this.m_exp, exp);
        this.m_exp = exp;
    }

    @Override
    public String getSQLText() {
        return this.getTextOrNull(this.m_exp) + (this.m_order == null ? "" : " " + this.m_order);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_exp, types);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        IndexObject copy = target != null ? (IndexObject)target : new IndexObject();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(IndexObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_exp = this.copyObject(this.m_exp, target, idPolicy);
        target.m_order = this.m_order;
    }

    protected boolean equalsImpl(IndexObject other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_exp, (Object)other.m_exp) && ModelUtil.areEqual((Object)this.m_order, (Object)other.m_order);
    }

    public boolean equals(Object obj) {
        return obj instanceof IndexObject && this.equalsImpl((IndexObject)obj);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

