/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinObject
extends AbstractSQLFragment {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String FULL = "FULL";
    public static final String INNER = "INNER";
    public static final String CROSS = "CROSS";
    private FromObject m_left;
    private FromObject m_right;
    private JoinCondition m_condition;
    private String m_type;
    private boolean m_incKeyword;
    private boolean m_natural;

    private void $init$() {
        this.m_incKeyword = true;
    }

    public JoinObject() {
        this.$init$();
    }

    public JoinObject(FromObject left, FromObject right, JoinCondition condition) {
        this.$init$();
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setCondition(condition);
    }

    public JoinObject(FromObject left, FromObject right, String type, boolean natural, JoinCondition condition) {
        this.$init$();
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setJoinType(type);
        this.setNatural(natural);
        this.setCondition(condition);
    }

    public FromObject getLeftExpression() {
        return this.m_left;
    }

    public void setLeftExpression(FromObject left) {
        this.changeParent(this.m_left, left);
        this.m_left = left;
    }

    public FromObject getRightExpression() {
        return this.m_right;
    }

    public void setRightExpression(FromObject right) {
        this.changeParent(this.m_right, right);
        this.m_right = right;
    }

    public boolean getIncludeJoinKeyword() {
        return this.m_incKeyword;
    }

    public void setIncludeJoinKeyword(boolean inc) {
        this.m_incKeyword = inc;
    }

    public String getJoinType() {
        return this.m_type;
    }

    public void setJoinType(String type) {
        this.m_type = type;
    }

    public boolean isNatural() {
        return this.m_natural;
    }

    public void setNatural(boolean natural) {
        if (CROSS.equals(this.m_type) && natural) {
            DBLog.logStackTrace(new SQLQueryException(DBArb.getString(59)));
        }
        this.m_natural = natural;
    }

    public JoinCondition getCondition() {
        return this.m_condition;
    }

    public void setCondition(JoinCondition condition) {
        if ((this.m_natural || CROSS.equals(this.m_type)) && condition != null) {
            DBLog.logStackTrace(new SQLQueryException(DBArb.getString(183)));
        } else {
            this.changeParent(this.m_condition, condition);
            this.m_condition = condition;
        }
    }

    public boolean isOuterJoin() {
        return this.m_type != null && !this.m_type.equals(INNER) && !this.m_type.equals(CROSS);
    }

    @Override
    public String getSQLText() {
        boolean subjoin;
        StringBuilder buff = new StringBuilder();
        boolean bl = subjoin = this.m_left != null && this.m_left.getExpression() instanceof JoinObject;
        if (subjoin) {
            buff.append("(");
        }
        buff.append(this.getTextOrNull(this.m_left));
        if (subjoin) {
            buff.append(")");
        }
        if (this.m_natural) {
            buff.append(" ").append("NATURAL");
        }
        if (INNER.equals(this.m_type)) {
            if (this.m_incKeyword) {
                buff.append(" ").append(this.m_type);
            }
        } else if (CROSS.equals(this.m_type)) {
            buff.append(" ").append(CROSS);
        } else if (this.isOuterJoin()) {
            buff.append(" ").append(this.m_type);
            if (this.m_incKeyword) {
                buff.append(" ").append("OUTER");
            }
        }
        buff.append(" ").append("JOIN");
        buff.append(" ");
        boolean bl2 = subjoin = this.m_right != null && this.m_right.getExpression() instanceof JoinObject;
        if (subjoin) {
            buff.append("(");
        }
        buff.append(this.getTextOrNull(this.m_right));
        if (subjoin) {
            buff.append(")");
        }
        if (this.m_condition != null && !this.m_natural) {
            buff.append(" ").append(this.m_condition.getSQLText());
        }
        return buff.toString();
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_left, types);
        this.includeOwnedObject(objs, this.m_right, types);
        this.includeOwnedObject(objs, this.m_condition, types);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        JoinObject copy = target == null ? new JoinObject() : (JoinObject)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(JoinObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_incKeyword = this.m_incKeyword;
        target.m_natural = this.m_natural;
        target.m_type = this.m_type;
        target.setLeftExpression(this.copyObject(this.m_left, target, idPolicy));
        target.setRightExpression(this.copyObject(this.m_right, target, idPolicy));
        target.setCondition(this.copyObject(this.m_condition, target, idPolicy));
    }

    protected boolean equalsImpl(JoinObject other) {
        return super.equalsImpl(other) && this.m_incKeyword == other.m_incKeyword && this.m_natural == other.m_natural && ModelUtil.areEqual((Object)this.m_type, (Object)other.m_type) && ModelUtil.areEqual((Object)this.m_left, (Object)other.m_left) && ModelUtil.areEqual((Object)this.m_right, (Object)other.m_right) && ModelUtil.areEqual((Object)this.m_condition, (Object)other.m_condition);
    }

    public boolean equals(Object obj) {
        return obj instanceof JoinObject && this.equalsImpl((JoinObject)obj);
    }
}

