/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
extends AbstractSQLFragment {
    protected static final String DEFAULT_SEPARATOR = ", ";
    private String m_separator;
    private boolean m_funcFormat;
    private boolean m_commutative;

    private void $init$() {
        this.m_separator = DEFAULT_SEPARATOR;
    }

    public Operation() {
        this.$init$();
    }

    public Operation(SQLFragment[] args) {
        this.$init$();
        this.setArguments(args);
    }

    protected void setFunctionFormat(boolean boo) {
        this.m_funcFormat = boo;
    }

    protected void setCommutative(boolean boo) {
        this.m_commutative = boo;
    }

    public SQLFragment[] getArguments() {
        return (SQLFragment[])this.getChildSupport().getChildArray(SQLFragment.class);
    }

    public void setArguments(SQLFragment[] arguments) {
        this.checkNewSize(arguments == null ? 0 : arguments.length);
        this.getChildSupport().setChildArray(SQLFragment.class, arguments);
    }

    public void addArgument(SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport().addChild(expression);
    }

    public void addArgument(int index, SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport().addChild(index, expression);
    }

    public void addArguments(SQLFragment[] expressions) {
        this.checkNewSize(this.getArgumentCount() + expressions.length);
        SQLFragment[] sQLFragmentArray = expressions;
        int n = 0;
        while (n < sQLFragmentArray.length) {
            SQLFragment e = sQLFragmentArray[n];
            this.getChildSupport().addChild(e);
            ++n;
        }
    }

    public boolean removeArgument(SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() - 1);
        return this.getChildSupport().removeChild(expression);
    }

    protected void checkNewSize(int proposedSize) {
    }

    public int getArgumentCount() {
        return this.getChildSupport().getChildCount(SQLFragment.class);
    }

    protected abstract String getOperatorText();

    protected void checkArgument(List<SQLFragment> existing, SQLFragment add) throws IllegalArgumentException {
    }

    protected void setSeparator(String separator) {
        this.m_separator = !ModelUtil.hasLength((String)separator) ? null : separator;
    }

    protected String getSeparator() {
        return this.m_separator;
    }

    protected String getDistinctText() {
        return "";
    }

    @Override
    public String getSQLText() {
        String sep = this.getSeparator();
        List<SQLFragment> args = this instanceof Comparison ? Arrays.asList(this.getArguments()) : this.getChildSupport().getChildList(SQLFragment.class, false);
        if (this.m_funcFormat) {
            String t = this.getDistinctText() + this.argsToString(args, this.m_commutative, sep, 0);
            t = this.surroundWithBrackets(t);
            return this.getOperatorText() + t;
        }
        if (sep == null) {
            return this.argsToString(args, this.m_commutative, " " + this.getOperatorText() + " ", 0);
        }
        StringBuilder retval = new StringBuilder();
        if (args != null && args.size() > 0) {
            boolean def = ModelUtil.areEqual((Object)sep, (Object)DEFAULT_SEPARATOR) && args.size() > 2;
            retval.append(args.get(0));
            retval.append(" ").append(this.getOperatorText()).append(" ");
            if (def) {
                retval.append("(");
            }
            retval.append(this.argsToString(args, this.m_commutative, sep, 1));
            if (def) {
                retval.append(")");
            }
        }
        return retval.toString();
    }

    protected String argsToString(List args, boolean commutative, String sep, int start) {
        StringBuilder retval = new StringBuilder();
        if (args != null) {
            boolean testBrackets = !commutative && args.size() > 1 && sep != DEFAULT_SEPARATOR;
            int i = 0;
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                SQLFragment next = (SQLFragment)iter.next();
                if (i++ < start) continue;
                if (testBrackets && (next == null || next.getClass().equals(this.getClass()))) {
                    String t = this.getTextOrNull(next);
                    t = this.surroundWithBrackets(t);
                    retval.append(t);
                } else {
                    retval.append(this.getTextOrNull(next));
                }
                if (!iter.hasNext()) continue;
                retval.append(sep);
            }
        }
        return retval.toString();
    }

    private String surroundWithBrackets(String text) {
        int lbrac = 40;
        int rbrac = 41;
        if (text.length() > 0 && text.charAt(0) == '(' && text.charAt(text.length() - 1) == ')') {
            int count = 1;
            int i = 1;
            while (i < text.length() - 1) {
                if (text.charAt(i) == ')') {
                    ++count;
                } else if (text.charAt(i) == '(') {
                    --count;
                }
                if (count <= 0) {
                    return '(' + text + ')';
                }
                ++i;
            }
            return text;
        }
        return '(' + text + ')';
    }

    protected boolean equalsImpl(Operation other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)other.m_separator, (Object)this.m_separator);
    }

    protected void copyToImpl(Operation target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_funcFormat = this.m_funcFormat;
        target.m_commutative = this.m_commutative;
        target.m_separator = this.m_separator;
    }
}

