/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByObject
extends AbstractSQLFragment {
    public static final String TYPE = "ORDER BY";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS_FIRST = "NULLS FIRST";
    public static final String NULLS_LAST = "NULLS LAST";
    private String m_order;
    private SQLFragment m_exp;
    private String m_null;

    public OrderByObject() {
    }

    public OrderByObject(SQLFragment exp) {
        this.setExpression(exp);
    }

    public OrderByObject(SQLFragment exp, String ordering) {
        this.setExpression(exp);
        this.setOrder(ordering);
    }

    public OrderByObject(SQLFragment exp, String ordering, String nullsOrder) {
        this.setExpression(exp);
        this.setOrder(ordering);
        this.setNullOrdering(nullsOrder);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getOrder() {
        return this.m_order;
    }

    public void setOrder(String order) {
        if (ModelUtil.hasLength((String)order) && !order.equalsIgnoreCase(ASC) && !order.equalsIgnoreCase(DESC)) {
            throw new IllegalArgumentException(DBArb.format(244, order));
        }
        this.m_order = order;
    }

    public String getNullOrdering() {
        return this.m_null;
    }

    public void setNullOrdering(String nullsFirstOrLast) {
        if (ModelUtil.hasLength((String)nullsFirstOrLast)) {
            nullsFirstOrLast = nullsFirstOrLast.replaceAll("\\s+", " ");
        }
        if (ModelUtil.hasLength((String)nullsFirstOrLast) && !nullsFirstOrLast.equalsIgnoreCase(NULLS_FIRST) && !nullsFirstOrLast.equalsIgnoreCase(NULLS_LAST)) {
            throw new IllegalArgumentException(DBArb.format(97, nullsFirstOrLast));
        }
        this.m_null = nullsFirstOrLast;
    }

    public SQLFragment getExpression() {
        return this.m_exp;
    }

    public void setExpression(SQLFragment exp) {
        this.changeParent(this.m_exp, exp);
        this.m_exp = exp;
    }

    @Override
    public String getSQLText() {
        return this.getTextOrNull(this.m_exp) + (this.m_order == null ? "" : " " + this.m_order) + (this.m_null == null ? "" : " " + this.m_null);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_exp, types);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        OrderByObject copy = target != null ? (OrderByObject)target : new OrderByObject();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(OrderByObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.setExpression(this.copyObject(this.m_exp, target, idPolicy));
        target.m_order = this.m_order;
        target.m_null = this.m_null;
    }

    protected boolean equalsImpl(OrderByObject other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_exp, (Object)other.m_exp) && ModelUtil.areEqual((Object)this.m_order, (Object)other.m_order) && ModelUtil.areEqual((Object)this.m_null, (Object)other.m_null);
    }

    public boolean equals(Object obj) {
        return obj instanceof OrderByObject && this.equalsImpl((OrderByObject)obj);
    }
}

