/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    private ParserUtils() {
    }

    public static String getHexToRawString(PlsqlNode node) {
        String result = null;
        if (node instanceof SqlOptdef && ((SqlOptdef)node).getOperatorType() == 102) {
            result = ParserUtils.getString((PlsqlNode)((SqlOptdef)node).getOperands()[0]);
        }
        return result;
    }

    public static String getString(PlsqlNode node) {
        String result = null;
        if (ParserUtils.isConstant(node) && ((SqlStrdef)node).getStringText().charAt(0) == '\'') {
            result = ((SqlStrdef)node).getStringText();
        }
        return result;
    }

    public static boolean isAllowedExpression(PlsqlNode node, List validOperators) {
        return node instanceof SqlExpression && validOperators.contains(new Integer(((SqlExpression)node).getOperatorType()));
    }

    public static boolean isAllowedStringType(PlsqlNode node, List validStringTypes) {
        return node instanceof SqlStrdef && validStringTypes.contains(new Integer(((SqlStrdef)node).getStringType()));
    }

    public static boolean isConstant(PlsqlNode node) {
        return node instanceof SqlStrdef && ((SqlStrdef)node).getStringType() == 0;
    }

    public static boolean isNull(PlsqlNode node) {
        return node instanceof SqlOpndef && ((SqlOpndef)node).getOperandType() == 3 && ((SqlOpndef)node).getStringType() == 8;
    }

    public static boolean isDbObjectName(PlsqlNode node) {
        return node instanceof SqlOpndef && (((SqlOpndef)node).getOperandType() == 1 || ((SqlOpndef)node).getOperandType() == 7);
    }

    public static String getConstant(PlsqlNode node) {
        return ParserUtils.isConstant(node) ? ((SqlStrdef)node).getStringText() : null;
    }

    public static Collection<String[]> getColumnNames(String expression, ExpressionType type) throws SQLQueryException {
        PlsqlRoot root = ParserUtils.parseQueryString(expression, ParserUtils.getSqlDriverType(type));
        ParserUtils.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units.length != 1 || !(units[0] instanceof SqlExpression)) {
            DBLog.getLogger().warning("SQL parser failure. Returned " + units.length + " PlsqlNode. Expecting 1 SqlExpression");
            return new HashSet<String[]>();
        }
        return ParserUtils.getColumnNames((SqlExpression)units[0]);
    }

    public static void checkErrors(PlsqlRoot root, String sql) throws SQLQueryException {
        PlsqlError[] errors = root.getErrors();
        if (errors != null && errors.length > 0) {
            throw new SQLParseException(errors, sql);
        }
    }

    public static Collection<String[]> getColumnNames(SqlExpression sqlExpression) {
        HashSet<String[]> columnNames = new HashSet<String[]>();
        SqlExpression[] operands = sqlExpression.getOperands();
        if (sqlExpression instanceof SqlQbcdef) {
            SqlQbcdef sqlqbc = (SqlQbcdef)sqlExpression;
            operands = sqlqbc.qbcsel;
        }
        if (operands != null) {
            int i = 0;
            while (i < operands.length) {
                if (operands[i] != null) {
                    columnNames.addAll(ParserUtils.getColumnNames(operands[i]));
                }
                ++i;
            }
        }
        if (sqlExpression instanceof SqlColdef) {
            SqlColdef coldef = (SqlColdef)sqlExpression;
            ArrayList<String> nameComponents = new ArrayList<String>();
            if (ModelUtil.hasLength((String)coldef.getColumnUserName())) {
                nameComponents.add(coldef.getColumnUserName());
            }
            if (ModelUtil.hasLength((String)coldef.getColumnTableName())) {
                nameComponents.add(coldef.getColumnTableName());
            }
            if (ModelUtil.hasLength((String)coldef.getColumnBaseName())) {
                nameComponents.add(coldef.getColumnBaseName());
            } else {
                nameComponents.addAll(Arrays.asList(coldef.getColumnAndAttributes()));
            }
            columnNames.add(nameComponents.toArray(new String[nameComponents.size()]));
        } else if (sqlExpression instanceof SqlSeldef) {
            SqlSeldef sqlsel = (SqlSeldef)sqlExpression;
            columnNames.addAll(ParserUtils.getColumnNames((SqlExpression)sqlsel.getSelopn()));
        }
        return columnNames;
    }

    public static PlsqlRoot parseQueryString(String expression, int type) throws SQLQueryException {
        try {
            ReadTextBuffer textBuffer = TextBufferFactory.createReadTextBuffer((String)expression);
            PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
            options.inputType = 16;
            SqlDriver sql = new SqlDriver();
            sql.setTextBuffer(textBuffer);
            PlsqlRoot plsqlRoot = sql.qcpidrv(type);
            return plsqlRoot;
        }
        catch (Exception e) {
            throw new SQLQueryException(DBArb.format(94, e.getMessage()));
        }
    }

    private static final int getSqlDriverType(ExpressionType type) {
        switch (1.$sm$oracle$javatools$db$sql$ParserUtils$ExpressionType[type.ordinal()]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExpressionType
    extends Enum<ExpressionType> {
        private static final /* synthetic */ ExpressionType[] $v;
        public static final /* enum */ ExpressionType BOOLEAN;
        public static final /* enum */ ExpressionType ARITHMETIC;
        public static final /* enum */ ExpressionType SELECT_LIST;
        public static final /* enum */ ExpressionType SQL_STATEMENT;

        public static ExpressionType valueOf(String string) {
            return Enum.valueOf(ExpressionType.class, string);
        }

        public static final ExpressionType[] values() {
            return (ExpressionType[])$v.clone();
        }

        static {
            ExpressionType[] expressionTypeArray = new ExpressionType[4];
            expressionTypeArray[3] = SQL_STATEMENT = new ExpressionType("SQL_STATEMENT", 3);
            expressionTypeArray[2] = SELECT_LIST = new ExpressionType("SELECT_LIST", 2);
            expressionTypeArray[1] = ARITHMETIC = new ExpressionType("ARITHMETIC", 1);
            expressionTypeArray[0] = BOOLEAN = new ExpressionType("BOOLEAN", 0);
            $v = expressionTypeArray;
        }

        private ExpressionType(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$sql$ParserUtils$ExpressionType;

        static {
            int[] nArray = new int[ExpressionType.values().length];
            $sm$oracle$javatools$db$sql$ParserUtils$ExpressionType = nArray;
            try {
                nArray[ExpressionType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$sql$ParserUtils$ExpressionType[ExpressionType.ARITHMETIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$sql$ParserUtils$ExpressionType[ExpressionType.SELECT_LIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

