/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.OracleSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public class SQLQueryBuilderFactory {
    private SQLQueryBuilderFactory() {
    }

    public static SQLQuery createQuery(DBObjectProvider provider, Schema defaultSchema, String sqlText) throws SQLParseException {
        try {
            SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, defaultSchema);
            try {
                builder.buildQuery(sqlText);
            }
            catch (SQLQueryClauseException ce) {
                // empty catch block
            }
            AbstractSQLQuery abstractSQLQuery = builder.getSQLQuery();
            return abstractSQLQuery;
        }
        catch (SQLQueryException e) {
            if (e instanceof SQLParseException) {
                throw (SQLParseException)e;
            }
            DBLog.log("SQLQueryBuilderFactory cannot build SQL: " + e.getMessage(), new Object[0]);
            NonDeclarativeSQLQuery nonDeclarativeSQLQuery = new NonDeclarativeSQLQuery(sqlText);
            return nonDeclarativeSQLQuery;
        }
    }

    public static SQLQuery createQuery(DBObjectProvider provider, SQLQueryOwner owner, String sqlText) throws SQLParseException {
        try {
            SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, owner instanceof SchemaObject ? ((SchemaObject)((Object)owner)).getSchema() : null);
            try {
                builder.buildQuery(sqlText, owner);
            }
            catch (SQLQueryClauseException ce) {
                // empty catch block
            }
            AbstractSQLQuery abstractSQLQuery = builder.getSQLQuery();
            return abstractSQLQuery;
        }
        catch (SQLQueryException e) {
            if (e instanceof SQLParseException) {
                throw (SQLParseException)e;
            }
            DBLog.log("SQLQueryBuilderFactory cannot build SQL: " + e.getMessage(), new Object[0]);
            NonDeclarativeSQLQuery nonDeclarativeSQLQuery = new NonDeclarativeSQLQuery(sqlText);
            return nonDeclarativeSQLQuery;
        }
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, null, null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema schema) {
        return new OracleSQLQueryBuilder(provider, schema);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, SQLQuery query) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(provider, null, query);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema defaultSchema, SQLQuery query) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(provider, defaultSchema, query);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, null, sqlText);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema defaultSchema, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, defaultSchema, sqlText);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, SQLQueryOwner owner, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, owner, sqlText);
    }

    private static SQLQueryBuilder createBuilderFromText(DBObjectProvider provider, DBObject parent, String sqlText) throws SQLQueryException {
        Schema defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, parent);
        SQLQueryOwner owner = parent instanceof SQLQueryOwner ? (SQLQueryOwner)parent : null;
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(provider, defaultSchema);
        builder.buildQuery(sqlText, owner);
        return builder;
    }

    private static SQLQueryBuilder createBuilderFromQuery(DBObjectProvider provider, Schema defaultSchema, SQLQuery query) throws SQLQueryException {
        defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, defaultSchema);
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(provider, defaultSchema);
        builder.buildQuery(query);
        return builder;
    }

    private static Schema checkDefaultSchema(DBObjectProvider provider, DBObject parent) {
        Schema defaultSchema = null;
        defaultSchema = parent instanceof Schema ? (Schema)parent : DBUtil.getSchema(parent);
        if (defaultSchema == null) {
            try {
                defaultSchema = provider.getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "cannot get default schema for sql query building", dbe);
            }
        }
        return defaultSchema;
    }
}

