/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectObjectUsage
extends AbstractFromObjectUsage {
    private DBObjectID m_selectID;

    public SelectObjectUsage() {
    }

    public SelectObjectUsage(SelectObject select, FromObject from) {
        this(select != null ? select.getID() : null, from);
    }

    public SelectObjectUsage(DBObjectID selectID, FromObject from) {
        this(selectID, from != null ? from.getID() : null);
    }

    public SelectObjectUsage(DBObjectID selectID, DBObjectID fromID) {
        super(fromID);
        this.setSelectObjectID(selectID);
    }

    @Deprecated
    @Transient
    public void setSelectObject(SelectObject used) {
        this.setSelectObjectID(used != null ? used.getID() : null);
    }

    @Deprecated
    @Transient
    public SelectObject getSelectObject() {
        return null;
    }

    public void setSelectObjectID(DBObjectID selectID) {
        this.m_selectID = selectID;
    }

    public DBObjectID getSelectObjectID() {
        return this.m_selectID;
    }

    private SelectObject resolveSelectObject() {
        SelectObject select = null;
        try {
            if (this.m_selectID != null) {
                select = (SelectObject)this.m_selectID.resolveID();
            }
        }
        catch (DBException e) {
            DBLog.logStackTrace(e);
        }
        return select;
    }

    @Override
    public String getSQLText() {
        return this.getSQLTextImpl().toString();
    }

    @Override
    public String getColumnName() {
        int index;
        SelectObject select = this.resolveSelectObject();
        String selectString = select == null ? null : select.getName();
        int n = index = selectString == null ? -1 : selectString.lastIndexOf(".");
        if (index > -1) {
            selectString = selectString.substring(index + 1);
        }
        return selectString;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        SelectObjectUsage copy = target == null ? new SelectObjectUsage() : (SelectObjectUsage)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(SelectObjectUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_selectID = this.m_selectID;
    }

    public boolean equals(Object obj) {
        return obj instanceof SelectObjectUsage && this.equalsImpl((SelectObjectUsage)obj);
    }

    protected boolean equalsImpl(SelectObjectUsage obj) {
        return super.equalsImpl(obj) && ModelUtil.areEqual((Object)this.m_selectID, (Object)obj.m_selectID);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_selectID != null) {
            refs.add(this.m_selectID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_selectID != null && idMap.containsKey(this.m_selectID)) {
            this.m_selectID = idMap.get(this.m_selectID);
            replaced = true;
        }
        return replaced;
    }
}

