/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;

public class SynonymUsage
extends AbstractSchemaObjectUsage {
    public SynonymUsage() {
    }

    public SynonymUsage(DBObjectID synID) {
        super(synID);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        SynonymUsage copy = target != null ? (SynonymUsage)target : new SynonymUsage();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof SynonymUsage && this.equalsImpl((SynonymUsage)obj);
    }

    public SchemaObject getReferencedObject() {
        DBObjectID id = this.getObjectID();
        if (id != null) {
            try {
                DBObjectID ref;
                Synonym syn = (Synonym)id.resolveID();
                if (syn != null && (ref = syn.getReference()) != null) {
                    SchemaObject schemaObject = (SchemaObject)ref.resolveID();
                    return schemaObject;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return null;
    }
}

