/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;

public class WindowFunction
extends Function {
    private static final String OVER = "OVER";
    private static final String PARTITION_BY = "PARTITION BY";

    public WindowFunction() {
        this((String)null);
    }

    public WindowFunction(String func) {
        super(func, null, false);
    }

    public void setPartitionBy(SQLFragment[] frags) {
        this.getChildSupport().setChildArray(SQLFragment.class, frags);
    }

    public SQLFragment[] getPartitionBy() {
        return (SQLFragment[])this.getChildSupport().getChildArray(SQLFragment.class);
    }

    public void setOrderBy(OrderByObject[] frags) {
        this.getChildSupport().setChildArray(OrderByObject.class, frags);
    }

    public OrderByObject[] getOrderBy() {
        return (OrderByObject[])this.getChildSupport().getChildArray(OrderByObject.class);
    }

    public String getSQLText() {
        boolean orderBy;
        String funcSQL = super.getSQLText();
        List<SQLFragment> partitionBys = this.getChildSupport().getChildList(SQLFragment.class, false);
        List<OrderByObject> orderBys = this.getChildSupport().getChildList(OrderByObject.class, false);
        boolean partBy = partitionBys != null && partitionBys.size() > 0;
        boolean bl = orderBy = orderBys != null && orderBys.size() > 0;
        if (partBy || orderBy) {
            StringBuilder buff = new StringBuilder(funcSQL);
            buff.append(" ").append(OVER).append("(");
            if (partBy) {
                buff.append(" ").append(PARTITION_BY).append(" ");
                buff.append(this.argsToString(partitionBys, true, ",", 0));
            }
            if (orderBy) {
                buff.append(" ").append("ORDER BY").append(" ");
                buff.append(this.argsToString(orderBys, true, ",", 0));
            }
            buff.append(")");
            return buff.toString();
        }
        return funcSQL;
    }

    public boolean equals(Object obj) {
        return obj instanceof WindowFunction && this.equalsImpl((WindowFunction)obj);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        WindowFunction copy = target == null ? new WindowFunction() : (WindowFunction)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }
}

