/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.feedback.client.FeedbackManagerImpl;
import oracle.ideimpl.feedback.client.Prefs;
import oracle.ideimpl.feedback.shared.StepsFeedback;

class FeedbackDialog
extends JPanel
implements ActionListener {
    private JButton _clearButton;
    private JEWTDialog _dialog;
    private JCheckBox _popupDialog;
    private JCheckBox _dontReportAgainDialog;
    private JTextArea _steps;
    private SizeKeeperCallback sizeKeeper;
    private static HashSet reportedExceptions = new HashSet();

    private void $init$() {
        this.sizeKeeper = new SizeKeeperCallback("FeedbackClientDialog");
    }

    public FeedbackDialog(JEWTDialog jewtDialog, String report) {
        super(new GridBagLayout());
        this.$init$();
        this.init(jewtDialog, report, true);
    }

    public FeedbackDialog(JEWTDialog jewtDialog, String report, boolean reportEnabled) {
        super(new GridBagLayout());
        this.$init$();
        this.init(jewtDialog, report, reportEnabled);
    }

    private void init(JEWTDialog jewtDialog, String report, boolean reportEnabled) {
        this._dialog = jewtDialog;
        Insets insets = new Insets(2, 2, 2, 2);
        DialogHeader dialogHeader = new DialogHeader();
        dialogHeader.setHeaderDescription("An unexpected condition has occured.\nPlease provide some information that would allow the developer to reproduce the problem");
        this._steps = new JTextArea();
        JPanel stepsPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this._steps);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        stepsPanel.add((Component)scrollPane, "Center");
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setEditable(false);
        textArea.setText(report);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane2 = new JScrollPane(textArea);
        scrollPane2.setBorder(BorderFactory.createEmptyBorder());
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportPanel.add((Component)scrollPane2, "Center");
        this._popupDialog = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._popupDialog, (String)"Show this &dialog immediately");
        this._popupDialog.setSelected(Prefs.getPrefs().isPopupDialog());
        this._dontReportAgainDialog = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._dontReportAgainDialog, (String)"Don't report exceptions more than once per session");
        this._dontReportAgainDialog.setSelected(Prefs.getPrefs().isDontReportAgainDialog());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Steps", stepsPanel);
        tabbedPane.add("Report", reportPanel);
        this.add((Component)dialogHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this.add((Component)this._popupDialog, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._dontReportAgainDialog, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this._clearButton = new JButton("Clear");
        this._clearButton.addActionListener(this);
    }

    public static void showDialog() {
        FeedbackDialog.runDialog(false);
    }

    public static void runDialog() {
        FeedbackDialog.runDialog(true);
    }

    private static void runDialog(boolean reportEnabled) {
        FeedbackManagerImpl feedbackManager = (FeedbackManagerImpl)FeedbackManager.getFeedbackManager();
        List<Feedback> feedbacks = feedbackManager.getFeedbacks();
        String report = feedbackManager.getReport(feedbacks);
        if (Prefs.getPrefs().isDontReportAgainDialog() && reportedExceptions.contains(report)) {
            feedbackManager.clearExceptions();
            return;
        }
        IdeMainWindow mainWindow = Ide.getMainWindow();
        JEWTDialog dialog = new JEWTDialog((Frame)mainWindow, "Feedback", 3);
        dialog.setPreferredSize(450, 400);
        dialog.setResizable(true);
        FeedbackDialog feedbackDialog = new FeedbackDialog(dialog, report, reportEnabled);
        dialog.addCustomButton((Component)feedbackDialog._clearButton);
        dialog.setContent((Component)feedbackDialog);
        dialog.setOKButtonText("Report");
        dialog.setOKButtonEnabled(reportEnabled);
        feedbackDialog.sizeKeeper.dialogAboutToRun((JDialog)dialog);
        dialog.addActionListener((ActionListener)feedbackDialog);
        boolean run = dialog.runDialog();
        Prefs.getPrefs().setPopupDialog(feedbackDialog._popupDialog.isSelected());
        Prefs.getPrefs().setDontReportAgainDialog(feedbackDialog._dontReportAgainDialog.isSelected());
        if (run) {
            feedbackManager.clearExceptions();
            String steps = feedbackDialog._steps.getText();
            if (steps.length() > 0) {
                feedbacks.add(new StepsFeedback(steps));
            }
            feedbackManager.sendExceptions(feedbacks);
            reportedExceptions.add(report);
        }
        if (feedbackDialog._dialog != null) {
            feedbackDialog._dialog.closeDialog(true);
            feedbackDialog._dialog.dispose();
            feedbackDialog._dialog = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._clearButton == source) {
            this.whenClear();
        }
    }

    private void whenClear() {
        FeedbackManagerImpl feedbackManager = (FeedbackManagerImpl)FeedbackManager.getFeedbackManager();
        feedbackManager.clearExceptions();
        if (this._dialog != null) {
            this._dialog.closeDialog(true);
            this._dialog.dispose();
            this._dialog = null;
        }
    }
}

