/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeArgs;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.ide.feedback.shared.MessageFeedback;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.feedback.client.FeedbackDialog;
import oracle.ideimpl.feedback.client.FeedbackWriter;
import oracle.ideimpl.feedback.client.Prefs;
import oracle.ideimpl.feedback.shared.ExceptionFeedback3;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.MessageDialog;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackManagerImpl
extends FeedbackManager
implements Addin,
Controller,
Thread.UncaughtExceptionHandler {
    private DataOutputStream _dataOutputStream;
    private int _feedbackCmdId;
    private int _feedbackMenuCmdId;
    private boolean _hasExceptions;
    private Semaphore _reportFlag;
    private ToolButton _feedbackButton;
    private JMenuItem feedbackMenuItem;
    private String _feedbackServer;
    private int _feedbackPort;

    private void $init$() {
        this._reportFlag = new Semaphore(1, true);
    }

    public FeedbackManagerImpl() {
        this.$init$();
        this.createFeedbackFile();
    }

    private void createFeedbackFile() {
        File feedbackFile = this.getFeedbackFile();
        feedbackFile.delete();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(feedbackFile);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this._dataOutputStream = new DataOutputStream(bufferedOutputStream);
            feedbackFile.deleteOnExit();
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
    }

    private File getFeedbackFile() {
        String systemDirectory = Ide.getSystemDirectory();
        File feedbackFile = new File(systemDirectory, "feedback.tmp");
        return feedbackFile;
    }

    public void initialize() {
        IdeArgs ideArgs = Ide.getIdeArgs();
        if (!Boolean.getBoolean("feedbackmanager.disable") && Boolean.getBoolean("feedbackclient2.disable") && !ideArgs.hasArg("-nofeedback") && this.readManifest()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
            FeedbackManagerImpl.setFeedbackManager((FeedbackManager)this);
            Ide.addIdeListener((IdeListener)new 1());
            Logger logger = Logger.getLogger("");
            logger.addHandler(new LogHandler(null));
            this.createActions();
            if (ideArgs.hasArg("-testfeedback")) {
                this.test();
            }
        }
    }

    private boolean readManifest() {
        boolean ret = false;
        ProductInformation productInfo = ProductInformation.getProductInformation();
        HashStructure infoHash = productInfo.getHashStructure();
        this._feedbackServer = infoHash.getString("feedback-server");
        if (this._feedbackServer != null) {
            this._feedbackPort = infoHash.getInt("feedback-port");
            if (this._feedbackPort != 0) {
                ret = true;
            }
        }
        return ret;
    }

    private void test() {
        switch (6) {
            case 1: {
                IllegalStateException exception = new IllegalStateException("This is a test");
                FeedbackManager.reportException((Throwable)exception);
                break;
            }
            case 2: {
                IllegalStateException exception = new IllegalStateException("This is a test");
                Logger.getLogger("IDE").log(Level.SEVERE, "Error Message", exception);
                break;
            }
            case 3: {
                try {
                    Assert.check((boolean)false);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
                break;
            }
            case 4: {
                new 1TestClass().foo();
            }
            case 5: {
                new 1TestClass2().foo();
            }
            case 6: {
                new 1TestClass3().foo();
            }
        }
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == this._feedbackCmdId) {
            action.setEnabled(this._hasExceptions);
            if (this._hasExceptions) {
                if (this._feedbackButton.getParent() == null) {
                    Toolbar toolbar = Ide.getToolbar();
                    toolbar.add((Component)this._feedbackButton);
                }
            } else if (this._feedbackButton.getParent() != null) {
                Toolbar toolbar = Ide.getToolbar();
                toolbar.remove((Component)this._feedbackButton);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == this._feedbackCmdId) {
            this.whenReport();
        } else if (commandId == this._feedbackMenuCmdId) {
            FeedbackDialog.showDialog();
        } else {
            return false;
        }
        return true;
    }

    private void createActions() {
        this._feedbackCmdId = Ide.findOrCreateCmdID((String)"FEEDBACK_CMD_ID");
        IdeAction feedbackAction = IdeAction.get((int)this._feedbackCmdId, null, (String)"Report a Problem", (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)IdeIcons.getInstance(), (int)7, null, (boolean)true);
        feedbackAction.addController((Controller)this);
        Toolbar toolbar = Ide.getToolbar();
        this._feedbackButton = toolbar.add((ToggleAction)feedbackAction);
        this._feedbackMenuCmdId = Ide.findOrCreateCmdID((String)"FEEDBACK_MENU_CMD_ID");
        IdeAction feedbackMenuAction = IdeAction.get((int)this._feedbackMenuCmdId, null, (String)"Feedback Manager", (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ResourceBundle)IdeIcons.getInstance(), null, null, (boolean)true);
        feedbackMenuAction.addController((Controller)this);
        Menubar menuMgr = Ide.getMenubar();
        this.feedbackMenuItem = menuMgr.createMenuItem((ToggleAction)feedbackMenuAction, MenuConstants.WEIGHT_VIEW_LOG + 0.001f);
        this.feedbackMenuItem.setEnabled(true);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)this.feedbackMenuItem, viewMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFeedbackImpl(Feedback feedback) {
        if (this._dataOutputStream != null) {
            DataOutputStream dataOutputStream = this._dataOutputStream;
            synchronized (dataOutputStream) {
                try {
                    this.writeFeedback(this._dataOutputStream, feedback);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected void reportExceptionImpl(String message, Throwable throwable, boolean printToConsole) {
        this.reportExceptionImpl(message, throwable, 0, true);
    }

    protected void reportExceptionImpl(String message, Throwable throwable, int apiMark, boolean print) {
        try {
            if (this._dataOutputStream != null) {
                ExceptionFeedback3 exceptionFeedback = new ExceptionFeedback3(message, throwable, apiMark);
                this.addFeedbackImpl(exceptionFeedback);
                this._hasExceptions = true;
                if (this._reportFlag.tryAcquire()) {
                    2 runnable = new 2();
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void reportApiExceptionImpl(String message, Throwable throwable, String apiName, boolean printToConsole) {
        int apiMark = -1;
        try {
            apiMark = FeedbackManagerImpl.getApiMarkFromReflection(throwable, apiName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (apiMark < 0) {
            apiMark = this.getApiMarkFromStackTrace(throwable, apiName);
        }
        this.reportExceptionImpl(message, throwable, apiMark, printToConsole);
    }

    private static int getApiMarkFromReflection(Throwable exception, String apiName) {
        Class callerClass;
        ArrayList<Class> callerClasses = new ArrayList<Class>(100);
        int i = 3;
        while ((callerClass = Reflection.getCallerClass((int)i)) != null) {
            callerClasses.add(callerClass);
            ++i;
        }
        StackTraceElement[] stackTrace = exception.getStackTrace();
        int stackPos = stackTrace.length - 1;
        int callerPos = callerClasses.size() - 1;
        while (stackPos >= 0 && callerPos >= 0) {
            String callerClassName;
            StackTraceElement stackTraceElement = stackTrace[stackPos];
            Class callerClass2 = (Class)callerClasses.get(callerPos);
            String stackTraceClassName = stackTraceElement.getClassName();
            if (stackTraceClassName.equals(callerClassName = callerClass2.getName())) {
                Annotation[] annotations;
                Annotation[] annotationArray = annotations = callerClass2.getAnnotations();
                int n = 0;
                while (n < annotationArray.length) {
                    Annotation annotation = annotationArray[n];
                    Class<? extends Annotation> cls = annotation.annotationType();
                    String name = cls.getName();
                    if (name.endsWith(".FeedbackApi")) {
                        try {
                            String value;
                            Object ret;
                            Method valueMethod = cls.getMethod("value", new Class[0]);
                            if (valueMethod != null && (ret = valueMethod.invoke((Object)annotation, new Object[0])) instanceof String && apiName.equals(value = (String)ret)) {
                                int n2 = stackPos + 1;
                                return n2;
                            }
                        }
                        catch (NoSuchMethodException ex) {
                        }
                        catch (IllegalAccessException ex) {
                        }
                        catch (InvocationTargetException ex) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
                --callerPos;
            }
            --stackPos;
        }
        return 0;
    }

    private int getApiMarkFromStackTrace(Throwable exception, String apiName) {
        int apiMark = 0;
        ClassLoader classLoader = this.getClass().getClassLoader();
        StackTraceElement[] stackTrace = exception.getStackTrace();
        int i = stackTrace.length - 2;
        while (apiMark == 0 && i >= 0) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            try {
                String value;
                Class<?> annotatedElement = classLoader.loadClass(className);
                FeedbackApi annotation = annotatedElement.getAnnotation(FeedbackApi.class);
                if (annotation != null && apiName.equals(value = annotation.value())) {
                    apiMark = i + 1;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            --i;
        }
        return apiMark;
    }

    protected final void writeFeedback(DataOutputStream outputStream, Feedback feedback) throws IOException {
        feedback.write(outputStream);
    }

    private void whenReport() {
        FeedbackDialog.runDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExceptions() {
        this._hasExceptions = false;
        DataOutputStream dataOutputStream = this._dataOutputStream;
        synchronized (dataOutputStream) {
            this.createFeedbackFile();
        }
        this.updateFeedbackAction();
    }

    private void updateFeedbackAction() {
        IdeAction action = IdeAction.find((int)this._feedbackCmdId);
        action.updateAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Feedback> getFeedbacks() {
        ArrayList<Feedback> ret = null;
        DataOutputStream dataOutputStream = this._dataOutputStream;
        synchronized (dataOutputStream) {
            DataOutputStream dataOutputStream2 = this._dataOutputStream;
            this._dataOutputStream = null;
            try {
                try {
                    ArrayList<Feedback> feedbacks = new ArrayList<Feedback>();
                    try {
                        dataOutputStream2.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    File feedbackFile = this.getFeedbackFile();
                    try {
                        FileInputStream fileInputStream = new FileInputStream(feedbackFile);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        while (dataInputStream.available() > 0) {
                            Feedback feedback = Feedback.read((ClassLoader)classLoader, (DataInputStream)dataInputStream);
                            feedbacks.add(feedback);
                        }
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ret = feedbacks;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this._dataOutputStream = dataOutputStream2;
            }
        }
        return ret;
    }

    String getReport(List feedbacks) {
        String ret = "";
        if (feedbacks != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(byteArrayOutputStream);
            int i = 0;
            while (i < feedbacks.size()) {
                Feedback feedback = (Feedback)feedbacks.get(i);
                feedback.dump(out);
                ++i;
            }
            ret = byteArrayOutputStream.toString();
        }
        return ret;
    }

    void sendExceptions(List feedbacks) {
        CountDownLatch latch = new CountDownLatch(1);
        1PB progressBar = new 1PB(this, (Component)Ide.getMainWindow(), latch);
        3 thread = new 3(this, feedbacks, progressBar, latch);
        thread.start();
        String bugNo = progressBar.start();
        if (bugNo == null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Failed to get a confirmation.", (String)"Bug Report", null);
        } else {
            URL url = URLFactory.newURL((String)("http://bug.us.oracle.com/pls/bug/webbug_edit.edit_info_top?rptno=" + bugNo));
            BrowserRunner.getBrowserRunner().runBrowserOnURL(url, null, null);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.reportExceptionImpl("Uncaught exception", e, true);
    }

    static DataOutputStream ra$_dataOutputStream(FeedbackManagerImpl feedbackManagerImpl) {
        return feedbackManagerImpl._dataOutputStream;
    }

    static String ra$_feedbackServer(FeedbackManagerImpl feedbackManagerImpl) {
        return feedbackManagerImpl._feedbackServer;
    }

    static int ra$_feedbackPort(FeedbackManagerImpl feedbackManagerImpl) {
        return feedbackManagerImpl._feedbackPort;
    }

    static void mav$updateFeedbackAction(FeedbackManagerImpl feedbackManagerImpl) {
        feedbackManagerImpl.updateFeedbackAction();
    }

    static Semaphore ra$_reportFlag(FeedbackManagerImpl feedbackManagerImpl) {
        return feedbackManagerImpl._reportFlag;
    }

    final class 1
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent e) {
            Ide.removeIdeListener((IdeListener)this);
            FeedbackManagerImpl.this.clearExceptions();
        }
    }

    @FeedbackApi(value="test")
    class 1TestClass {
        void foo() {
            this.bar();
        }

        void bar() {
            FeedbackManager.reportAPIException((String)"This is a test", (Throwable)new IllegalArgumentException(), (String)"test");
        }

        1TestClass() {
        }
    }

    @FeedbackApi(value="test")
    class 1TestClass2 {
        void foo() {
            this.bar();
        }

        void bar() {
            IllegalStateException exception = new IllegalStateException("This is a test");
            Logger.getLogger("IDE").log(Level.SEVERE, "API[test]: Error message", exception);
        }

        1TestClass2() {
        }
    }

    @FeedbackApi(value="test")
    class 1TestClass3 {
        void foo() {
            this.bar();
        }

        void bar() {
            IllegalStateException exception = new IllegalStateException("This is a test");
            IllegalArgumentException cause1 = new IllegalArgumentException("This is the first cause");
            exception.initCause(cause1);
            IllegalArgumentException cause2 = new IllegalArgumentException("This is the second cause");
            cause1.initCause(cause2);
            Logger.getLogger("IDE").log(Level.SEVERE, "API[test]: Error message", exception);
        }

        1TestClass3() {
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            try {
                FeedbackManagerImpl.mav$updateFeedbackAction(FeedbackManagerImpl.this);
                if (Prefs.getPrefs().isPopupDialog()) {
                    FeedbackDialog.runDialog();
                }
            }
            finally {
                FeedbackManagerImpl.ra$_reportFlag(FeedbackManagerImpl.this).release();
            }
        }
    }

    class 1PB
    implements Runnable {
        private static final int MAX_WAIT = 30;
        ProgressBar _progressBar;
        String _bugNo;
        private static final String INITIAL_TEXT = "Sending bug information.";
        private final /* synthetic */ CountDownLatch v$latch;
        final /* synthetic */ FeedbackManagerImpl this$0;

        private void $init$() {
            this._bugNo = null;
        }

        public 1PB(FeedbackManagerImpl feedbackManagerImpl, Component parent, CountDownLatch countDownLatch) {
            this.v$latch = countDownLatch;
            this.this$0 = feedbackManagerImpl;
            this.$init$();
            this._progressBar = new ProgressBar(parent, "Bug Report", (Runnable)this, false);
        }

        public String start() {
            this._progressBar.start(INITIAL_TEXT, "");
            return this._bugNo;
        }

        public void run() {
            int i = 0;
            while (i < 30) {
                this._progressBar.updateProgress(i * 3, INITIAL_TEXT, "Waiting for confirmation...");
                try {
                    this.v$latch.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            this._progressBar.setDoneStatus();
        }
    }

    final class 3
    extends Thread {
        private final /* synthetic */ List v$feedbacks;
        private final /* synthetic */ 1PB v$progressBar;
        private final /* synthetic */ CountDownLatch v$latch;
        final /* synthetic */ FeedbackManagerImpl this$0;

        public void run() {
            FeedbackWriter feedbackWriter = new FeedbackWriter();
            try {
                try {
                    feedbackWriter.open(FeedbackManagerImpl.ra$_feedbackServer(this.this$0), FeedbackManagerImpl.ra$_feedbackPort(this.this$0));
                    feedbackWriter.sendInfo();
                    if (this.v$feedbacks != null) {
                        int i = 0;
                        while (i < this.v$feedbacks.size()) {
                            Feedback feedback = (Feedback)this.v$feedbacks.get(i);
                            feedbackWriter.write(feedback);
                            ++i;
                        }
                    }
                    this.v$progressBar._bugNo = feedbackWriter.fileBug();
                    this.v$latch.countDown();
                }
                catch (IOException e) {
                    System.err.println("Failed to send the report to the server: " + e.getMessage());
                }
            }
            finally {
                feedbackWriter.close();
            }
        }

        public 3(FeedbackManagerImpl feedbackManagerImpl, List list, 1PB pB, CountDownLatch countDownLatch) {
            this.v$latch = countDownLatch;
            this.v$progressBar = pB;
            this.v$feedbacks = list;
            this.this$0 = feedbackManagerImpl;
        }
    }

    private class LogHandler
    extends Handler {
        public void publish(LogRecord record) {
            String message;
            Level level = record.getLevel();
            int levelValue = level.intValue();
            Throwable thrown = record.getThrown();
            String loggerName = record.getLoggerName();
            String logMessage = record.getMessage();
            if (logMessage != null) {
                SimpleFormatter simpleFormatter = new SimpleFormatter();
                message = simpleFormatter.format(record);
            } else {
                message = "No Log Message";
            }
            if (thrown != null && levelValue >= Level.SEVERE.intValue()) {
                int closing;
                String apiName = null;
                if (logMessage != null && logMessage.startsWith("API[") && logMessage.length() >= 6 && (closing = logMessage.indexOf(93)) >= 0) {
                    apiName = logMessage.substring(4, closing);
                }
                if (apiName != null) {
                    FeedbackManager.reportAPIException((String)message, (Throwable)thrown, apiName);
                } else {
                    FeedbackManagerImpl.this.reportExceptionImpl(message, thrown, true);
                }
            } else if (levelValue >= Level.FINER.intValue()) {
                MessageFeedback feedback = new MessageFeedback(loggerName + ":" + message);
                FeedbackManagerImpl.this.addFeedbackImpl((Feedback)feedback);
            }
        }

        public void flush() {
            try {
                FeedbackManagerImpl.ra$_dataOutputStream(FeedbackManagerImpl.this).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void close() throws SecurityException {
        }

        private LogHandler() {
        }

        LogHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

