/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.feedback.shared.Feedback;
import oracle.javatools.data.HashStructure;

public class FeedbackWriter {
    private Socket _socket;
    private DataOutputStream _outputStream;
    private DataInputStream _inputStream;

    public void open(String host, int port) throws IOException {
        this._socket = new Socket(host, port);
        OutputStream outputStream = this._socket.getOutputStream();
        this._outputStream = new DataOutputStream(outputStream);
        InputStream inputStream = this._socket.getInputStream();
        this._inputStream = new DataInputStream(inputStream);
        this._outputStream.writeInt(2);
        if (!this._inputStream.readBoolean()) {
            String message = "Feedback server does not support the client protocol";
            System.err.println("Feedback server does not support the client protocol");
            throw new IllegalStateException("Feedback server does not support the client protocol");
        }
    }

    public void sendInfo() {
        String userName = System.getProperty("user.name");
        ProductInformation productInfo = ProductInformation.getProductInformation();
        HashStructure infoHash = productInfo.getHashStructure();
        String bugDBProductId = infoHash.getString("bugdb-prod-id");
        String bugDBComponent = infoHash.getString("bugdb-comp-id");
        String productVersion = Version.VER_FULL;
        String buildLabel = Version.BUILD_LABEL;
        try {
            this._outputStream.writeChar(73);
            this._outputStream.writeUTF(userName);
            this._outputStream.writeUTF(bugDBProductId);
            this._outputStream.writeUTF(bugDBComponent);
            this._outputStream.writeUTF(productVersion);
            this._outputStream.writeUTF(buildLabel);
            Properties properties = System.getProperties();
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                this._outputStream.writeChar(1);
                this._outputStream.writeUTF(key);
                this._outputStream.writeUTF(value);
            }
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            Collection allExtensions = extensionRegistry.getAllExtensions();
            int count = 0;
            for (Extension extension : allExtensions) {
                String name = extension.getName();
                String version = extension.getVersion().toCanonicalString();
                this._outputStream.writeChar(1);
                this._outputStream.writeUTF("extension" + count + ".name");
                this._outputStream.writeUTF(String.valueOf(name));
                this._outputStream.writeChar(1);
                this._outputStream.writeUTF("extension" + count + ".version");
                this._outputStream.writeUTF(String.valueOf(version));
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String fileBug() {
        String ret = null;
        try {
            if (this._socket != null && this._inputStream != null && this._outputStream != null) {
                String bugNo;
                this._outputStream.writeChar(66);
                char c = this._inputStream.readChar();
                if (c == 'B' && !"null".equals(bugNo = this._inputStream.readUTF())) {
                    ret = bugNo;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void close() {
        try {
            if (this._socket != null) {
                if (this._inputStream != null && this._outputStream != null) {
                    this._outputStream.writeChar(113);
                    this._outputStream.close();
                    this._inputStream.close();
                }
                this._socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(Feedback feedback) throws IOException {
        this._outputStream.writeChar(70);
        feedback.write(this._outputStream);
    }
}

