/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ide.feedback.shared.Feedback;
import oracle.ideimpl.feedback.shared.MyStackTraceElement;

public class ExceptionFeedback
extends Feedback {
    private String _problem;
    private String _exceptionClassName;
    private String _message;
    protected MyStackTraceElement[] _stackTrace;

    public ExceptionFeedback() {
    }

    public ExceptionFeedback(String problem, Throwable throwable) {
        this._problem = problem;
        this._exceptionClassName = throwable.getClass().getName();
        this._message = throwable.toString();
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        this._stackTrace = new MyStackTraceElement[stackTraceElements.length];
        int i = 0;
        while (i < stackTraceElements.length) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            this._stackTrace[i] = new MyStackTraceElement(stackTraceElement);
            ++i;
        }
    }

    protected void writeImpl(DataOutputStream outputStream) throws IOException {
        outputStream.writeUTF(this._problem);
        outputStream.writeUTF(this._exceptionClassName);
        outputStream.writeUTF(this._message);
        outputStream.writeInt(this._stackTrace.length);
        MyStackTraceElement[] myStackTraceElementArray = this._stackTrace;
        int n = 0;
        while (n < myStackTraceElementArray.length) {
            MyStackTraceElement stackTraceElement = myStackTraceElementArray[n];
            String className = stackTraceElement.getClassName();
            String fileName = stackTraceElement.getFileName();
            int lineNumber = stackTraceElement.getLineNumber();
            String methodName = stackTraceElement.getMethodName();
            outputStream.writeUTF(className == null ? "" : className);
            outputStream.writeUTF(fileName == null ? "" : fileName);
            outputStream.writeInt(lineNumber);
            outputStream.writeUTF(methodName == null ? "" : methodName);
            ++n;
        }
    }

    protected void readImpl(DataInputStream inputStream) throws IOException {
        this._problem = inputStream.readUTF();
        this._exceptionClassName = inputStream.readUTF();
        this._message = inputStream.readUTF();
        this._stackTrace = new MyStackTraceElement[inputStream.readInt()];
        int i = 0;
        while (i < this._stackTrace.length) {
            String className = inputStream.readUTF();
            String fileName = inputStream.readUTF();
            int lineNumber = inputStream.readInt();
            String methodName = inputStream.readUTF();
            this._stackTrace[i] = new MyStackTraceElement(className, methodName, fileName, lineNumber);
            ++i;
        }
    }

    public void dumpImpl(PrintStream stream) {
        stream.println(this._problem);
        stream.println(this._message);
        MyStackTraceElement[] myStackTraceElementArray = this._stackTrace;
        int n = 0;
        while (n < myStackTraceElementArray.length) {
            MyStackTraceElement stackTraceElement = myStackTraceElementArray[n];
            String line = ExceptionFeedback.getLine(stackTraceElement);
            stream.println(" " + line);
            ++n;
        }
    }

    public String getBugTitle() {
        String exceptName = ExceptionFeedback.getShortExceptionName(this._exceptionClassName);
        MyStackTraceElement stackTraceElement = this.getBestStackElement();
        if (stackTraceElement != null) {
            String className = stackTraceElement.getClassName();
            String shortClassName = ExceptionFeedback.getShortClassName(className);
            return exceptName + " in " + shortClassName + ":" + stackTraceElement.getLineNumber();
        }
        return exceptName + " in (unknown)";
    }

    public String getLongBugTitle() {
        StringBuilder title = new StringBuilder(this.getBugTitle());
        int idx = this.getBestStackElementIndex();
        if (idx >= 0) {
            int i = idx + 1;
            while (i < this._stackTrace.length && i < idx + 5) {
                title.append(",");
                title.append(ExceptionFeedback.getShortClassName(this._stackTrace[i].getClassName()));
                ++i;
            }
        }
        return title.toString();
    }

    private static String getShortExceptionName(String exceptionName) {
        String[] prefixes;
        if (exceptionName.equals("java.lang.NullPointerException")) {
            return "NPE";
        }
        String[] stringArray = prefixes = new String[]{"java.lang.", "java.io.", "java.util."};
        int n = 0;
        while (n < stringArray.length) {
            String prefix = stringArray[n];
            if (exceptionName.startsWith(prefix)) {
                return exceptionName.substring(prefix.length());
            }
            ++n;
        }
        return exceptionName;
    }

    private static String getShortClassName(String className) {
        String[][] transforms;
        String[][] stringArrayArray = transforms = new String[][]{{"oracle.", "o."}, {"o.ide.", "o.i."}, {"o.ideimpl.", "o.ii."}, {"o.jdeveloper.", "o.j."}, {"o.jdevimpl.", "o.ji."}, {"java.", "j."}, {"j.awt.", "j.a."}, {"javax.", "jx."}, {"jx.swing.", "jx.s."}};
        int n = 0;
        while (n < stringArrayArray.length) {
            String[] transform = stringArrayArray[n];
            String from = transform[0];
            if (className.startsWith(from)) {
                String to = transform[1];
                className = to + className.substring(from.length());
            }
            ++n;
        }
        return className;
    }

    private int getBestStackElementIndex() {
        if (this._stackTrace != null) {
            int i = 0;
            while (i < this._stackTrace.length) {
                String className = this._stackTrace[i].getClassName();
                if (className.startsWith("oracle") && !className.startsWith("oracle.ide.util.Assert") && !className.startsWith("oracle.bali.share.Assert") && !className.startsWith("oracle.classloader.")) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public MyStackTraceElement getBestStackElement() {
        int idx = this.getBestStackElementIndex();
        if (idx >= 0) {
            return this._stackTrace[idx];
        }
        return null;
    }

    private static String getLine(MyStackTraceElement stackTraceElement) {
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String shortClassName = ExceptionFeedback.getShortClassName(className);
        String fileName = stackTraceElement.getFileName();
        int lineNumber = stackTraceElement.getLineNumber();
        String where = !stackTraceElement.isNativeMethod() ? (fileName != null ? (lineNumber >= 0 ? "(" + fileName + ":" + lineNumber + ")" : "(" + fileName + ")") : "(Unknown Source)") : "(Native Method)";
        String line = " " + shortClassName + "." + methodName + where;
        return line;
    }
}

