/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.feedback.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ideimpl.feedback.shared.ExceptionFeedback;
import oracle.ideimpl.feedback.shared.MyStackTraceElement;

public class ExceptionFeedback2
extends ExceptionFeedback {
    private int _apiMark;

    public ExceptionFeedback2() {
    }

    public ExceptionFeedback2(String problem, Throwable throwable) {
        this(problem, throwable, 0);
    }

    public ExceptionFeedback2(String problem, Throwable throwable, int apiMark) {
        super(problem, throwable);
        this._apiMark = apiMark;
    }

    protected void writeImpl(DataOutputStream outputStream) throws IOException {
        super.writeImpl(outputStream);
        outputStream.writeInt(this._apiMark);
    }

    protected void readImpl(DataInputStream inputStream) throws IOException {
        super.readImpl(inputStream);
        this._apiMark = inputStream.readInt();
    }

    public void dumpImpl(PrintStream stream) {
        super.dumpImpl(stream);
    }

    public MyStackTraceElement getBestStackElement() {
        int from;
        if (this._apiMark < 0) {
            this._apiMark = 0;
        }
        int i = from = Math.max(this._apiMark, 0);
        while (i < this._stackTrace.length) {
            MyStackTraceElement stackTraceElement = this._stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (className.startsWith("oracle") && !className.startsWith("oracle.ide.util.Assert") && !className.startsWith("oracle.bali.share.Assert") && !className.startsWith("oracle.classloader.")) {
                return stackTraceElement;
            }
            ++i;
        }
        if (this._stackTrace == null || this._stackTrace.length == 0) {
            System.out.println("!!!! ERROR: Empty StackTrace for class: " + this.getClass().getName());
            return null;
        }
        return this._stackTrace[0];
    }
}

