/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import oracle.ocvs.OCVSAddFileStateVisitor;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSUpdatedHandler;

public class OCVSAdd
extends OCVSCommand {
    public OCVSAdd() {
        super("add");
    }

    public String getCommandId() {
        return "add";
    }

    protected int indexOfFileArgument(String[] arguments) throws OCVSClientException {
        if (arguments.length <= 0) {
            throw new OCVSClientException("must specify at least one file or directory");
        }
        return super.indexOfFileArgument(arguments);
    }

    protected OCVSResource[] processResources(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
        resources = super.processResources(session, resources);
        File dir = session.getWorkingDirectory();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isDirectory() && !resources[i].getFile().equals(dir) && ((OCVSDirectory)resources[i]).isManaged()) {
                throw new OCVSClientException(MessageFormat.format("there is a version in {0} already", resources[i].getLocalPath()));
            }
            ++i;
        }
        return resources;
    }

    protected OCVSFileStateVisitor createResourceVisitor() {
        return new OCVSAddFileStateVisitor();
    }

    protected void initializeResourceVisitor(OCVSFileStateVisitor visitor, Map options) {
        super.initializeResourceVisitor(visitor, options);
        visitor.setUseIsModified(true);
        visitor.setSuppressQuestionable(true);
    }

    protected void sessionFinished(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSClientException {
        if (options.containsKey(OCVSCommand.OPTION_DO_NOT_EXEC_DISK)) {
            return;
        }
        OCVSResponseHandler responseHandler = session.getResponseRegistry().lookupResponseHandler("Updated");
        if (responseHandler == null || !(responseHandler instanceof OCVSUpdatedHandler)) {
            return;
        }
        OCVSUpdatedHandler updatedHandler = (OCVSUpdatedHandler)responseHandler;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isDirectory()) {
                updatedHandler.createDirectoryStructure(session, (OCVSDirectory)resources[i]);
            }
            ++i;
        }
    }
}

