/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSExpandModules;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPruneDirectoriesVisitor;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSUpdate;

public class OCVSCheckout
extends OCVSCommand {
    public static final OCVSOption OPTION_PRUNE_EMPTY_DIRECTORIES = OCVSUpdate.OPTION_PRUNE_EMPTY_DIRECTORIES;
    public static final OCVSOption OPTION_CAT_MODULE_DATABASE = new OCVSOption("-c", 2);
    public static final OCVSOption OPTION_CAT_MODULE_DATABASE_WITH_STATUS = new OCVSOption("-s", 2);
    public static final OCVSOption OPTION_CHECK_OUT_INTO_DIR = new OCVSOption("-d", 2);
    public static final OCVSOption OPTION_DO_NOT_SHORTEN_PATHNAMES = new OCVSOption("-N", 2);
    private File _checkoutDirectoryFile;

    public OCVSCheckout() {
        super("co");
    }

    public String getCommandId() {
        return "checkout";
    }

    protected void verifyAbsolutePathArgument(String path) {
    }

    protected int indexOfFileArgument(Map options, String[] arguments) throws OCVSClientException {
        if (options.containsKey(OPTION_CAT_MODULE_DATABASE)) {
            return -1;
        }
        if (options.containsKey(OPTION_CAT_MODULE_DATABASE_WITH_STATUS)) {
            return -1;
        }
        return super.indexOfFileArgument(arguments);
    }

    protected void processOptions(OCVSSession session, Map options) throws IOException, OCVSClientException {
        super.processOptions(session, options);
        this._checkoutDirectoryFile = null;
        if (!options.containsKey(OPTION_CHECK_OUT_INTO_DIR)) {
            options.put(OPTION_DO_NOT_SHORTEN_PATHNAMES, null);
            return;
        }
        this._checkoutDirectoryFile = new File((String)options.get(OPTION_CHECK_OUT_INTO_DIR));
        if (this._checkoutDirectoryFile.isAbsolute()) {
            super.verifyAbsolutePathArgument(this._checkoutDirectoryFile.getPath());
        }
    }

    protected String[] processArguments(OCVSSession session, String[] arguments) throws OCVSClientException {
        return arguments;
    }

    protected void sessionStarted(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
        if (resources == null) {
            return;
        }
        String[] arguments = new String[resources.length];
        int i = 0;
        while (i < arguments.length) {
            arguments[i] = resources[i].getLocalPath();
            ++i;
        }
        new OCVSExpandModules().executeRequest(session, arguments);
    }

    protected OCVSResource[] processResources(OCVSSession session, OCVSResource[] resources) throws OCVSClientException {
        return this.createCheckoutResourceStructure(session);
    }

    protected void sendResourceArguments(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
        super.sendResourceArguments(session, this.createResourceStructure(session, session.getModuleExpansions()));
    }

    protected void sessionFinished(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
        if (resources == null) {
            return;
        }
        if (!options.containsKey(OPTION_PRUNE_EMPTY_DIRECTORIES)) {
            return;
        }
        resources = this.createCheckoutResourceStructure(session);
        OCVSPruneDirectoriesVisitor visitor = new OCVSPruneDirectoriesVisitor();
        this.initializeBaseResourceVisitor(visitor, options);
        visitor.visit(session, resources);
    }

    private OCVSResource[] createCheckoutResourceStructure(OCVSSession session) throws OCVSClientException {
        if (this._checkoutDirectoryFile == null) {
            return this.createResourceStructure(session, session.getModuleExpansions());
        }
        return this.createResourceStructure(session, new String[]{this._checkoutDirectoryFile.getPath()});
    }
}

