/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import oracle.ocvs.OCVSBaseResourceVisitor;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSExtConnection;
import oracle.ocvs.OCVSFileNameConstants;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSForkConnection;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPServerConnection;
import oracle.ocvs.OCVSPServerRoot;
import oracle.ocvs.OCVSPassFile;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRequest;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSScramble;
import oracle.ocvs.OCVSSession;
import oracle.ocvs.OCVSSessionIO;
import oracle.ocvs.OCVSSsh2Connection;
import oracle.ocvs.OCVSSsh2Root;
import oracle.ocvs.OCVSUserInfo;

public abstract class OCVSCommand
extends OCVSRequest {
    public static final OCVSOption OPTION_OVERRIDE_CVSROOT = new OCVSOption(0);
    public static final OCVSOption OPTION_USE_COMPRESSION = new OCVSOption(0);
    public static final OCVSOption OPTION_DO_NOT_CONVERT_EOLS = new OCVSOption(0);
    public static final OCVSOption OPTION_USE_OUTPUT_ENCODING = new OCVSOption(0);
    public static final OCVSOption OPTION_BE_REALLY_QUIET = new OCVSOption("-Q", 1);
    public static final OCVSOption OPTION_BE_SOMEWHAT_QUIET = new OCVSOption("-q", 1);
    public static final OCVSOption OPTION_DO_NOT_EXEC_DISK = new OCVSOption("-n", 1);
    public static final OCVSOption OPTION_LOCAL_DIRECTORY_ONLY = new OCVSOption("-l", 2);
    public static final OCVSOption OPTION_USE_FILE_REVISION = new OCVSOption("-r", 2);
    public static final OCVSOption OPTION_USE_DATE = new OCVSOption("-D", 2);
    public static final OCVSOption OPTION_USE_RCS_KOPT = new OCVSOption("-k", 2);
    public static final OCVSOption OPTION_DO_NOT_RUN_MODULE_PROGRAM = new OCVSOption("-n", 2);
    public static final OCVSOption OPTION_FORCE_HEAD_REVISION_MATCH = new OCVSOption("-f", 2);
    private Map _envp;
    private OCVSResponseRegistry _responseRegistry;

    public OCVSCommand(String requestId) {
        super(requestId);
    }

    public abstract String getCommandId();

    public void setEnvironmentParams(Map envp) {
        this._envp = Collections.unmodifiableMap(envp);
    }

    public Map getEnvironmentParams() {
        return this._envp;
    }

    public void setResponseRegistry(OCVSResponseRegistry responseRegistry) {
        this._responseRegistry = responseRegistry;
    }

    public OCVSResponseRegistry getResponseRegistry() {
        return this._responseRegistry;
    }

    public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
        String requestId;
        int fileArgumentIndex = this.indexOfFileArgument(options, arguments);
        if (fileArgumentIndex >= 0) {
            this.verifyWorkingDirectory(dir);
        }
        if ((requestId = this.getRequestId()) == null) {
            return 0;
        }
        OCVSRoot root = this.constructRoot(dir, options);
        OCVSConnection connection = this.createRootConnection(root, io);
        OCVSSession session = new OCVSSession(new OCVSSessionIO(io, this.getCommandId()), dir, root, connection);
        OCVSResponseRegistry responseRegistry = this._responseRegistry != null ? this._responseRegistry : OCVSResponseRegistry.getInstance();
        session.setResponseRegistry(responseRegistry);
        if (options.containsKey(OPTION_DO_NOT_EXEC_DISK)) {
            session.setNoExecDisk(true);
        }
        if (options.containsKey(OPTION_USE_COMPRESSION)) {
            this.initializeCompressionLevel(session, options);
        }
        if (options.containsKey(OPTION_DO_NOT_CONVERT_EOLS)) {
            session.setNoConvertEOLs(true);
        }
        if (options.containsKey(OPTION_USE_OUTPUT_ENCODING)) {
            session.setEncoding((String)options.get(OPTION_USE_OUTPUT_ENCODING));
        }
        this.processOptions(session, options);
        OCVSResource[] resources = null;
        if (fileArgumentIndex >= 0) {
            resources = this.createResourceStructure(session, options, this.processArguments(session, this.extractFileArguments(arguments, fileArgumentIndex)));
        }
        this.openConnection(connection, root);
        try {
            this.authenticateUser(connection, root, false);
            session.sendRootEtCetera();
            this.sessionStarted(session, options, resources);
            if (resources != null) {
                resources = this.processResources(session, resources);
            }
            this.sendGlobalOptions(session, options);
            this.sendLocalOptions(session, options);
            this.sendArguments(session, arguments, fileArgumentIndex);
            if (resources != null) {
                this.sendResourceState(session, options, resources);
                this.sendResourceArguments(session, resources);
                this.sendWorkingDirectory(session);
            }
            this.sessionPrepared(session, options, resources);
            this.executeRequest(session);
            this.sessionFinished(session, options, resources);
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            connection.close();
        }
    }

    protected OCVSRoot constructRoot(File dir, Map options) throws IOException, ParseException, OCVSClientException {
        String[] rootData;
        String root = null;
        if (root == null && options != null) {
            root = (String)options.get(OPTION_OVERRIDE_CVSROOT);
        }
        if (root == null && dir != null && (rootData = OCVSFileUtil.readFileLines(new File(dir, OCVSFileNameConstants.CVSADM_ROOT))) != null && rootData.length > 0) {
            root = rootData[0];
        }
        if (root == null && this._envp != null) {
            root = (String)this._envp.get("CVSROOT");
        }
        if (root != null) {
            return OCVSRoot.parseRootSpec(root);
        }
        throw new OCVSClientException("No CVSROOT specified!");
    }

    protected OCVSConnection createRootConnection(OCVSRoot root, OCVSProcessIO io) throws IOException, OCVSClientException {
        if (root.isAccessFork()) {
            return this.createForkConnection(root);
        }
        if (root.isAccessPServer()) {
            return this.createPServerConnection((OCVSPServerRoot)root);
        }
        if (root.isAccessExt()) {
            return this.createExtConnection(root);
        }
        if (root.isAccessSsh2()) {
            return this.createSsh2Connection((OCVSSsh2Root)root, io);
        }
        throw new IllegalStateException();
    }

    protected void openConnection(OCVSConnection connection, OCVSRoot root) throws IOException, OCVSClientException {
        try {
            connection.open();
        }
        catch (JSchException jsche) {
            throw new OCVSClientException("JSch: " + jsche.getMessage());
        }
        catch (UnknownHostException uhe) {
            throw new OCVSClientException(MessageFormat.format("unknown host {0}", root.getHostName()));
        }
    }

    protected void verifyAbsolutePathArgument(String path) throws OCVSClientException {
        throw new OCVSClientException(MessageFormat.format("cannot accept absolute path argument {0}", path));
    }

    protected void authenticateUserForPServer(OCVSPServerConnection connection, OCVSRoot root, boolean verifyOnly, String password) throws IOException, OCVSException {
        String spw;
        String string = spw = password != null ? password : OCVSScramble.scramble("");
        if (connection.authenticateUser(root, spw, verifyOnly)) {
            return;
        }
        if (password == null) {
            throw new OCVSClientException("used empty password; try \"cvs login\" with a real password");
        }
        throw new OCVSClientException(MessageFormat.format("authorization failed: server {0} rejected access to {1} for user {2}", root.getHostName(), root.getRepository(), root.getUserName()));
    }

    protected OCVSPassFile constructPassFile() {
        String passfile;
        if (this._envp != null && (passfile = (String)this._envp.get("CVS_PASSFILE")) != null) {
            return new OCVSPassFile(new File(passfile));
        }
        return new OCVSPassFile(new File(new File(System.getProperty("user.home")), ".cvspass"));
    }

    protected int indexOfFileArgument(Map options, String[] arguments) throws OCVSClientException {
        return this.indexOfFileArgument(arguments);
    }

    protected int indexOfFileArgument(String[] arguments) throws OCVSClientException {
        return 0;
    }

    protected void processOptions(OCVSSession session, Map options) throws IOException, OCVSClientException {
        if (options.containsKey(OPTION_BE_REALLY_QUIET)) {
            options.put(OPTION_BE_SOMEWHAT_QUIET, null);
        }
    }

    protected String[] processArguments(OCVSSession session, String[] arguments) throws OCVSClientException {
        String[] stringArray;
        if (arguments.length > 0) {
            stringArray = arguments;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        return stringArray;
    }

    protected OCVSResource[] processResources(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
        File dir = session.getWorkingDirectory().getCanonicalFile();
        int i = 0;
        while (i < resources.length) {
            OCVSDirectory directory = null;
            File resourceDirFile = resources[i].getFile().getCanonicalFile();
            if (!dir.getAbsolutePath().equals(resourceDirFile.getAbsolutePath())) {
                directory = resources[i].constructParentDirectory();
            }
            if (directory == null) {
                directory = new OCVSDirectory(dir);
            }
            if (!directory.isManaged()) {
                session.getSessionIO().printError(MessageFormat.format("in directory {0}:", directory.getLocalPath()));
                throw new OCVSClientException("there is no version here; do 'cvs checkout' first");
            }
            ++i;
        }
        return resources;
    }

    protected OCVSFileStateVisitor createResourceVisitor() {
        return new OCVSFileStateVisitor();
    }

    protected void initializeResourceVisitor(OCVSFileStateVisitor visitor, Map options) {
        this.initializeBaseResourceVisitor(visitor, options);
    }

    protected void initializeBaseResourceVisitor(OCVSBaseResourceVisitor visitor, Map options) {
        visitor.setVisitLocalDirectoryOnly(options.containsKey(OPTION_LOCAL_DIRECTORY_ONLY));
    }

    protected OCVSResource[] createResourceStructure(OCVSSession session, Map options, String[] paths) throws IOException, ParseException, OCVSClientException {
        return this.createResourceStructure(session, paths);
    }

    protected OCVSResource[] createResourceStructure(OCVSSession session, String[] paths) throws OCVSClientException {
        File dir = session.getWorkingDirectory();
        OCVSResource[] resources = new OCVSResource[paths.length];
        int i = 0;
        while (i < paths.length) {
            resources[i] = this.createResource(dir, paths[i]);
            ++i;
        }
        return resources;
    }

    protected void sendResourceArguments(OCVSSession session, OCVSResource[] resources) throws IOException, OCVSClientException {
        int i = 0;
        while (resources != null && i < resources.length) {
            session.sendArgument(resources[i].getLocalPath());
            ++i;
        }
    }

    protected void sessionStarted(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
    }

    protected void sessionPrepared(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
    }

    protected void sessionFinished(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
    }

    private void verifyWorkingDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            throw new IllegalArgumentException("could not get working directory");
        }
    }

    private void initializeCompressionLevel(OCVSSession session, Map options) throws OCVSClientException {
        int compressionLevel = this.parseCardinalValue((String)options.get(OPTION_USE_COMPRESSION), Integer.MAX_VALUE);
        if (compressionLevel >= 0 && compressionLevel <= 9) {
            session.setCompressionLevel(compressionLevel);
            return;
        }
        throw new OCVSClientException(MessageFormat.format("gzip compression level must be between {0} and {1}", Integer.toString(0), Integer.toString(9)));
    }

    private OCVSResource createResource(File dir, String path) throws OCVSClientException {
        File file = new File(path);
        if (file.isAbsolute()) {
            this.verifyAbsolutePathArgument(path);
        }
        if (!file.isAbsolute() && dir != null) {
            file = new File(dir, file.getPath());
        }
        String localPath = path.replace(File.separatorChar, '/');
        return OCVSResource.createResource(file, localPath);
    }

    private OCVSConnection createForkConnection(OCVSRoot root) throws IOException {
        OCVSForkConnection connection = new OCVSForkConnection();
        this.initializeServerConnection(connection);
        return connection;
    }

    private OCVSConnection createPServerConnection(OCVSPServerRoot root) throws IOException, OCVSClientException {
        OCVSPServerConnection connection = new OCVSPServerConnection(root.getHostName());
        int maxPort = 65535;
        String clientPortKey = "CVS_CLIENT_PORT";
        int port = -1;
        if (root.getPort() != null) {
            port = this.parseCardinalValue(root.getPort(), maxPort);
        }
        if (root.getPort() == null && this._envp != null && this._envp.containsKey(clientPortKey) && (port = this.parseCardinalValue((String)this._envp.get(clientPortKey), maxPort)) < 0) {
            throw new OCVSClientException(MessageFormat.format("{0} must be a positive number less than {1}!", clientPortKey, String.valueOf(maxPort)));
        }
        if (port >= 0) {
            connection.setPort(port);
        }
        if (root.getProxy() != null) {
            connection.setProxy(root.getProxy());
        }
        if (root.getProxyPort() != null) {
            port = this.parseCardinalValue(root.getProxyPort(), maxPort);
        }
        if (port >= 0) {
            connection.setProxyPort(port);
        }
        return connection;
    }

    private int parseCardinalValue(String s, int max) {
        try {
            int i = Integer.parseInt(s);
            int n = i >= 0 && i <= max ? i : -1;
            return n;
        }
        catch (NumberFormatException nfe) {
            int n = -1;
            return n;
        }
    }

    private OCVSConnection createExtConnection(OCVSRoot root) throws IOException {
        String rsh;
        OCVSExtConnection connection = new OCVSExtConnection(root.getHostName(), root.getUserName());
        this.initializeServerConnection(connection);
        if (this._envp != null && (rsh = (String)this._envp.get("CVS_RSH")) != null) {
            connection.setRemoteShell(rsh);
        }
        return connection;
    }

    private OCVSConnection createSsh2Connection(OCVSSsh2Root root, OCVSProcessIO io) throws IOException {
        OCVSUserInfo userInfo = new OCVSUserInfo(root.getUserName() + '/' + root.getHostName(), io);
        OCVSSsh2Connection connection = new OCVSSsh2Connection(root.getUserName(), root.getHostName(), userInfo);
        this.initializeServerConnection(connection);
        if (root.getKey() != null) {
            connection.setKey(root.getKey());
        } else {
            userInfo.setNoPassphrase(true);
        }
        int maxPort = 65535;
        int port = -1;
        if (root.getProxy() != null) {
            connection.setProxy(root.getProxy());
        }
        if (root.getProxyPort() != null) {
            port = this.parseCardinalValue(root.getProxyPort(), maxPort);
        }
        if (port >= 0) {
            connection.setProxyPort(port);
        }
        return connection;
    }

    private void initializeServerConnection(OCVSConnection connection) {
        String server = null;
        if (this._envp != null) {
            server = (String)this._envp.get("CVS_SERVER");
        }
        if (server == null) {
            return;
        }
        if (connection instanceof OCVSForkConnection) {
            ((OCVSForkConnection)connection).setServer(server);
        }
        if (connection instanceof OCVSSsh2Connection) {
            ((OCVSSsh2Connection)connection).setServer(server);
        }
    }

    private String[] extractFileArguments(String[] arguments, int fileArgumentIndex) {
        String[] fileArguments = new String[arguments.length - fileArgumentIndex];
        System.arraycopy(arguments, fileArgumentIndex, fileArguments, 0, fileArguments.length);
        return fileArguments;
    }

    private void authenticateUser(OCVSConnection connection, OCVSRoot root, boolean verifyOnly) throws IOException, OCVSException {
        if (!root.isAccessPServer()) {
            return;
        }
        String password = this.constructPassFile().getPassword(root.getRootSpec());
        this.authenticateUserForPServer((OCVSPServerConnection)connection, root, verifyOnly, password);
    }

    private void sendGlobalOptions(OCVSSession session, Map options) throws IOException {
        for (OCVSOption option : options.keySet()) {
            if (option.getType() != 1) continue;
            session.sendGlobalOption(option.getOptionId());
        }
    }

    private void sendLocalOptions(OCVSSession session, Map options) throws IOException {
        for (OCVSOption option : options.keySet()) {
            if (option.getType() != 2) continue;
            session.sendArgument(option.getOptionId());
            Object argument = options.get(option);
            if (argument instanceof String) {
                session.sendArgument((String)argument);
                continue;
            }
            if (argument instanceof byte[]) {
                session.sendArgument((byte[])argument);
                continue;
            }
            if (argument == null) continue;
            throw new IllegalStateException();
        }
    }

    private void sendArguments(OCVSSession session, String[] arguments, int fileArgumentIndex) throws IOException, OCVSClientException {
        if (fileArgumentIndex < 0) {
            fileArgumentIndex = arguments.length;
        }
        int i = 0;
        while (i < fileArgumentIndex) {
            session.sendArgument(arguments[i]);
            ++i;
        }
    }

    private void sendResourceState(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSClientException {
        OCVSFileStateVisitor visitor = this.createResourceVisitor();
        this.initializeResourceVisitor(visitor, options);
        visitor.visit(session, resources);
    }

    private void sendWorkingDirectory(OCVSSession session) throws IOException {
        OCVSDirectory directory = new OCVSDirectory(session.getWorkingDirectory());
        String remotePath = directory.constructRemotePath(session.getRoot().getRepository());
        session.sendDirectory("", remotePath);
    }
}

