/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import com.jcraft.jsch.JSchException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.ocvs.OCVSLogInputStream;
import oracle.ocvs.OCVSLogOutputStream;

public abstract class OCVSConnection {
    private static final int TRANSFER_BUFFER_SIZE = (int)Math.pow(2.0, 15.0);
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private PrintWriter _printWriter;

    public void open() throws IOException, JSchException {
        if (this._printWriter != null) {
            throw new IllegalStateException();
        }
        this.openImpl();
    }

    public void close() throws IOException {
        this.closeImpl();
        this._printWriter = null;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new OCVSLogInputStream(this.getInputStreamImpl());
        }
        return this._inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._outputStream == null) {
            this._outputStream = new OCVSLogOutputStream(this.getOutputStreamImpl());
        }
        return this._outputStream;
    }

    public void startLogging() throws IOException {
        ((OCVSLogInputStream)this.getInputStream()).setLogging(true);
        ((OCVSLogOutputStream)this.getOutputStream()).setLogging(true);
    }

    protected abstract void openImpl() throws IOException, JSchException;

    protected abstract void closeImpl() throws IOException;

    protected abstract InputStream getInputStreamImpl() throws IOException;

    protected abstract OutputStream getOutputStreamImpl() throws IOException;

    public String readLine() throws IOException {
        return this.readLine(this.getInputStream());
    }

    public byte[] readLineBytes() throws IOException {
        return this.readLineBytes(this.getInputStream());
    }

    public void pipeInput(OutputStream outputStream, long len) throws IOException {
        OCVSConnection.pipeStream(this.getInputStream(), outputStream, len);
    }

    public void write(String s) throws IOException {
        this.getPrintWriter().print(s);
        if (this.getPrintWriter().checkError()) {
            throw new IOException("write to server failed");
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.getOutputStream().write(bytes);
        this.getOutputStream().flush();
    }

    public void writeLine(String s) throws IOException {
        this.getPrintWriter().print(s + '\n');
        if (this.getPrintWriter().checkError()) {
            throw new IOException("write to server failed");
        }
    }

    public void writeLine() throws IOException {
        this.getPrintWriter().print('\n');
        if (this.getPrintWriter().checkError()) {
            throw new IOException("write to server failed");
        }
    }

    public void pipeOutput(InputStream inputStream, long len) throws IOException {
        OCVSConnection.pipeStream(inputStream, this.getOutputStream(), len);
    }

    protected String readLine(InputStream inputStream) throws IOException {
        byte[] bytes = this.readLineBytes(inputStream);
        return bytes != null ? OCVSConnection.convertBytesToLine(bytes) : null;
    }

    protected byte[] readLineBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = null;
        while (true) {
            int c;
            if ((c = inputStream.read()) == -1 && baos == null) {
                return null;
            }
            if (baos == null) {
                baos = new ByteArrayOutputStream();
            }
            if (c == -1 || c == 10) break;
            baos.write(c);
        }
        return baos.toByteArray();
    }

    private PrintWriter getPrintWriter() throws IOException {
        if (this._printWriter == null) {
            this._printWriter = new PrintWriter(this.getOutputStream());
        }
        return this._printWriter;
    }

    public static final void pipeStream(InputStream in, OutputStream out, long len) throws IOException {
        int n;
        byte[] buffer = new byte[TRANSFER_BUFFER_SIZE];
        while (len > 0L && (n = in.read(buffer, 0, (int)Math.min((long)TRANSFER_BUFFER_SIZE, len))) != -1) {
            out.write(buffer, 0, n);
            out.flush();
            len -= (long)n;
        }
    }

    static final String convertBytesToLine(byte[] bytes) {
        return OCVSConnection.trimCarriageReturns(new String(bytes));
    }

    static final String trimCarriageReturns(String s) {
        int i = s.lastIndexOf(13);
        if (i < s.length() - 1) {
            return s;
        }
        if (i <= 0) {
            return "";
        }
        return OCVSConnection.trimCarriageReturns(s.substring(0, i));
    }
}

