/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import oracle.ocvs.OCVSRuntimeUtil;

public class OCVSFileUtil {
    public static final boolean IS_LF_PLATFORM = System.getProperty("line.separator").equals("\n");
    public static final boolean IS_CRLF_PLATFORM = System.getProperty("line.separator").equals("\r\n");

    private OCVSFileUtil() {
    }

    public static final String[] readFileLines(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            ArrayList<String> c = new ArrayList<String>();
            String line = null;
            while ((line = br.readLine()) != null) {
                c.add(line);
            }
            String[] stringArray = c.toArray(new String[0]);
            return stringArray;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            br.close();
        }
    }

    public static final void writeFileLines(File file, String[] lines) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        try {
            int i = 0;
            while (i < lines.length) {
                bw.write(lines[i]);
                bw.newLine();
                ++i;
            }
        }
        finally {
            bw.close();
        }
    }

    public static final byte[] readFileBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)Math.min(file.length(), Integer.MAX_VALUE)];
        FileInputStream fis = new FileInputStream(file);
        fis.read(bytes);
        fis.close();
        return bytes;
    }

    public static final File createTempFile(String suffix) throws IOException {
        return File.createTempFile("ocvs", suffix);
    }

    public static final boolean isFileSystemCaseSensitive() {
        return new File("A").equals(new File("a")) ^ true;
    }

    public static final File createPlatformEOLFile(File inputFile) throws IOException {
        String line;
        File file = OCVSFileUtil.createTempFile(null);
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        while ((line = br.readLine()) != null) {
            bw.write(line);
            bw.newLine();
        }
        br.close();
        bw.close();
        return file;
    }

    public static final File createServerEOLFile(File inputFile) throws IOException {
        String line;
        File file = OCVSFileUtil.createTempFile(null);
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        while ((line = br.readLine()) != null) {
            bw.write(line);
            bw.write(10);
        }
        br.close();
        bw.close();
        return file;
    }

    public static final boolean renameTo(File sourceFile, File destinationFile) {
        if (sourceFile.renameTo(destinationFile)) {
            return true;
        }
        if (OCVSRuntimeUtil.isWindows()) {
            return false;
        }
        if (destinationFile.exists()) {
            return false;
        }
        try {
            FileChannel sourceChannel = new FileInputStream(sourceFile).getChannel();
            FileChannel destinationChannel = new FileOutputStream(destinationFile).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
            sourceChannel.close();
            destinationChannel.close();
            boolean bl = sourceFile.delete();
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
    }
}

