/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSPServerConnection;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSScramble;

public class OCVSLogin
extends OCVSCommand {
    public OCVSLogin() {
        super(null);
    }

    public String getCommandId() {
        return "login";
    }

    public int executeCommand(OCVSProcessIO io, File dir, Map options, String[] arguments) throws Exception {
        OCVSRoot root = this.constructRoot(dir, options);
        if (!root.isAccessPServer()) {
            throw new OCVSClientException(MessageFormat.format("can only use pserver method with `{0}'' command", this.getCommandId()));
        }
        OCVSPServerConnection connection = (OCVSPServerConnection)this.createRootConnection(root, null);
        io._out.println(MessageFormat.format("(Logging in to {0}@{1})", root.getUserName(), root.getHostName()));
        String password = io.getPrompter().promptPassword(root, "CVS password: ");
        password = OCVSScramble.scramble(password != null ? password : "");
        this.openConnection(connection, root);
        try {
            this.authenticateUserForPServer(connection, root, true, password);
            this.constructPassFile().addPassword(root.getRootSpec(), password);
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            connection.close();
        }
    }
}

