/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.ocvs.OCVSAdd;
import oracle.ocvs.OCVSCheckout;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSCommandOption;
import oracle.ocvs.OCVSCommandSpec;
import oracle.ocvs.OCVSCommit;
import oracle.ocvs.OCVSDiff;
import oracle.ocvs.OCVSImport;
import oracle.ocvs.OCVSKeyGen;
import oracle.ocvs.OCVSLog;
import oracle.ocvs.OCVSLogStream;
import oracle.ocvs.OCVSLogin;
import oracle.ocvs.OCVSLogout;
import oracle.ocvs.OCVSLs;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPatch;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSRLog;
import oracle.ocvs.OCVSRTag;
import oracle.ocvs.OCVSRelease;
import oracle.ocvs.OCVSRemove;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRuntimeUtil;
import oracle.ocvs.OCVSStatus;
import oracle.ocvs.OCVSTag;
import oracle.ocvs.OCVSUpdate;
import oracle.ocvs.OCVSUsageException;

public final class OCVSMain {
    private static final boolean DEBUG = false;
    public static final String GLOBAL_OPTION_SPEC = "Hz.d.QqwnEC.";
    private static Collection _commandSpecs = new ArrayList();

    private OCVSMain() {
    }

    public static final void main(String[] argv) {
        int exitCode;
        block20: {
            if (argv.length <= 0) {
                OCVSMain.printUsage();
                System.exit(1);
            }
            if (argv.length >= 1 && argv[0].startsWith("--help-c")) {
                OCVSMain.printCommands();
                System.exit(0);
            }
            if (argv.length >= 1 && argv[0].startsWith("--help-s")) {
                OCVSMain.printSyntax();
                System.exit(0);
            }
            if (argv.length >= 1 && argv[0].startsWith("--help")) {
                argv[0] = "-H";
            }
            if (argv.length >= 1 && (argv[0].startsWith("-v") || argv[0].startsWith("--v"))) {
                OCVSMain.printVersion();
                System.exit(0);
            }
            File dir = new File(System.getProperty("user.dir"));
            Map envpMap = OCVSRuntimeUtil.getEnvironmentVariableMap();
            String clientLog = (String)envpMap.get("CVS_CLIENT_LOG");
            File clientLogFile = clientLog != null ? new File(dir, clientLog + ".in") : null;
            File serverLogFile = clientLog != null ? new File(dir, clientLog + ".out") : null;
            try {
                if (clientLogFile != null && !clientLogFile.isDirectory()) {
                    OCVSLogStream._clientStream = new FileOutputStream(clientLogFile);
                }
                if (serverLogFile != null && !serverLogFile.isDirectory()) {
                    OCVSLogStream._serverStream = new FileOutputStream(serverLogFile);
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                System.exit(1);
            }
            exitCode = -1;
            try {
                try {
                    exitCode = OCVSMain.exec(new OCVSProcessIO(System.in, System.out, System.err), dir, OCVSMain.convertMapToEnvp(envpMap), null, argv);
                }
                catch (OCVSUsageException ue) {
                    if (ue.getMessage() != null) {
                        System.err.println(ue.getMessage());
                        System.err.println();
                    }
                    if (ue.getCommandSpec() == null) {
                        OCVSMain.printUsage();
                        break block20;
                    }
                    OCVSMain.printSyntax(ue.getCommandSpec());
                }
            }
            finally {
                if (OCVSLogStream._clientStream != null) {
                    OCVSMain.tryCloseOutputStream(OCVSLogStream._clientStream);
                }
                if (OCVSLogStream._serverStream != null) {
                    OCVSMain.tryCloseOutputStream(OCVSLogStream._serverStream);
                }
                if (clientLogFile != null && clientLogFile.length() <= 0L) {
                    clientLogFile.delete();
                }
                if (serverLogFile != null && serverLogFile.length() <= 0L) {
                    serverLogFile.delete();
                }
            }
        }
        System.exit(exitCode);
    }

    private static final void printUsage() {
        System.err.println("Usage: ocvs [cvs-options] command [command-options-and-arguments]");
        System.err.println("  specify --help-commands for a list of commands");
        System.err.println("  specify --help-syntax for command syntax, including options");
        System.err.println();
        System.err.println("The Concurrent Versions System (CVS) is a tool for version control.");
    }

    private static final void printSyntax() {
        ArrayList<String> usageLines = new ArrayList<String>();
        Iterator itr = _commandSpecs.iterator();
        while (itr.hasNext()) {
            usageLines.add(OCVSMain.createUsageLine((OCVSCommandSpec)itr.next()));
        }
        Collections.sort(usageLines);
        Iterator itr2 = usageLines.iterator();
        while (itr2.hasNext()) {
            System.err.println((String)itr2.next());
        }
    }

    private static final void printSyntax(OCVSCommandSpec commandSpec) {
        System.err.println(OCVSMain.createUsageLine(commandSpec));
    }

    private static final void printCommands() {
        System.err.println("CVS commands are:");
        System.err.println("        add          Add a new file/directory to the repository");
        System.err.println("        checkout     Checkout sources for editing");
        System.err.println("        commit       Check files into the repository");
        System.err.println("        diff         Show differences between revisions");
        System.err.println("        import       Import sources into CVS, using vendor branches");
        System.err.println("        keygen       Generate public & private key pair for SSH2");
        System.err.println("        log          Print out history information for files");
        System.err.println("        login        Prompt for password for authenticating server");
        System.err.println("        logout       Removes entry in .cvspass for remote repository");
        System.err.println("        ls           List files in the repository");
        System.err.println("        rdiff        Create 'patch' format diffs between releases");
        System.err.println("        release      Indicate that a Module is no longer in use");
        System.err.println("        remove       Remove an entry from the repository");
        System.err.println("        rlog         Print out history information for a module");
        System.err.println("        rtag         Add a symbolic tag to a module");
        System.err.println("        status       Display status information on checked out files");
        System.err.println("        tag          Add a symbolic tag to checked out version of files");
        System.err.println("        update       Bring work tree in sync with repository");
    }

    private static final void printVersion() {
        System.out.println();
        System.out.println("Concurrent Versions System (OCVS) 1.10.1 (client)");
        System.out.println();
        System.out.println("Copyright (c) 2004 Oracle. All Rights Reserved.");
        System.out.println();
        System.out.println("SSH2 connectivity provided by JSch (Java Secure Channel):");
        System.out.println("  JSch is Copyright (c) 2002-2004 ymnk, JCraft,Inc");
        System.out.println("  See http://www.jcraft.com/jsch/");
    }

    private static final String createUsageLine(OCVSCommandSpec commandSpec) {
        StringBuffer usageLineBuffer = new StringBuffer();
        usageLineBuffer.append("Usage: ocvs ");
        usageLineBuffer.append("[-");
        usageLineBuffer.append(OCVSMain.createReadableOptions(GLOBAL_OPTION_SPEC));
        usageLineBuffer.append("] ");
        usageLineBuffer.append(commandSpec.getTokenSpec());
        String optionSpec = commandSpec.getOptionSpec();
        if (optionSpec != null && !optionSpec.equals("")) {
            usageLineBuffer.append(" [-");
            usageLineBuffer.append(OCVSMain.createReadableOptions(optionSpec));
            usageLineBuffer.append(']');
        }
        if (commandSpec.getUseArguments()) {
            usageLineBuffer.append(" arguments");
        }
        return usageLineBuffer.toString();
    }

    private static final String createReadableOptions(String optionSpec) {
        1 comparator = new 1();
        String s = optionSpec.replaceAll("[^\\w]", "");
        ArrayList<Character> l = new ArrayList<Character>();
        int i = 0;
        while (i < s.length()) {
            l.add(new Character(s.charAt(i)));
            ++i;
        }
        Collections.sort(l, comparator);
        int i2 = 0;
        while (i2 < l.size()) {
            char c;
            Character optionChar = (Character)l.get(i2);
            int j = optionSpec.indexOf(optionChar.charValue());
            int k = j + 1;
            if (k < optionSpec.length() && !Character.isLetter(c = optionSpec.charAt(k))) {
                l.add(++i2, new Character(c));
            }
            ++i2;
        }
        StringBuffer optionSpecBuffer = new StringBuffer();
        Iterator itr = l.iterator();
        while (itr.hasNext()) {
            optionSpecBuffer.append(((Character)itr.next()).charValue());
        }
        return optionSpecBuffer.toString();
    }

    private static final void tryCloseOutputStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        _commandSpecs.add(new OCVSCommandSpec("add|ad|new", OCVSAdd.class, "k."));
        _commandSpecs.add(new 2("checkout|co|get", OCVSCheckout.class, "lRr.D.k.nfPcsd.N"));
        _commandSpecs.add(new 3("commit|ci|com", OCVSCommit.class, "lRm.r.F.nf"));
        _commandSpecs.add(new 4("diff|di|dif", OCVSDiff.class, "lRr.D.k.Ncuw"));
        _commandSpecs.add(new 5("import|im|imp", OCVSImport.class, "m.I.W.b.F."));
        _commandSpecs.add(new OCVSCommandSpec("keygen", OCVSKeyGen.class, ""));
        _commandSpecs.add(new 6("log|lo", OCVSLog.class, "lRh"));
        _commandSpecs.add(new OCVSCommandSpec("login|logon|lgn", OCVSLogin.class, "", false));
        _commandSpecs.add(new OCVSCommandSpec("logout", OCVSLogout.class, "", false));
        _commandSpecs.add(new 7("ls|list|dir", OCVSLs.class, "eR"));
        _commandSpecs.add(new 8("rdiff|patch|pa", OCVSPatch.class, "lRr.D.fcus"));
        _commandSpecs.add(new 9("release|re|rel", OCVSRelease.class, "d"));
        _commandSpecs.add(new OCVSCommandSpec("remove|rm|delete", OCVSRemove.class, "lR"));
        _commandSpecs.add(new 10("rlog|rl", OCVSRLog.class, "lRh"));
        _commandSpecs.add(new 11("rtag|rt|rfreeze", OCVSRTag.class, "lRdr.D.fb"));
        _commandSpecs.add(new 12("status|st|stat", OCVSStatus.class, "lRv"));
        _commandSpecs.add(new 13("tag|ta|freeze", OCVSTag.class, "lRdr.D.fb"));
        _commandSpecs.add(new 14("update|up|upd", OCVSUpdate.class, "lRdr.D.k.AfPpCj."));
    }

    public static final String[] convertMapToEnvp(Map envpMap) {
        ArrayList<String> c = new ArrayList<String>();
        for (Object key : envpMap.keySet()) {
            Object value = envpMap.get(key);
            if (value == null) continue;
            StringBuffer envpBuffer = new StringBuffer();
            envpBuffer.append(key.toString());
            envpBuffer.append('=');
            envpBuffer.append(value.toString());
            c.add(envpBuffer.toString());
        }
        return c.toArray(new String[0]);
    }

    public static final Map convertEnvpToMap(String[] envp) {
        if (envp == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> envpMap = new HashMap<String, String>();
        int i = 0;
        while (i < envp.length) {
            int j = envp[i].indexOf(61);
            if (j > 0 && j < envp[i].length() - 1) {
                String key = envp[i].substring(0, j);
                String value = envp[i].substring(j + 1);
                envpMap.put(key, value);
            }
            ++i;
        }
        return envpMap;
    }

    public static final OCVSCommandSpec[] getRegisteredCommandSpecs() {
        return _commandSpecs.toArray(new OCVSCommandSpec[0]);
    }

    public static final int exec(OCVSProcessIO io, File dir, String[] envp, OCVSResponseRegistry responseRegistry, String[] cmdArray) {
        char c;
        Map envpMap = OCVSMain.convertEnvpToMap(envp);
        char[] cmdString = OCVSMain.createCommandString(cmdArray);
        int i = 0;
        ArrayList cmdOptions = new ArrayList();
        if ((i = OCVSMain.scanCommandOptions(i, cmdString, cmdOptions, GLOBAL_OPTION_SPEC)) >= cmdString.length) {
            throw new OCVSUsageException();
        }
        LinkedHashMap<OCVSOption, String> options = new LinkedHashMap<OCVSOption, String>();
        boolean helpOptionSet = false;
        for (OCVSCommandOption cmdOption : cmdOptions) {
            if (cmdOption.getId() == 'H') {
                helpOptionSet = true;
            }
            if (cmdOption.getId() == 'z') {
                options.put(OCVSCommand.OPTION_USE_COMPRESSION, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'd') {
                options.put(OCVSCommand.OPTION_OVERRIDE_CVSROOT, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'Q') {
                options.put(OCVSCommand.OPTION_BE_REALLY_QUIET, null);
            }
            if (cmdOption.getId() == 'q') {
                options.put(OCVSCommand.OPTION_BE_SOMEWHAT_QUIET, null);
            }
            if (cmdOption.getId() == 'w') {
                // empty if block
            }
            if (cmdOption.getId() == 'n') {
                options.put(OCVSCommand.OPTION_DO_NOT_EXEC_DISK, null);
            }
            if (cmdOption.getId() == 'E') {
                options.put(OCVSCommand.OPTION_DO_NOT_CONVERT_EOLS, null);
            }
            if (cmdOption.getId() != 'C') continue;
            options.put(OCVSCommand.OPTION_USE_OUTPUT_ENCODING, cmdOption.getArgument());
        }
        cmdOptions.clear();
        StringBuffer commandBuffer = new StringBuffer();
        while ((c = cmdString[i++]) != '\n') {
            commandBuffer.append(c);
        }
        String command = commandBuffer.toString();
        OCVSCommandSpec commandSpec = null;
        for (OCVSCommandSpec currentCommandSpec : _commandSpecs) {
            if (!Pattern.matches(currentCommandSpec.getTokenSpec(), command)) continue;
            commandSpec = currentCommandSpec;
            break;
        }
        if (commandSpec == null) {
            throw new OCVSUsageException(MessageFormat.format("Unknown command: `{0}''", command));
        }
        try {
            if (helpOptionSet) {
                throw new OCVSUsageException();
            }
            i = OCVSMain.scanCommandOptions(i, cmdString, cmdOptions, commandSpec.getOptionSpec());
        }
        catch (OCVSUsageException ue) {
            ue.setCommandSpec(commandSpec);
            throw ue;
        }
        String[] arguments = commandSpec.getUseArguments() ? OCVSMain.scanCommandArguments(i, cmdString) : null;
        commandSpec.populateOptions(options, cmdOptions);
        try {
            OCVSCommand commandObject = (OCVSCommand)commandSpec.getCommandClass().newInstance();
            commandObject.setEnvironmentParams(envpMap);
            if (responseRegistry != null) {
                commandObject.setResponseRegistry(responseRegistry);
            }
            int n = OCVSMain.doCommand(commandObject, io, dir, options, arguments);
            return n;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        return -1;
    }

    private static final char[] createCommandString(String[] cmdArray) {
        int n = 0;
        int i = 0;
        while (i < cmdArray.length) {
            n += cmdArray[i].length() + 1;
            ++i;
        }
        char[] cmdString = new char[n];
        int i2 = 0;
        int j = 0;
        while (i2 < cmdArray.length) {
            int k = 0;
            while (k < cmdArray[i2].length()) {
                cmdString[j++] = cmdArray[i2].charAt(k);
                ++k;
            }
            cmdString[j++] = 10;
            ++i2;
        }
        return cmdString;
    }

    private static final int scanCommandOptions(int i, char[] cmdString, Collection cmdOptions, String optionSpec) {
        while (i < cmdString.length && cmdString[i] == '-') {
            i = OCVSMain.scanCommandOption(i, cmdString, cmdOptions, optionSpec);
        }
        return i;
    }

    private static final int scanCommandOption(int i, char[] cmdString, Collection cmdOptions, String optionSpec) {
        if (cmdString[i + 1] == '\n') {
            throw new OCVSUsageException();
        }
        char optionId = cmdString[++i];
        OCVSCommandOption cmdOption = new OCVSCommandOption(optionId, OCVSMain.countCommandOptionOccurrences(cmdOptions, optionId) + 1);
        ++i;
        int j = optionSpec.indexOf(cmdOption.getId());
        cmdOptions.add(cmdOption);
        if (j < 0) {
            throw new OCVSUsageException(MessageFormat.format("invalid option -- {0}", String.valueOf(cmdOption.getId())));
        }
        if (++j < optionSpec.length() && optionSpec.charAt(j) == '<' && cmdString[i] != '\n') {
            i = OCVSMain.scanCommandOptionArgument(i, cmdString, cmdOption);
        }
        if (j < optionSpec.length() && optionSpec.charAt(j) == '.') {
            if (cmdString[i] == '\n') {
                ++i;
            }
            if (i >= cmdString.length) {
                throw new OCVSUsageException(MessageFormat.format("option `{0}'' requires an argument", String.valueOf(cmdOption.getId())));
            }
            i = OCVSMain.scanCommandOptionArgument(i, cmdString, cmdOption);
        }
        if (cmdString[i] == '\n') {
            return ++i;
        }
        return OCVSMain.scanCommandOption(--i, cmdString, cmdOptions, optionSpec);
    }

    private static final int scanCommandOptionArgument(int i, char[] cmdString, OCVSCommandOption cmdOption) {
        char c;
        StringBuffer optionBuffer = new StringBuffer();
        while ((c = cmdString[i]) != '\n') {
            optionBuffer.append(c);
            ++i;
        }
        cmdOption.setArgument(optionBuffer.toString());
        return i;
    }

    private static final String[] scanCommandArguments(int i, char[] cmdString) {
        ArrayList<String> arguments = new ArrayList<String>();
        while (i < cmdString.length) {
            char c;
            StringBuffer argumentBuffer = new StringBuffer();
            while ((c = cmdString[i++]) != '\n') {
                argumentBuffer.append(c);
            }
            arguments.add(argumentBuffer.toString());
        }
        return arguments.toArray(new String[0]);
    }

    private static final int countCommandOptionOccurrences(Collection cmdOptions, char optionId) {
        int occurrences = 0;
        Iterator itr = cmdOptions.iterator();
        while (itr.hasNext()) {
            if (((OCVSCommandOption)itr.next()).getId() != optionId) continue;
            ++occurrences;
        }
        return occurrences;
    }

    private static final int doCommand(OCVSCommand command, OCVSProcessIO io, File dir, LinkedHashMap options, String[] arguments) {
        try {
            int n = command.executeCommand(io, dir, options, arguments);
            return n;
        }
        catch (InterruptedException ie) {
            if (!io.isCancelled()) {
                OCVSMain.printError(io, command, ie.getMessage());
            }
        }
        catch (InterruptedIOException iioe) {
            if (!io.isCancelled()) {
                OCVSMain.printError(io, command, iioe.getMessage());
            }
        }
        catch (IOException ioe) {
            OCVSMain.printError(io, command, ioe.toString());
        }
        catch (RuntimeException re) {
            OCVSMain.printError(io, command, "<fatal exception>");
            re.printStackTrace();
        }
        catch (Exception e) {
            OCVSMain.printError(io, command, e.getMessage());
        }
        return 1;
    }

    private static final void printError(OCVSProcessIO io, OCVSCommand command, String message) {
        io._err.println(MessageFormat.format("cvs [{0} aborted]: {1}", command.getCommandId(), message));
    }

    static final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Character c1 = (Character)o1;
            Character c2 = (Character)o2;
            int result = String.valueOf(c1).toUpperCase().compareTo(String.valueOf(c2).toUpperCase());
            return result != 0 ? result : c1.compareTo(c2);
        }
    }

    static final class 2
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'P') {
                options.put(OCVSCheckout.OPTION_PRUNE_EMPTY_DIRECTORIES, null);
            }
            if (cmdOption.getId() == 'c') {
                options.put(OCVSCheckout.OPTION_CAT_MODULE_DATABASE, null);
            }
            if (cmdOption.getId() == 's') {
                options.put(OCVSCheckout.OPTION_CAT_MODULE_DATABASE_WITH_STATUS, null);
            }
            if (cmdOption.getId() == 'd') {
                options.put(OCVSCheckout.OPTION_CHECK_OUT_INTO_DIR, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'N') {
                options.put(OCVSCheckout.OPTION_DO_NOT_SHORTEN_PATHNAMES, null);
            }
        }

        public 2(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 3
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'm') {
                options.put(OCVSCommit.OPTION_LOG_MESSAGE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'F') {
                options.put(OCVSCommit.OPTION_READ_MESSAGE_FROM_FILE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'f') {
                options.put(OCVSCommit.OPTION_FORCE_COMMIT, null);
            }
        }

        public 3(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 4
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'r' && cmdOption.getOccurrence() == 2) {
                options.put(OCVSDiff.OPTION_USE_SECOND_FILE_REVISION, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'D' && cmdOption.getOccurrence() == 2) {
                options.put(OCVSDiff.OPTION_USE_SECOND_DATE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'N') {
                options.put(OCVSDiff.OPTION_INCLUDE_DIFFS_FOR_ADDED_AND_REMOVED, null);
            }
            if (cmdOption.getId() == 'c') {
                options.put(OCVSDiff.OPTION_CONTEXT_DIFFS, null);
            }
            if (cmdOption.getId() == 'u') {
                options.put(OCVSDiff.OPTION_UNIDIFF_FORMAT, null);
            }
            if (cmdOption.getId() == 'w') {
                options.put(OCVSDiff.OPTION_IGNORE_WHITESPACE, null);
            }
        }

        public 4(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 5
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'm') {
                options.put(OCVSImport.OPTION_LOG_MESSAGE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'I') {
                options.put(OCVSImport.OPTION_MORE_FILES_TO_IGNORE.clone(), cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'W') {
                options.put(OCVSImport.OPTION_WRAPPERS_SPECIFICATION_LINE.clone(), cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'b') {
                options.put(OCVSImport.OPTION_VENDOR_BRANCH_ID, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'F') {
                options.put(OCVSImport.OPTION_READ_MESSAGE_FROM_FILE, cmdOption.getArgument());
            }
        }

        public 5(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 6
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'h') {
                options.put(OCVSLog.OPTION_ONLY_PRINT_HEADER, null);
            }
        }

        public 6(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 7
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'e') {
                options.put(OCVSLs.OPTION_DISPLAY_IN_CVS_ENTRIES_FORMAT, null);
            }
            if (cmdOption.getId() == 'R') {
                options.put(OCVSLs.OPTION_LIST_RECURSIVELY, null);
            }
        }

        public 7(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 8
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'r' && cmdOption.getOccurrence() == 2) {
                options.put(OCVSPatch.OPTION_USE_SECOND_FILE_REVISION, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'D' && cmdOption.getOccurrence() == 2) {
                options.put(OCVSPatch.OPTION_USE_SECOND_DATE, cmdOption.getArgument());
            }
            if (cmdOption.getId() == 'c') {
                options.put(OCVSPatch.OPTION_CONTEXT_DIFFS, null);
            }
            if (cmdOption.getId() == 'u') {
                options.put(OCVSPatch.OPTION_UNIDIFF_FORMAT, null);
            }
            if (cmdOption.getId() == 's') {
                options.put(OCVSPatch.OPTION_SHORT_PATCH, null);
            }
        }

        public 8(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 9
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'd') {
                options.put(OCVSRelease.OPTION_DELETE_THE_GIVEN_DIRECTORY, null);
            }
        }

        public 9(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 10
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'h') {
                options.put(OCVSRLog.OPTION_ONLY_PRINT_HEADER, null);
            }
        }

        public 10(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 11
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'd') {
                options.put(OCVSRTag.OPTION_DELETE_THE_GIVEN_TAG, null);
            }
            if (cmdOption.getId() == 'b') {
                options.put(OCVSRTag.OPTION_MAKE_BRANCH_TAG, null);
            }
        }

        public 11(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 12
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'v') {
                options.put(OCVSStatus.OPTION_VERBOSE_FORMAT, null);
            }
        }

        public 12(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 13
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'd') {
                options.put(OCVSTag.OPTION_DELETE_THE_GIVEN_TAG, null);
            }
            if (cmdOption.getId() == 'b') {
                options.put(OCVSTag.OPTION_MAKE_BRANCH_TAG, null);
            }
        }

        public 13(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }

    static final class 14
    extends OCVSCommandSpec {
        protected void populateOption(Map options, OCVSCommandOption cmdOption) {
            if (cmdOption.getId() == 'd') {
                options.put(OCVSUpdate.OPTION_CREATE_AND_UPDATE_NEW_DIRS, null);
            }
            if (cmdOption.getId() == 'A') {
                options.put(OCVSUpdate.OPTION_RESET_STICKY_OPTIONS, null);
            }
            if (cmdOption.getId() == 'P') {
                options.put(OCVSUpdate.OPTION_PRUNE_EMPTY_DIRECTORIES, null);
            }
            if (cmdOption.getId() == 'p') {
                options.put(OCVSUpdate.OPTION_SEND_UPDATES_TO_STANDARD_OUTPUT, null);
            }
            if (cmdOption.getId() == 'C') {
                options.put(OCVSUpdate.OPTION_OVERWRITE_FILES_WITH_CLEAN_COPIES, null);
            }
            if (cmdOption.getId() == 'j') {
                options.put(OCVSUpdate.OPTION_MERGE_CHANGES_FROM_REVISION, cmdOption.getArgument());
            }
        }

        public 14(String string, Class clazz, String string2) {
            super(string, clazz, string2);
        }
    }
}

