/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.ocvs.OCVSFileUtil;

public class OCVSPassFile {
    private final File _passFile;

    public OCVSPassFile(File passFile) {
        this._passFile = passFile;
    }

    public void addPassword(String root, String password) throws IOException {
        RandomAccessFile pass = new RandomAccessFile(this._passFile, "rw");
        if (this.findPassword(root, pass) == null) {
            pass.seek(pass.length());
            pass.writeBytes(root + ' ' + password + '\n');
        }
        pass.close();
    }

    public void removePassword(String root) throws IOException {
        if (!this._passFile.exists()) {
            return;
        }
        String[] lines = OCVSFileUtil.readFileLines(this._passFile);
        BufferedWriter bw = new BufferedWriter(new FileWriter(this._passFile));
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].startsWith(root + ' ')) {
                bw.write(lines[i]);
                bw.newLine();
            }
            ++i;
        }
        bw.close();
        if (this._passFile.length() <= 0L) {
            this._passFile.delete();
        }
    }

    public String getPassword(String root) throws IOException {
        if (!this._passFile.exists()) {
            return null;
        }
        RandomAccessFile pass = new RandomAccessFile(this._passFile, "r");
        String password = this.findPassword(root, pass);
        pass.close();
        return password;
    }

    private String findPassword(String root, RandomAccessFile pass) throws IOException {
        String s;
        do {
            if ((s = pass.readLine()) != null) continue;
            return null;
        } while (!s.startsWith(root + ' '));
        int n = root.length() + 1;
        return s.length() <= n ? "" : s.substring(n);
    }
}

