/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;

public class OCVSPathName {
    public static final char SERVER_SEPARATOR = '/';
    public static final String DOT = ".";
    private final String _localDir;
    private final String _repositoryName;

    public OCVSPathName(String localDir, String repositoryName) {
        this._localDir = localDir;
        this._repositoryName = repositoryName;
    }

    public String getLocalDirectory() {
        return this._localDir;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public File constructFile(File dir) {
        if (this.isDirectory()) {
            return this.constructLocalDirectoryFile(dir);
        }
        return new File(this.constructLocalDirectoryFile(dir), this.extractFileName());
    }

    public OCVSPathName constructParentPathName(String rootPath) {
        String repositoryName = OCVSPathName.extractServerPathParent(this._repositoryName);
        if (repositoryName == null || repositoryName.equals(rootPath)) {
            return null;
        }
        repositoryName = repositoryName + '/';
        String localDir = this._localDir;
        if (this.isDirectory()) {
            if ((localDir = OCVSPathName.extractServerPathParent(localDir)) == null) {
                return null;
            }
            localDir = localDir + '/';
        }
        return new OCVSPathName(localDir, repositoryName);
    }

    public String extractRemotePath(String rootPath) {
        if (!rootPath.endsWith(String.valueOf('/'))) {
            rootPath = rootPath + '/';
        }
        if (!this._repositoryName.startsWith(rootPath)) {
            return null;
        }
        if (this._repositoryName.length() <= rootPath.length()) {
            return null;
        }
        return OCVSPathName.trimServerSeparators(this._repositoryName.substring(rootPath.length()));
    }

    public String extractFileName() {
        return OCVSPathName.extractServerPathFileName(this._repositoryName);
    }

    public boolean isDirectory() {
        return this._repositoryName.endsWith(String.valueOf('/'));
    }

    private File constructLocalDirectoryFile(File dir) {
        File localDirFile = new File(this._localDir.replace('/', File.separatorChar));
        return localDirFile.isAbsolute() ? localDirFile : new File(dir, localDirFile.getPath());
    }

    public static final String extractServerPathParent(String path) {
        int i = path.lastIndexOf(47);
        if (i <= 0) {
            return null;
        }
        if (i < path.length() - 1) {
            return path.substring(0, i);
        }
        return OCVSPathName.extractServerPathParent(path.substring(0, i));
    }

    public static final String extractServerPathFileName(String path) {
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        if (i < path.length() - 1) {
            return path.substring(i + 1);
        }
        if (i <= 0) {
            return "";
        }
        return OCVSPathName.extractServerPathFileName(path.substring(0, i));
    }

    public static final String trimServerSeparators(String path) {
        int i = path.lastIndexOf(47);
        if (i < path.length() - 1) {
            return path;
        }
        if (i <= 0) {
            return "";
        }
        return OCVSPathName.trimServerSeparators(path.substring(0, i));
    }
}

