/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import oracle.ocvs.OCVSBaseResourceVisitor;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSSession;

public class OCVSPruneDirectoriesVisitor
extends OCVSBaseResourceVisitor {
    public void visitDirectory(OCVSSession session, OCVSDirectory directory) throws IOException, ParseException, OCVSClientException {
        super.visitDirectory(session, directory);
        if (!directory.isManaged()) {
            return;
        }
        String repositoryPath = directory.readRepository();
        if (repositoryPath == null || repositoryPath.indexOf(47) < 0) {
            return;
        }
        File[] contentsFiles = directory.getFile().listFiles();
        if (contentsFiles.length > 1) {
            return;
        }
        if (contentsFiles.length == 1 && contentsFiles[0].getName().equals("CVS")) {
            this.deleteRecursively(contentsFiles);
        }
        directory.getFile().delete();
    }

    private void deleteRecursively(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.deleteRecursively(files[i]);
            ++i;
        }
    }

    private void deleteRecursively(File file) {
        if (file.isDirectory()) {
            this.deleteRecursively(file.listFiles());
        }
        file.delete();
    }
}

