/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSServerException;
import oracle.ocvs.OCVSSession;

public class OCVSRequest {
    static final String RESPONSE_LIST = "ok error M E";
    private final String _id;

    public OCVSRequest(String id) {
        this._id = id;
    }

    public String getRequestId() {
        return this._id;
    }

    public void executeRequest(OCVSSession session) throws ParseException, IOException, OCVSException {
        session.sendRequest(this._id);
        while (true) {
            String response;
            byte[] responseLineBytes;
            if ((responseLineBytes = session.receiveLineBytes()) == null) {
                throw new OCVSClientException("end of file from server (consult above messages if any)");
            }
            String argument = "";
            if (responseLineBytes.length >= 2 && responseLineBytes[0] == 77 && responseLineBytes[1] == 32 && session.getEncoding() != null) {
                byte[] responseLineBytes0 = new byte[responseLineBytes.length - 2];
                System.arraycopy(responseLineBytes, 2, responseLineBytes0, 0, responseLineBytes0.length);
                response = String.valueOf((char)responseLineBytes[0]);
                argument = new String(responseLineBytes0, session.getEncoding());
                argument = OCVSConnection.trimCarriageReturns(argument);
            } else {
                response = OCVSConnection.convertBytesToLine(responseLineBytes);
                int i = response.indexOf(32);
                if (i >= 0) {
                    argument = response.substring(i + 1);
                    response = response.substring(0, i);
                }
            }
            if (response.equals("ok")) {
                return;
            }
            if (response.equals("error")) {
                throw OCVSRequest.createErrorResponseException(argument);
            }
            if (response.equals("M")) {
                session.getSessionIO().getProcessIO()._out.println(argument);
                continue;
            }
            if (response.equals("E")) {
                session.getSessionIO().getProcessIO()._err.println(argument);
                continue;
            }
            OCVSResponseHandler handler = session.getResponseRegistry().lookupResponseHandler(response);
            if (handler != null && handler.isNoExecDisk(session)) continue;
            if (handler != null) {
                handler.handleResponse(session, argument);
                continue;
            }
            session.getSessionIO().printError(MessageFormat.format("warning: unrecognized response `{0}'' from cvs server", OCVSConnection.convertBytesToLine(responseLineBytes)));
        }
    }

    static final OCVSServerException createErrorResponseException(String argument) {
        String errNoCode = "";
        String errorText = "";
        int i = argument.indexOf(32);
        if (i > 0) {
            errNoCode = argument.substring(0, i);
        }
        if (i >= 0 && i < argument.length() - 1) {
            errorText = argument.substring(i + 1);
        }
        StringBuffer messageBuffer = new StringBuffer("exiting, server error");
        if (!errNoCode.equals("") || !errorText.equals("")) {
            messageBuffer.append(':');
        }
        if (!errNoCode.equals("")) {
            messageBuffer.append(' ');
            messageBuffer.append('[');
            messageBuffer.append(errNoCode);
            messageBuffer.append(']');
        }
        if (!errorText.equals("")) {
            messageBuffer.append(' ');
            messageBuffer.append(errorText);
        }
        return new OCVSServerException(messageBuffer.toString());
    }
}

