/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import oracle.ocvs.OCVSClientException;
import oracle.ocvs.OCVSDirectory;
import oracle.ocvs.OCVSEntry;
import oracle.ocvs.OCVSFile;
import oracle.ocvs.OCVSFileNameConstants;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSSession;

public abstract class OCVSResponseHandler {
    public abstract String getResponseId();

    public abstract void handleResponse(OCVSSession var1, String var2) throws IOException, ParseException, OCVSClientException;

    protected boolean isNoExecDisk(OCVSSession session) {
        return session.isNoExecDisk();
    }

    protected OCVSPathName receivePathName(OCVSSession session, String localDir) throws IOException {
        return new OCVSPathName(localDir, session.receiveLine());
    }

    protected void createDirectoryStructure(OCVSSession session, OCVSPathName pathName) throws IOException, ParseException, OCVSClientException {
        String repositoryPath;
        if (pathName == null) {
            return;
        }
        OCVSDirectory directory = new OCVSDirectory(session.getWorkingDirectory());
        String rootPath = directory.constructRemotePath(session.getRoot().getRepository());
        if (!pathName.isDirectory()) {
            pathName = pathName.constructParentPathName(rootPath);
        }
        if (pathName == null) {
            return;
        }
        File currentDirFile = pathName.constructFile(session.getWorkingDirectory());
        if (!currentDirFile.exists() && !currentDirFile.mkdirs()) {
            this.throwMakeDirectoryException(currentDirFile.getPath());
        }
        this.createDirectoryStructure(session, pathName.constructParentPathName(rootPath));
        if (OCVSDirectory.isManaged(currentDirFile)) {
            return;
        }
        File adminDirFile = new File(currentDirFile, "CVS");
        if (!adminDirFile.mkdir()) {
            this.throwMakeDirectoryException(adminDirFile.getPath());
        }
        if ((repositoryPath = pathName.extractRemotePath(rootPath)) == null) {
            repositoryPath = ".";
        }
        this.createAdministrativeFiles(currentDirFile, this.createRepositoryPath(directory, repositoryPath), session.getRoot().getRootSpec());
        this.writeEntry(currentDirFile, new OCVSEntry("", 1, currentDirFile.getName()));
    }

    protected void updateEntry(File dataFile, String newEntriesLine) throws IOException, ParseException {
        OCVSFile file = new OCVSFile(dataFile);
        this.writeEntry(dataFile, newEntriesLine != null ? this.createEntry(file, OCVSEntry.parseEntrySpec(newEntriesLine)) : null);
    }

    protected OCVSEntry createEntry(OCVSFile file, OCVSEntry entry) {
        OCVSEntry clientEntry = new OCVSEntry(entry);
        String version = entry.getVersion();
        if (version.equals("") || version.startsWith("0") || version.startsWith("-")) {
            clientEntry.setTimestamp("dummy timestamp");
        } else {
            clientEntry.setTimestamp(file.createTimestamp());
        }
        return clientEntry;
    }

    protected void writeEntry(File dataFile, OCVSEntry newEntry) throws IOException, ParseException {
        File entriesFile = new File(dataFile.getParentFile(), OCVSFileNameConstants.CVSADM_ENT);
        if (!entriesFile.getParentFile().exists()) {
            return;
        }
        String[] entriesData = OCVSFileUtil.readFileLines(entriesFile);
        ArrayList<String> newEntries = new ArrayList<String>();
        int i = 0;
        while (entriesData != null && i < entriesData.length) {
            OCVSEntry entry = OCVSEntry.parseEntrySpec(entriesData[i]);
            if (!entry.getUser().equals(dataFile.getName())) {
                newEntries.add(entry.getEntrySpec());
            }
            ++i;
        }
        if (newEntry != null) {
            newEntries.add(newEntry.toString());
        }
        OCVSFileUtil.writeFileLines(entriesFile, newEntries.toArray(new String[0]));
    }

    protected void deleteFile(File dataFile) throws IOException {
        if (!dataFile.exists() || dataFile.delete()) {
            return;
        }
        throw new IOException(MessageFormat.format("cannot delete {0}", dataFile.getPath()));
    }

    private String createRepositoryPath(OCVSDirectory directory, String repositoryPath) throws IOException {
        String repositoryPathPrefix = directory.readRepository();
        StringBuffer repositoryPathBuffer = new StringBuffer();
        if (repositoryPathPrefix != null) {
            repositoryPathBuffer.append(repositoryPathPrefix);
            repositoryPathBuffer.append('/');
        }
        repositoryPathBuffer.append(repositoryPath);
        return repositoryPathBuffer.toString();
    }

    private void createAdministrativeFiles(File directoryFile, String repositoryPath, String root) throws IOException {
        OCVSFileUtil.writeFileLines(new File(directoryFile, OCVSFileNameConstants.CVSADM_ENT), new String[0]);
        OCVSFileUtil.writeFileLines(new File(directoryFile, OCVSFileNameConstants.CVSADM_REP), new String[]{repositoryPath});
        OCVSFileUtil.writeFileLines(new File(directoryFile, OCVSFileNameConstants.CVSADM_ROOT), new String[]{root});
    }

    private void throwMakeDirectoryException(String directoryName) throws IOException {
        throw new IOException(MessageFormat.format("cannot create directory {0}", directoryName));
    }
}

