/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ocvs.OCVSCheckedInHandler;
import oracle.ocvs.OCVSClearStaticDirHandler;
import oracle.ocvs.OCVSClearStickyHandler;
import oracle.ocvs.OCVSCopyFileHandler;
import oracle.ocvs.OCVSCreatedHandler;
import oracle.ocvs.OCVSMergedHandler;
import oracle.ocvs.OCVSModTimeHandler;
import oracle.ocvs.OCVSModuleExpnHandler;
import oracle.ocvs.OCVSNewEntryHandler;
import oracle.ocvs.OCVSRemoveEntryHandler;
import oracle.ocvs.OCVSRemovedHandler;
import oracle.ocvs.OCVSResponseHandler;
import oracle.ocvs.OCVSSetStaticDirHandler;
import oracle.ocvs.OCVSSetStickyHandler;
import oracle.ocvs.OCVSTemplateHandler;
import oracle.ocvs.OCVSUpdateExHandler;
import oracle.ocvs.OCVSUpdatedHandler;
import oracle.ocvs.OCVSValidRequestsHandler;

public class OCVSResponseRegistry
implements Cloneable {
    private static OCVSResponseRegistry _instance;
    private Map _responseHandlers;

    public OCVSResponseRegistry() {
    }

    public OCVSResponseRegistry(OCVSResponseRegistry registry) {
        this._responseHandlers = new HashMap(registry._responseHandlers);
    }

    public Object clone() {
        return new OCVSResponseRegistry(this);
    }

    public void registerResponseHandler(OCVSResponseHandler handler) {
        if (this._responseHandlers == null) {
            this._responseHandlers = new HashMap();
        }
        this._responseHandlers.put(handler.getResponseId(), handler);
    }

    public void deregisterResponseHandler(OCVSResponseHandler handler) {
        if (this._responseHandlers != null) {
            this._responseHandlers.remove(handler.getResponseId());
        }
    }

    public OCVSResponseHandler lookupResponseHandler(String id) {
        if (this._responseHandlers == null) {
            return null;
        }
        return (OCVSResponseHandler)this._responseHandlers.get(id);
    }

    public Set getResponseIdentifiers() {
        return this._responseHandlers != null ? Collections.unmodifiableSet(this._responseHandlers.keySet()) : Collections.EMPTY_SET;
    }

    public static final OCVSResponseRegistry getInstance() {
        if (_instance == null) {
            _instance = OCVSResponseRegistry.createDefaultResponseRegistry();
        }
        return _instance;
    }

    private static final OCVSResponseRegistry createDefaultResponseRegistry() {
        OCVSResponseRegistry registry = new OCVSResponseRegistry();
        registry.registerResponseHandler(new OCVSCheckedInHandler());
        registry.registerResponseHandler(new OCVSClearStaticDirHandler());
        registry.registerResponseHandler(new OCVSClearStickyHandler());
        registry.registerResponseHandler(new OCVSCopyFileHandler());
        registry.registerResponseHandler(new OCVSCreatedHandler());
        registry.registerResponseHandler(new OCVSMergedHandler());
        registry.registerResponseHandler(new OCVSModTimeHandler());
        registry.registerResponseHandler(new OCVSModuleExpnHandler());
        registry.registerResponseHandler(new OCVSNewEntryHandler());
        registry.registerResponseHandler(new OCVSRemoveEntryHandler());
        registry.registerResponseHandler(new OCVSRemovedHandler());
        registry.registerResponseHandler(new OCVSSetStaticDirHandler());
        registry.registerResponseHandler(new OCVSSetStickyHandler());
        registry.registerResponseHandler(new OCVSTemplateHandler());
        registry.registerResponseHandler(new OCVSUpdateExHandler());
        registry.registerResponseHandler(new OCVSUpdatedHandler());
        registry.registerResponseHandler(new OCVSValidRequestsHandler());
        return registry;
    }
}

