/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ocvs.OCVSPServerRoot;
import oracle.ocvs.OCVSPathName;
import oracle.ocvs.OCVSSsh2Root;

public class OCVSRoot {
    public static final String ACCESS_METHOD_PSERVER = "pserver";
    public static final String ACCESS_METHOD_FORK = "fork";
    public static final String ACCESS_METHOD_EXT = "ext";
    public static final String ACCESS_METHOD_SSH2 = "ssh2";
    private static final String PATH_RE = "(\\p{Alpha}:.+)|(/.*)";
    private final String _rootSpec;
    private final String _accessMethod;
    private final String _userName;
    private final String _hostName;
    private final String _repository;

    public OCVSRoot(String rootSpec, String accessMethod, String userName, String hostName, String repository) {
        this._rootSpec = rootSpec;
        this._accessMethod = accessMethod;
        this._userName = userName;
        this._hostName = hostName;
        this._repository = this.convertToServerRoot(repository);
    }

    public String getRootSpec() {
        return this._rootSpec;
    }

    public String getAccessMethod() {
        return this._accessMethod;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getRepository() {
        return this._repository;
    }

    public boolean isAccessPServer() {
        return this._accessMethod.equals(ACCESS_METHOD_PSERVER);
    }

    public boolean isAccessFork() {
        return this._accessMethod.equals(ACCESS_METHOD_FORK);
    }

    public boolean isAccessExt() {
        return this._accessMethod.equals(ACCESS_METHOD_EXT);
    }

    public boolean isAccessSsh2() {
        return this._accessMethod.equals(ACCESS_METHOD_SSH2);
    }

    public String toString() {
        OCVSPServerRoot pserverRoot;
        StringBuffer rootBuffer = new StringBuffer();
        rootBuffer.append(':');
        rootBuffer.append(this._accessMethod);
        if (this.isAccessPServer()) {
            OCVSPServerRoot pserverRoot2 = (OCVSPServerRoot)this;
            if (pserverRoot2.getProxy() != null) {
                rootBuffer.append("#proxy=");
                rootBuffer.append(pserverRoot2.getProxy());
            }
            if (pserverRoot2.getProxyPort() != null) {
                rootBuffer.append("#proxyport=");
                rootBuffer.append(pserverRoot2.getProxyPort());
            }
        }
        if (this.isAccessSsh2()) {
            OCVSSsh2Root ssh2Root = (OCVSSsh2Root)this;
            if (ssh2Root.getKey() != null) {
                rootBuffer.append("#key=");
                rootBuffer.append(ssh2Root.getKey());
            }
            if (ssh2Root.getProxy() != null) {
                rootBuffer.append("#proxy=");
                rootBuffer.append(ssh2Root.getProxy());
            }
            if (ssh2Root.getProxyPort() != null) {
                rootBuffer.append("#proxyport=");
                rootBuffer.append(ssh2Root.getProxyPort());
            }
        }
        if (this.isAccessPServer() || this.isAccessExt()) {
            rootBuffer.append(':');
            rootBuffer.append(this._userName);
            rootBuffer.append('@');
            rootBuffer.append(this._hostName);
        }
        if (this.isAccessPServer() && (pserverRoot = (OCVSPServerRoot)this).getPort() != null) {
            rootBuffer.append(':');
            rootBuffer.append(pserverRoot.getPort());
        }
        rootBuffer.append(':');
        rootBuffer.append(this._repository);
        return rootBuffer.toString();
    }

    private String convertToServerRoot(String repository) {
        if (repository.equals("")) {
            return repository;
        }
        if ((repository = OCVSPathName.trimServerSeparators(repository)).equals("")) {
            return Character.toString('/');
        }
        return repository;
    }

    public static final OCVSRoot parseRootSpec(String rootSpec) throws ParseException {
        Pattern pattern = Pattern.compile(":([^:#/]+)((?:#[^:/]+=(?:'[^']*'|[^:/]*))*)((?::|/??).*)");
        Matcher matcher = pattern.matcher(rootSpec);
        if (!matcher.matches()) {
            pattern = Pattern.compile(PATH_RE);
            if (!pattern.matcher(rootSpec).matches()) {
                OCVSRoot.throwBadRootException(rootSpec);
            }
            return OCVSRoot.parseForkRootSpec(new RootInfo(":fork:" + rootSpec, ":" + rootSpec));
        }
        String accessMethod = matcher.group(1);
        String accessFields = matcher.group(2);
        RootInfo rootInfo = new RootInfo(rootSpec, matcher.group(3));
        String[] accessFieldArray = null;
        if (accessFields != null && !accessFields.equals("")) {
            accessFields = accessFields.substring(1);
            accessFieldArray = accessFields.split("[#=]");
            pattern = Pattern.compile("^'([^']+)'$");
            int i = 0;
            while (i < accessFieldArray.length) {
                matcher = pattern.matcher(accessFieldArray[i]);
                if (matcher.matches()) {
                    accessFieldArray[i] = matcher.group(1);
                }
                ++i;
            }
        }
        rootInfo.setAccessFieldArray(accessFieldArray);
        if (accessMethod.equals(ACCESS_METHOD_FORK)) {
            return OCVSRoot.parseForkRootSpec(rootInfo);
        }
        if (accessMethod.equals(ACCESS_METHOD_PSERVER)) {
            return OCVSRoot.parsePServerRootSpec(rootInfo);
        }
        if (accessMethod.equals(ACCESS_METHOD_EXT)) {
            return OCVSRoot.parseExtRootSpec(rootInfo);
        }
        if (accessMethod.equals(ACCESS_METHOD_SSH2)) {
            return OCVSRoot.parseSsh2RootSpec(rootInfo);
        }
        throw new ParseException(MessageFormat.format("the :{0}: access method is not supported", accessMethod), 0);
    }

    private static final OCVSRoot parseForkRootSpec(RootInfo rootInfo) throws ParseException {
        Pattern pattern = Pattern.compile("(:|/??)((\\p{Alpha}:.+)|(/.*))");
        Matcher matcher = pattern.matcher(rootInfo.getRootRemainder());
        if (!matcher.matches()) {
            OCVSRoot.throwBadRootException(rootInfo.getRootSpec());
        }
        return new OCVSRoot(rootInfo.getRootSpec(), ACCESS_METHOD_FORK, null, null, matcher.group(2));
    }

    private static final OCVSRoot parsePServerRootSpec(RootInfo rootInfo) throws ParseException {
        Pattern pattern = Pattern.compile(":(.+)@([^:]+)(:\\d+)?(:|/??)((\\p{Alpha}:.+)|(/.*))");
        Matcher matcher = pattern.matcher(rootInfo.getRootRemainder());
        if (!matcher.matches()) {
            OCVSRoot.throwBadRootException(rootInfo.getRootSpec());
        }
        String port = null;
        String proxy = OCVSRoot.extractAccessVariable("proxy", rootInfo.getAccessFieldArray());
        String proxyPort = OCVSRoot.extractAccessVariable("proxyport", rootInfo.getAccessFieldArray());
        if (matcher.group(3) != null) {
            port = matcher.group(3).replace(':', ' ').trim();
        }
        return new OCVSPServerRoot(rootInfo.getRootSpec(), matcher.group(1), matcher.group(2), port, matcher.group(5), proxy, proxyPort);
    }

    private static final OCVSRoot parseExtRootSpec(RootInfo rootInfo) throws ParseException {
        Pattern pattern = Pattern.compile(":(.+)@([^:]+)(:|/??)((\\p{Alpha}:.+)|(/.*))");
        Matcher matcher = pattern.matcher(rootInfo.getRootRemainder());
        if (!matcher.matches()) {
            OCVSRoot.throwBadRootException(rootInfo.getRootSpec());
        }
        return new OCVSRoot(rootInfo.getRootSpec(), ACCESS_METHOD_EXT, matcher.group(1), matcher.group(2), matcher.group(4));
    }

    private static final OCVSRoot parseSsh2RootSpec(RootInfo rootInfo) throws ParseException {
        Pattern pattern = Pattern.compile(":(.+)@([^:]+)(:|/??)((\\p{Alpha}:.+)|(/.*))");
        Matcher matcher = pattern.matcher(rootInfo.getRootRemainder());
        if (!matcher.matches()) {
            OCVSRoot.throwBadRootException(rootInfo.getRootSpec());
        }
        String key = OCVSRoot.extractAccessVariable("key", rootInfo.getAccessFieldArray());
        String proxy = OCVSRoot.extractAccessVariable("proxy", rootInfo.getAccessFieldArray());
        String proxyPort = OCVSRoot.extractAccessVariable("proxyport", rootInfo.getAccessFieldArray());
        return new OCVSSsh2Root(rootInfo.getRootSpec(), matcher.group(1), matcher.group(2), matcher.group(4), key, proxy, proxyPort);
    }

    private static final String extractAccessVariable(String id, String[] accessFieldArray) {
        if (accessFieldArray == null) {
            return null;
        }
        int i = 0;
        while (i < accessFieldArray.length) {
            if (accessFieldArray[i].toLowerCase().equals(id) && ++i < accessFieldArray.length) {
                return accessFieldArray[i];
            }
            ++i;
        }
        return null;
    }

    private static final void throwBadRootException(String rootSpec) throws ParseException {
        throw new ParseException(MessageFormat.format("bad CVSroot: {0}", rootSpec), 0);
    }

    private static class RootInfo {
        private final String _rootSpec;
        private final String _rootRemainder;
        private String[] _accessFieldArray;

        RootInfo(String rootSpec, String rootRemainder) {
            this._rootSpec = rootSpec;
            this._rootRemainder = rootRemainder;
        }

        public String getRootSpec() {
            return this._rootSpec;
        }

        public String getRootRemainder() {
            return this._rootRemainder;
        }

        public void setAccessFieldArray(String[] accessFieldArray) {
            this._accessFieldArray = accessFieldArray;
        }

        public String[] getAccessFieldArray() {
            return this._accessFieldArray;
        }
    }
}

