/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.ocvs.OCVSConnection;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSFileUtil;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSSessionIO;
import oracle.ocvs.OCVSValidRequests;

public class OCVSSession {
    public static final int FTYPE_TEXT = 0;
    public static final int FTYPE_BINARY = 1;
    private final OCVSSessionIO _io;
    private final File _dir;
    private final OCVSRoot _root;
    private final OCVSConnection _connection;
    private OCVSResponseRegistry _responseRegistry;
    private int _compressionLevel;
    private boolean _noExecDisk;
    private boolean _noConvertEols;
    private String _charsetName;
    private String _validRequests;
    private Date _modTime;
    private Collection _moduleExpansions;
    private Collection _wrappers;

    public OCVSSession(OCVSSessionIO io, File dir, OCVSRoot root, OCVSConnection connection) {
        this._io = io;
        this._dir = dir;
        this._root = root;
        this._connection = connection;
    }

    public OCVSSessionIO getSessionIO() {
        return this._io;
    }

    public File getWorkingDirectory() {
        return this._dir;
    }

    public OCVSRoot getRoot() {
        return this._root;
    }

    public OCVSConnection getConnection() {
        return this._connection;
    }

    public void setResponseRegistry(OCVSResponseRegistry responseRegistry) {
        this._responseRegistry = responseRegistry;
    }

    public OCVSResponseRegistry getResponseRegistry() {
        return this._responseRegistry;
    }

    public void setCompressionLevel(int compressionLevel) {
        this._compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    public void setNoExecDisk(boolean noExecDisk) {
        this._noExecDisk = noExecDisk;
    }

    public boolean isNoExecDisk() {
        return this._noExecDisk;
    }

    public void setNoConvertEOLs(boolean noConvertEols) {
        this._noConvertEols = noConvertEols;
    }

    public boolean isNoConvertEOLs() {
        return this._noConvertEols;
    }

    public void setEncoding(String charsetName) {
        this._charsetName = charsetName;
    }

    public String getEncoding() {
        return this._charsetName;
    }

    public boolean isRequestValid(String id) {
        return this._validRequests != null && this._validRequests.indexOf(' ' + id + ' ') >= 0;
    }

    public void setWrappers(Collection wrappers) {
        this._wrappers = wrappers;
    }

    public Collection getWrappers() {
        return this._wrappers;
    }

    public void setValidRequests(String validRequests) {
        this._validRequests = ' ' + validRequests + ' ';
    }

    public void setModTime(Date modTime) {
        this._modTime = modTime;
    }

    public Date getModTime() {
        return this._modTime;
    }

    public void addModuleExpansion(String moduleExpansion) {
        if (this._moduleExpansions == null) {
            this._moduleExpansions = new ArrayList();
        }
        this._moduleExpansions.add(moduleExpansion);
    }

    public String[] getModuleExpansions() {
        return this._moduleExpansions != null ? this._moduleExpansions.toArray(new String[0]) : new String[]{};
    }

    public void sendRootEtCetera() throws IOException {
        this._connection.startLogging();
        this._connection.writeLine("Valid-responses " + this.createResponseList());
        try {
            new OCVSValidRequests().executeRequest(this);
        }
        catch (OCVSException oCVSException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this._connection.writeLine("UseUnchanged");
        this._connection.writeLine("Root " + this._root.getRepository());
        if (!OCVSFileUtil.isFileSystemCaseSensitive() && this.isRequestValid("Case")) {
            this._connection.writeLine("Case");
        }
        if (this._compressionLevel > 0 && this.isRequestValid("gzip-file-contents")) {
            this._connection.writeLine("gzip-file-contents " + Integer.toString(this._compressionLevel));
        } else {
            this._compressionLevel = 0;
        }
    }

    public void sendGlobalOption(String option) throws IOException {
        this._connection.writeLine("Global_option " + option);
    }

    public void sendArgument(byte[] argument) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String request = "Argument ";
        int i = 0;
        while (true) {
            if (i < argument.length && argument[i] != 13 && argument[i] != 10) {
                baos.write(argument[i]);
            } else {
                this._connection.write(request);
                this._connection.write(baos.toByteArray());
                this._connection.writeLine();
                baos.reset();
                if (i >= argument.length) break;
                request = "Argumentx ";
            }
            ++i;
        }
    }

    public void sendArgument(String argument) throws IOException {
        if (argument.indexOf(13) < 0 && argument.indexOf(10) < 0) {
            this._connection.writeLine("Argument " + argument);
            return;
        }
        BufferedReader br = new BufferedReader(new StringReader(argument));
        this.sendArgument(br.readLine());
        while ((argument = br.readLine()) != null) {
            this._connection.writeLine("Argumentx " + argument);
        }
    }

    public void sendDirectory(String localDir, String remoteDir) throws IOException {
        if (localDir.length() <= 0) {
            localDir = ".";
        }
        this._connection.writeLine("Directory " + localDir);
        this._connection.writeLine(remoteDir);
    }

    public void sendEntry(String entry) throws IOException {
        this._connection.writeLine("Entry " + entry);
    }

    public void sendUnchanged(String fileName) throws IOException {
        this._connection.writeLine("Unchanged " + fileName);
    }

    public void sendModified(File file, int type) throws IOException {
        this._connection.writeLine("Modified " + file.getName());
        this._connection.writeLine(file.canWrite() ? "u=rw,g=rw,o=r" : "u=r,g=r,o=r");
        File eolFile = null;
        if (type == 0 && !OCVSFileUtil.IS_LF_PLATFORM && !this._noConvertEols) {
            file = eolFile = OCVSFileUtil.createServerEOLFile(file);
        }
        this.sendFile(file);
        if (eolFile != null) {
            eolFile.delete();
        }
    }

    public void sendIsModified(File file, int type) throws IOException {
        if (!this.isRequestValid("Is-modified")) {
            this.sendModified(file, type);
            return;
        }
        this._connection.writeLine("Is-modified " + file.getName());
    }

    public void sendQuestionable(String fileName) throws IOException {
        this._connection.writeLine("Questionable " + fileName);
    }

    public void sendStaticDirectory() throws IOException {
        this._connection.writeLine("Static-directory");
    }

    public void sendSticky(String tagSpec) throws IOException {
        this._connection.writeLine("Sticky " + tagSpec);
    }

    public void sendRequest(String request) throws IOException {
        this._connection.writeLine(request);
    }

    public String receiveLine() throws IOException {
        return this._connection.readLine();
    }

    public byte[] receiveLineBytes() throws IOException {
        return this._connection.readLineBytes();
    }

    public File receiveModeFile(int type) throws IOException {
        String mode = this.receiveLine();
        File file = this.receiveFile(type);
        if (mode.indexOf("u=rw") < 0) {
            file.setReadOnly();
        }
        return file;
    }

    public File receiveFile(int type) throws IOException {
        String sizeLine = this.receiveLine();
        boolean compressed = false;
        if (sizeLine.charAt(0) == 'z') {
            sizeLine = sizeLine.substring(1);
            compressed = true;
        }
        long len = Long.parseLong(sizeLine);
        File file = OCVSFileUtil.createTempFile(null);
        FileOutputStream fos = new FileOutputStream(file);
        if (compressed) {
            OCVSConnection.pipeStream(new GZIPInputStream(new SizedInputStream(this._connection.getInputStream(), len)), fos, Long.MAX_VALUE);
        } else {
            this._connection.pipeInput(fos, len);
        }
        fos.close();
        if (type == 0 && !OCVSFileUtil.IS_LF_PLATFORM && !this._noConvertEols) {
            File eolFile = OCVSFileUtil.createPlatformEOLFile(file);
            file.delete();
            file = eolFile;
        }
        file.deleteOnExit();
        return file;
    }

    private String createResponseList() {
        StringBuffer responseBuffer = new StringBuffer("ok error M E");
        Iterator itr = this._responseRegistry.getResponseIdentifiers().iterator();
        while (itr.hasNext()) {
            responseBuffer.append(' ');
            responseBuffer.append((String)itr.next());
        }
        return responseBuffer.toString();
    }

    private void sendFile(File file) throws IOException {
        if (this._compressionLevel > 0) {
            this.sendCompressedFile(file);
            return;
        }
        long len = file.length();
        this._connection.writeLine(String.valueOf(len));
        FileInputStream fis = new FileInputStream(file);
        this._connection.pipeOutput(fis, len);
        fis.close();
    }

    private void sendCompressedFile(File file) throws IOException {
        CounterOutputStream cos = new CounterOutputStream(null);
        long len = file.length();
        FileInputStream fis = new FileInputStream(file);
        GZIPOutputStream gzos = new GZIPOutputStream(cos);
        OCVSConnection.pipeStream(fis, gzos, len);
        gzos.close();
        fis.close();
        this._connection.writeLine("z" + Long.toString(cos.getCount()));
        fis = new FileInputStream(file);
        gzos = new GZIPOutputStream(this._connection.getOutputStream());
        OCVSConnection.pipeStream(fis, gzos, len);
        gzos.finish();
        fis.close();
    }

    private class CounterOutputStream
    extends OutputStream {
        private long _count;

        public void write(int c) throws IOException {
            ++this._count;
        }

        public long getCount() {
            return this._count;
        }

        private CounterOutputStream() {
        }

        CounterOutputStream(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class SizedInputStream
    extends FilterInputStream {
        private long _size;

        SizedInputStream(InputStream inputStream, long size) {
            super(inputStream);
            this._size = size;
        }

        public void close() throws IOException {
            this._size = -1;
        }

        public int available() throws IOException {
            if (this._size <= 0L) {
                return -1;
            }
            return (int)Math.min((long)super.available(), this._size);
        }

        public int read() throws IOException {
            if (this._size <= 0L) {
                return -1;
            }
            --this._size;
            return super.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this._size <= 0L) {
                return -1;
            }
            int n = super.read(b, off, len = (int)Math.min(this._size, (long)len));
            if (n > 0) {
                this._size -= (long)n;
            }
            return n;
        }

        public long skip(long n) throws IOException {
            if (this._size <= 0L) {
                return 0L;
            }
            return super.skip(Math.min(n, this._size));
        }

        public boolean markSupported() {
            return false;
        }
    }
}

