/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import oracle.ocvs.OCVSCommand;
import oracle.ocvs.OCVSException;
import oracle.ocvs.OCVSFileStateVisitor;
import oracle.ocvs.OCVSOption;
import oracle.ocvs.OCVSPruneDirectoriesVisitor;
import oracle.ocvs.OCVSResource;
import oracle.ocvs.OCVSSession;

public class OCVSUpdate
extends OCVSCommand {
    public static final OCVSOption OPTION_CREATE_AND_UPDATE_NEW_DIRS = new OCVSOption("-d", 2);
    public static final OCVSOption OPTION_RESET_STICKY_OPTIONS = new OCVSOption("-A", 2);
    public static final OCVSOption OPTION_PRUNE_EMPTY_DIRECTORIES = new OCVSOption("-P", 2);
    public static final OCVSOption OPTION_SEND_UPDATES_TO_STANDARD_OUTPUT = new OCVSOption("-p", 2);
    public static final OCVSOption OPTION_OVERWRITE_FILES_WITH_CLEAN_COPIES = new OCVSOption("-C", 2);
    public static final OCVSOption OPTION_MERGE_CHANGES_FROM_REVISION = new OCVSOption("-j", 2);

    public OCVSUpdate() {
        super("update");
    }

    public String getCommandId() {
        return "update";
    }

    protected void initializeResourceVisitor(OCVSFileStateVisitor visitor, Map options) {
        super.initializeResourceVisitor(visitor, options);
        if (options.containsKey(OPTION_OVERWRITE_FILES_WITH_CLEAN_COPIES)) {
            visitor.setUseIsModified(true);
        }
    }

    protected void sessionFinished(OCVSSession session, Map options, OCVSResource[] resources) throws IOException, ParseException, OCVSException {
        if (session.isNoExecDisk()) {
            return;
        }
        if (!options.containsKey(OPTION_PRUNE_EMPTY_DIRECTORIES)) {
            return;
        }
        OCVSPruneDirectoriesVisitor visitor = new OCVSPruneDirectoriesVisitor();
        this.initializeBaseResourceVisitor(visitor, options);
        visitor.visit(session, resources);
    }
}

