/*
 * Decompiled with CFR 0.152.
 */
package oracle.ocvs;

import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.ocvs.OCVSProcessIO;

class OCVSUserInfo
implements UserInfo {
    private static final transient Map _passwords = new HashMap();
    private final Object _userId;
    private final OCVSProcessIO _io;
    private String _passphrase;
    private String _password;
    private boolean _noPassphrase;

    OCVSUserInfo(Object userId, OCVSProcessIO io) {
        this._userId = userId;
        this._io = io;
    }

    public String getPassphrase() {
        return this._passphrase;
    }

    public String getPassword() {
        return this._password;
    }

    void cachePassword() {
        if (this._password != null) {
            _passwords.put(this._userId, this._password);
        }
    }

    void setNoPassphrase(boolean noPassphrase) {
        this._noPassphrase = noPassphrase;
    }

    public boolean promptPassword(String message) {
        if (this._noPassphrase) {
            this._password = (String)_passwords.get(this._userId);
            if (this._password != null) {
                return true;
            }
        }
        try {
            this._password = null;
            this._password = this._io.getPrompter().promptSsh2Password(message);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this._password != null;
    }

    public boolean promptPassphrase(String message) {
        if (this._noPassphrase) {
            return false;
        }
        try {
            this._passphrase = null;
            this._passphrase = this._io.getPrompter().promptSsh2Passphrase(message);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return this._passphrase != null;
    }

    public boolean promptYesNo(String message) {
        try {
            boolean bl = this._io.getPrompter().promptSsh2YesNo(message);
            return bl;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public void showMessage(String message) {
        this._io._out.println(message);
    }
}

